/* chainDb.h was originally generated by the autoSql program, which also 
 * generated chainDb.c and chainDb.sql.  This header links the database and
 * the RAM representation of objects. 
 *
 * Note that this was built after the 'chainBlock' routine, which
 * was developed around a flat .chain file which is structured
 * fairly differently than the database table.   However this
 * module does refer to the same chain structure as is in chainBlock.*/

/* Copyright (C) 2009 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef CHAINDB_H
#define CHAINDB_H

#ifndef CHAINBLOCK_H
#include "chainBlock.h"
#endif

void chainHeadStaticLoad(char **row, struct chain *ret);
/* Load a row from chain table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct chain *chainHeadLoad(char **row);
/* Load a chain from row fetched with select * from chain
 * from database.  Dispose of this with chainFree(). */

struct chain *chainHeadLoadAll(char *fileName);
/* Load all chain from a tab-separated file.
 * Dispose of this with chainFreeList(). */

struct chain *chainHeadCommaIn(char **pS, struct chain *ret);
/* Create a chain out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new chain */

void chainHeadOutput(struct chain *el, FILE *f, char sep, char lastSep);
/* Print out chain.  Separate fields with sep. Follow last field with lastSep. */

#define chainHeadTabOut(el,f) chainHeadOutput(el,f,'\t','\n');
/* Print out chain as a line in a tab-separated file. */

#define chainHeadCommaOut(el,f) chainHeadOutput(el,f,',',',');
/* Print out chain as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void chainDbAddBlocks(struct chain *chain, char *track, struct sqlConnection *conn);
/* Add blocks to chain header. */

#endif /* CHAINDB_H */

