/* cddDesc.c was originally generated by the autoSql program, which also 
 * generated cddDesc.h and cddDesc.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cddDesc.h"


void cddDescStaticLoad(char **row, struct cddDesc *ret)
/* Load a row from cddDesc table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->cddid = sqlUnsigned(row[0]);
ret->accession = row[1];
ret->cddname = row[2];
ret->name = row[3];
ret->cdddesc = row[4];
ret->cddlength = sqlUnsigned(row[5]);
}

struct cddDesc *cddDescLoad(char **row)
/* Load a cddDesc from row fetched with select * from cddDesc
 * from database.  Dispose of this with cddDescFree(). */
{
struct cddDesc *ret;

AllocVar(ret);
ret->cddid = sqlUnsigned(row[0]);
ret->accession = cloneString(row[1]);
ret->cddname = cloneString(row[2]);
ret->name = cloneString(row[3]);
ret->cdddesc = cloneString(row[4]);
ret->cddlength = sqlUnsigned(row[5]);
return ret;
}

struct cddDesc *cddDescLoadAll(char *fileName) 
/* Load all cddDesc from a whitespace-separated file.
 * Dispose of this with cddDescFreeList(). */
{
struct cddDesc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = cddDescLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cddDesc *cddDescLoadAllByChar(char *fileName, char chopper) 
/* Load all cddDesc from a chopper separated file.
 * Dispose of this with cddDescFreeList(). */
{
struct cddDesc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cddDescLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cddDesc *cddDescCommaIn(char **pS, struct cddDesc *ret)
/* Create a cddDesc out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cddDesc */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->cddid = sqlUnsignedComma(&s);
ret->accession = sqlStringComma(&s);
ret->cddname = sqlStringComma(&s);
ret->name = sqlStringComma(&s);
ret->cdddesc = sqlStringComma(&s);
ret->cddlength = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void cddDescFree(struct cddDesc **pEl)
/* Free a single dynamically allocated cddDesc such as created
 * with cddDescLoad(). */
{
struct cddDesc *el;

if ((el = *pEl) == NULL) return;
freeMem(el->accession);
freeMem(el->cddname);
freeMem(el->name);
freeMem(el->cdddesc);
freez(pEl);
}

void cddDescFreeList(struct cddDesc **pList)
/* Free a list of dynamically allocated cddDesc's */
{
struct cddDesc *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cddDescFree(&el);
    }
*pList = NULL;
}

void cddDescOutput(struct cddDesc *el, FILE *f, char sep, char lastSep) 
/* Print out cddDesc.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->cddid);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->accession);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cddname);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cdddesc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->cddlength);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

