/* geneCheck.c was originally generated by the autoSql program, which also 
 * generated geneCheck.h and geneCheck.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "geneCheck.h"


void geneCheckStaticLoad(char **row, struct geneCheck *ret)
/* Load a row from geneCheck table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->acc = row[0];
ret->chr = row[1];
ret->chrStart = sqlUnsigned(row[2]);
ret->chrEnd = sqlUnsigned(row[3]);
strcpy(ret->strand, row[4]);
strcpy(ret->stat, row[5]);
strcpy(ret->frame, row[6]);
strcpy(ret->start, row[7]);
strcpy(ret->stop, row[8]);
ret->orfStop = sqlUnsigned(row[9]);
ret->cdsGap = sqlUnsigned(row[10]);
ret->cdsMult3Gap = sqlUnsigned(row[11]);
ret->utrGap = sqlUnsigned(row[12]);
ret->cdsSplice = sqlUnsigned(row[13]);
ret->utrSplice = sqlUnsigned(row[14]);
ret->numExons = sqlUnsigned(row[15]);
ret->numCds = sqlUnsigned(row[16]);
ret->numUtr5 = sqlUnsigned(row[17]);
ret->numUtr3 = sqlUnsigned(row[18]);
ret->numCdsIntrons = sqlUnsigned(row[19]);
ret->numUtrIntrons = sqlUnsigned(row[20]);
strcpy(ret->nmd, row[21]);
ret->causes = row[22];
}

struct geneCheck *geneCheckLoad(char **row)
/* Load a geneCheck from row fetched with select * from geneCheck
 * from database.  Dispose of this with geneCheckFree(). */
{
struct geneCheck *ret;

AllocVar(ret);
ret->acc = cloneString(row[0]);
ret->chr = cloneString(row[1]);
ret->chrStart = sqlUnsigned(row[2]);
ret->chrEnd = sqlUnsigned(row[3]);
strcpy(ret->strand, row[4]);
strcpy(ret->stat, row[5]);
strcpy(ret->frame, row[6]);
strcpy(ret->start, row[7]);
strcpy(ret->stop, row[8]);
ret->orfStop = sqlUnsigned(row[9]);
ret->cdsGap = sqlUnsigned(row[10]);
ret->cdsMult3Gap = sqlUnsigned(row[11]);
ret->utrGap = sqlUnsigned(row[12]);
ret->cdsSplice = sqlUnsigned(row[13]);
ret->utrSplice = sqlUnsigned(row[14]);
ret->numExons = sqlUnsigned(row[15]);
ret->numCds = sqlUnsigned(row[16]);
ret->numUtr5 = sqlUnsigned(row[17]);
ret->numUtr3 = sqlUnsigned(row[18]);
ret->numCdsIntrons = sqlUnsigned(row[19]);
ret->numUtrIntrons = sqlUnsigned(row[20]);
strcpy(ret->nmd, row[21]);
ret->causes = cloneString(row[22]);
return ret;
}

struct geneCheck *geneCheckLoadAll(char *fileName) 
/* Load all geneCheck from a whitespace-separated file.
 * Dispose of this with geneCheckFreeList(). */
{
struct geneCheck *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[23];

while (lineFileRow(lf, row))
    {
    el = geneCheckLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct geneCheck *geneCheckLoadAllByChar(char *fileName, char chopper) 
/* Load all geneCheck from a chopper separated file.
 * Dispose of this with geneCheckFreeList(). */
{
struct geneCheck *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[23];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = geneCheckLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct geneCheck *geneCheckCommaIn(char **pS, struct geneCheck *ret)
/* Create a geneCheck out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new geneCheck */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->acc = sqlStringComma(&s);
ret->chr = sqlStringComma(&s);
ret->chrStart = sqlUnsignedComma(&s);
ret->chrEnd = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
sqlFixedStringComma(&s, ret->stat, sizeof(ret->stat));
sqlFixedStringComma(&s, ret->frame, sizeof(ret->frame));
sqlFixedStringComma(&s, ret->start, sizeof(ret->start));
sqlFixedStringComma(&s, ret->stop, sizeof(ret->stop));
ret->orfStop = sqlUnsignedComma(&s);
ret->cdsGap = sqlUnsignedComma(&s);
ret->cdsMult3Gap = sqlUnsignedComma(&s);
ret->utrGap = sqlUnsignedComma(&s);
ret->cdsSplice = sqlUnsignedComma(&s);
ret->utrSplice = sqlUnsignedComma(&s);
ret->numExons = sqlUnsignedComma(&s);
ret->numCds = sqlUnsignedComma(&s);
ret->numUtr5 = sqlUnsignedComma(&s);
ret->numUtr3 = sqlUnsignedComma(&s);
ret->numCdsIntrons = sqlUnsignedComma(&s);
ret->numUtrIntrons = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->nmd, sizeof(ret->nmd));
ret->causes = sqlStringComma(&s);
*pS = s;
return ret;
}

void geneCheckFree(struct geneCheck **pEl)
/* Free a single dynamically allocated geneCheck such as created
 * with geneCheckLoad(). */
{
struct geneCheck *el;

if ((el = *pEl) == NULL) return;
freeMem(el->acc);
freeMem(el->chr);
freeMem(el->causes);
freez(pEl);
}

void geneCheckFreeList(struct geneCheck **pList)
/* Free a list of dynamically allocated geneCheck's */
{
struct geneCheck *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    geneCheckFree(&el);
    }
*pList = NULL;
}

void geneCheckOutput(struct geneCheck *el, FILE *f, char sep, char lastSep) 
/* Print out geneCheck.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->acc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chr);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chrStart);
fputc(sep,f);
fprintf(f, "%u", el->chrEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->stat);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->frame);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->start);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->stop);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->orfStop);
fputc(sep,f);
fprintf(f, "%u", el->cdsGap);
fputc(sep,f);
fprintf(f, "%u", el->cdsMult3Gap);
fputc(sep,f);
fprintf(f, "%u", el->utrGap);
fputc(sep,f);
fprintf(f, "%u", el->cdsSplice);
fputc(sep,f);
fprintf(f, "%u", el->utrSplice);
fputc(sep,f);
fprintf(f, "%u", el->numExons);
fputc(sep,f);
fprintf(f, "%u", el->numCds);
fputc(sep,f);
fprintf(f, "%u", el->numUtr5);
fputc(sep,f);
fprintf(f, "%u", el->numUtr3);
fputc(sep,f);
fprintf(f, "%u", el->numCdsIntrons);
fputc(sep,f);
fprintf(f, "%u", el->numUtrIntrons);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->nmd);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->causes);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

