/* arCOGs.h was originally generated by the autoSql program, which also 
 * generated arCOGs.c and arCOGs.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2009 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ARCOGS_H
#define ARCOGS_H

#define ARCOGS_NUM_COLS 7

struct arCOGs
/* arCOG Information */
    {
    struct arCOGs *next;  /* Next in singly linked list. */
    char *chrom;	/* chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* hit name */
    unsigned score;	/* Score from 900-1000.  1000 is best */
    char strand[2];	/* Value should be + or - */
    char *gene;	/* standard name */
    };

void arCOGsStaticLoad(char **row, struct arCOGs *ret);
/* Load a row from arCOGs table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct arCOGs *arCOGsLoad(char **row);
/* Load a arCOGs from row fetched with select * from arCOGs
 * from database.  Dispose of this with arCOGsFree(). */

struct arCOGs *arCOGsLoadAll(char *fileName);
/* Load all arCOGs from whitespace-separated file.
 * Dispose of this with arCOGsFreeList(). */

struct arCOGs *arCOGsLoadAllByChar(char *fileName, char chopper);
/* Load all arCOGs from chopper separated file.
 * Dispose of this with arCOGsFreeList(). */

#define arCOGsLoadAllByTab(a) arCOGsLoadAllByChar(a, '\t');
/* Load all arCOGs from tab separated file.
 * Dispose of this with arCOGsFreeList(). */

struct arCOGs *arCOGsCommaIn(char **pS, struct arCOGs *ret);
/* Create a arCOGs out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new arCOGs */

void arCOGsFree(struct arCOGs **pEl);
/* Free a single dynamically allocated arCOGs such as created
 * with arCOGsLoad(). */

void arCOGsFreeList(struct arCOGs **pList);
/* Free a list of dynamically allocated arCOGs's */

void arCOGsOutput(struct arCOGs *el, FILE *f, char sep, char lastSep);
/* Print out arCOGs.  Separate fields with sep. Follow last field with lastSep. */

#define arCOGsTabOut(el,f) arCOGsOutput(el,f,'\t','\n');
/* Print out arCOGs as a line in a tab-separated file. */

#define arCOGsCommaOut(el,f) arCOGsOutput(el,f,',',',');
/* Print out arCOGs as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ARCOGS_H */

