/* ecCode.h was originally generated by the autoSql program, which also 
 * generated ecCode.c and ecCode.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2005 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ECCODE_H
#define ECCODE_H

#define ECCODE_NUM_COLS 6

struct ecCode
/* Enzyme Commission (EC) code */
    {
    struct ecCode *next;  /* Next in singly linked list. */
    unsigned level1;	/* level 1 EC code */
    unsigned level2;	/* level 2 EC code */
    unsigned level3;	/* level 3 EC code */
    unsigned level4;	/* level 4 EC code */
    char *ec;	/* ec number (1.1.1.1) */
    char *description;	/* EC code description */
    };

void ecCodeStaticLoad(char **row, struct ecCode *ret);
/* Load a row from ecCode table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct ecCode *ecCodeLoad(char **row);
/* Load a ecCode from row fetched with select * from ecCode
 * from database.  Dispose of this with ecCodeFree(). */

struct ecCode *ecCodeLoadAll(char *fileName);
/* Load all ecCode from whitespace-separated file.
 * Dispose of this with ecCodeFreeList(). */

struct ecCode *ecCodeLoadAllByChar(char *fileName, char chopper);
/* Load all ecCode from chopper separated file.
 * Dispose of this with ecCodeFreeList(). */

#define ecCodeLoadAllByTab(a) ecCodeLoadAllByChar(a, '\t');
/* Load all ecCode from tab separated file.
 * Dispose of this with ecCodeFreeList(). */

struct ecCode *ecCodeCommaIn(char **pS, struct ecCode *ret);
/* Create a ecCode out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ecCode */

void ecCodeFree(struct ecCode **pEl);
/* Free a single dynamically allocated ecCode such as created
 * with ecCodeLoad(). */

void ecCodeFreeList(struct ecCode **pList);
/* Free a list of dynamically allocated ecCode's */

void ecCodeOutput(struct ecCode *el, FILE *f, char sep, char lastSep);
/* Print out ecCode.  Separate fields with sep. Follow last field with lastSep. */

#define ecCodeTabOut(el,f) ecCodeOutput(el,f,'\t','\n');
/* Print out ecCode as a line in a tab-separated file. */

#define ecCodeCommaOut(el,f) ecCodeOutput(el,f,',',',');
/* Print out ecCode as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ECCODE_H */

