from pycbio.sys.symEnum import SymEnum, SymEnumValue, auto

class GencodeTag(SymEnum):
    "GENCODE tag definitions"

    pseudo_cons_2way = SymEnumValue(auto(), "2way_pseudo_cons")
    CCDS = auto()
    PAR = auto()
    exp_conf = auto()
    cds_end_NF = auto()
    cds_start_NF = auto()
    mRNA_end_NF = auto()
    mRNA_start_NF = auto()
    not_organism_supported = auto()
    pseudo_consens = auto()
    seleno = auto()
    non_ATG_start = auto()
    alternative_5_UTR = auto()
    alternative_3_UTR = auto()
    non_canonical_other = auto()
    non_canonical_U12 = auto()
    non_canonical_TEC = auto()
    non_canonical_conserved = auto()
    non_canonical_polymorphism = auto()
    non_canonical_genome_sequence_error = auto()
    non_submitted_evidence = auto()
    NAGNAG_splice_site = auto()
    upstream_ATG = auto()
    downstream_ATG = auto()
    NMD_exception = auto()
    upstream_uORF = auto()
    overlapping_uORF = auto()
    not_best_in_genome_evidence = auto()
    basic = auto()
    readthrough_transcript = auto()
    dotter_confirmed = auto()
    RNA_Seq_supported_only = auto()
    NMD_likely_if_extended = auto()
    retained_intron_final = auto()
    CAGE_supported_TSS = auto()
    retained_intron_first = auto()
    sequence_error = auto()
    low_sequence_quality = auto()
    bicistronic = auto()
    retained_intron_CDS = auto()
    RP_supported_TIS = auto()
    inferred_exon_combination = auto()
    appris_principal = auto()
    appris_principal_1 = auto()
    appris_principal_2 = auto()
    appris_principal_3 = auto()
    appris_principal_4 = auto()
    appris_principal_5 = auto()
    appris_alternative_1 = auto()
    appris_alternative_2 = auto()
    appris_candidate_longest = auto()
    appris_candidate = auto()
    appris_candidate_ccds = auto()
    appris_candidate_longest_ccds = auto()
    appris_candidate_longest_seq = auto()
    appris_candidate_highest_score = auto()
    inferred_transcript_model = auto()
    RNA_Seq_supported_partial = auto()
    supported_extension_3_nested = SymEnumValue(auto(), "3_nested_supported_extension")
    supported_extension_3_standard_ = SymEnumValue(auto(), "3_standard_supported_extension")
    supported_extension_5_nested = SymEnumValue(auto(), "5_nested_supported_extension")
    supported_extension_5_standard_ = SymEnumValue(auto(), "5_standard_supported_extension")
    RNA_Seq_454_supported = SymEnumValue(auto(), "454_RNA_Seq_supported")
    nested_454_RNA_Seq_supported = auto()
    ncRNA_host = auto()
    reference_genome_error = auto()
    overlapping_locus = auto()
    fragmented_locus = auto()
    retrogene = auto()
    orphan = auto()
    semi_processed = auto()
    MANE_Select = auto()
    MANE_Plus_Clinical = auto()
    TAGENE = auto()
    stop_codon_readthrough = auto()
    Ensembl_canonical = auto()
    readthrough_gene = auto()
    artifactual_duplication = auto()
    overlaps_pseudogene = auto()
    confirm_experimentally = auto()
    polymorphic_pseudogene_no_stop = auto()
    annotation_in_progress = auto()
    fragmented_mixed_strand_locus = auto()
    Selenoprotein = auto()
    EnsEMBL_merge_exception = auto()
    precursor_RNA = auto()
    GENCODE_Primary = auto()


gencodeTagNotFullCds = frozenset([GencodeTag.cds_start_NF,
                                  GencodeTag.cds_end_NF])
gencodeTagNotFullMRna = frozenset([GencodeTag.mRNA_start_NF,
                                   GencodeTag.mRNA_end_NF])
gencodeTagNotFull = frozenset(gencodeTagNotFullCds | gencodeTagNotFullMRna)
