/* HInv.c was originally generated by the autoSql program, which also 
 * generated HInv.h and HInv.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "HInv.h"


void HInvStaticLoad(char **row, struct HInv *ret)
/* Load a row from HInv table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->geneId = row[0];
ret->clusterId = row[1];
ret->mrnaAcc = row[2];
}

struct HInv *HInvLoad(char **row)
/* Load a HInv from row fetched with select * from HInv
 * from database.  Dispose of this with HInvFree(). */
{
struct HInv *ret;

AllocVar(ret);
ret->geneId = cloneString(row[0]);
ret->clusterId = cloneString(row[1]);
ret->mrnaAcc = cloneString(row[2]);
return ret;
}

struct HInv *HInvLoadAll(char *fileName) 
/* Load all HInv from a whitespace-separated file.
 * Dispose of this with HInvFreeList(). */
{
struct HInv *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = HInvLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct HInv *HInvLoadAllByChar(char *fileName, char chopper) 
/* Load all HInv from a chopper separated file.
 * Dispose of this with HInvFreeList(). */
{
struct HInv *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = HInvLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct HInv *HInvCommaIn(char **pS, struct HInv *ret)
/* Create a HInv out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new HInv */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->geneId = sqlStringComma(&s);
ret->clusterId = sqlStringComma(&s);
ret->mrnaAcc = sqlStringComma(&s);
*pS = s;
return ret;
}

void HInvFree(struct HInv **pEl)
/* Free a single dynamically allocated HInv such as created
 * with HInvLoad(). */
{
struct HInv *el;

if ((el = *pEl) == NULL) return;
freeMem(el->geneId);
freeMem(el->clusterId);
freeMem(el->mrnaAcc);
freez(pEl);
}

void HInvFreeList(struct HInv **pList)
/* Free a list of dynamically allocated HInv's */
{
struct HInv *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    HInvFree(&el);
    }
*pList = NULL;
}

void HInvOutput(struct HInv *el, FILE *f, char sep, char lastSep) 
/* Print out HInv.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->clusterId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mrnaAcc);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

