/* cogs.c was originally generated by the autoSql program, which also 
 * generated cogs.h and cogs.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cogs.h"


void COGStaticLoad(char **row, struct COG *ret)
/* Load a row from COG table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->COG = row[1];
ret->code = row[2];
}

struct COG *COGLoad(char **row)
/* Load a COG from row fetched with select * from COG
 * from database.  Dispose of this with COGFree(). */
{
struct COG *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->COG = cloneString(row[1]);
ret->code = cloneString(row[2]);
return ret;
}

struct COG *COGLoadAll(char *fileName) 
/* Load all COG from a whitespace-separated file.
 * Dispose of this with COGFreeList(). */
{
struct COG *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = COGLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct COG *COGLoadAllByChar(char *fileName, char chopper) 
/* Load all COG from a chopper separated file.
 * Dispose of this with COGFreeList(). */
{
struct COG *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = COGLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct COG *COGCommaIn(char **pS, struct COG *ret)
/* Create a COG out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new COG */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->COG = sqlStringComma(&s);
ret->code = sqlStringComma(&s);
*pS = s;
return ret;
}

void COGFree(struct COG **pEl)
/* Free a single dynamically allocated COG such as created
 * with COGLoad(). */
{
struct COG *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->COG);
freeMem(el->code);
freez(pEl);
}

void COGFreeList(struct COG **pList)
/* Free a list of dynamically allocated COG's */
{
struct COG *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    COGFree(&el);
    }
*pList = NULL;
}

void COGOutput(struct COG *el, FILE *f, char sep, char lastSep) 
/* Print out COG.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->COG);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->code);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

