/* improbRunInfo.c was originally generated by the autoSql program, which also 
 * generated improbRunInfo.h and improbRunInfo.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "improbRunInfo.h"


struct improbRunInfo *improbRunInfoLoad(char **row)
/* Load a improbRunInfo from row fetched with select * from improbRunInfo
 * from database.  Dispose of this with improbRunInfoFree(). */
{
struct improbRunInfo *ret;
int sizeOne;

AllocVar(ret);
ret->columnCount = sqlSigned(row[9]);
ret->controlCount = sqlSigned(row[14]);
ret->name = cloneString(row[0]);
ret->runScore = atof(row[1]);
ret->bestControlScore = atof(row[2]);
ret->meanControlScore = atof(row[3]);
ret->sdControlScore = atof(row[4]);
ret->seqCount = sqlSigned(row[5]);
ret->consensus = cloneString(row[6]);
ret->runPos = atof(row[7]);
ret->runPosSd = atof(row[8]);
sqlFloatDynamicArray(row[10], &ret->aProb, &sizeOne);
assert(sizeOne == ret->columnCount);
sqlFloatDynamicArray(row[11], &ret->cProb, &sizeOne);
assert(sizeOne == ret->columnCount);
sqlFloatDynamicArray(row[12], &ret->gProb, &sizeOne);
assert(sizeOne == ret->columnCount);
sqlFloatDynamicArray(row[13], &ret->tProb, &sizeOne);
assert(sizeOne == ret->columnCount);
sqlFloatDynamicArray(row[15], &ret->controlScores, &sizeOne);
assert(sizeOne == ret->controlCount);
return ret;
}

struct improbRunInfo *improbRunInfoLoadAll(char *fileName) 
/* Load all improbRunInfo from a tab-separated file.
 * Dispose of this with improbRunInfoFreeList(). */
{
struct improbRunInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[16];

while (lineFileRow(lf, row))
    {
    el = improbRunInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct improbRunInfo *improbRunInfoLoadWhere(struct sqlConnection *conn, char *table, char *where)
/* Load all improbRunInfo from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with improbRunInfoFreeList(). */
{
struct improbRunInfo *list = NULL, *el;
struct dyString *query = dyStringNew(256);
struct sqlResult *sr;
char **row;

sqlDyStringPrintf(query, "select * from %s", table);
if (where != NULL)
    sqlDyStringPrintf(query, " where %-s", where);
sr = sqlGetResult(conn, query->string);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = improbRunInfoLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
dyStringFree(&query);
return list;
}

struct improbRunInfo *improbRunInfoCommaIn(char **pS, struct improbRunInfo *ret)
/* Create a improbRunInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new improbRunInfo */
{
char *s = *pS;
int i;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->runScore = sqlFloatComma(&s);
ret->bestControlScore = sqlFloatComma(&s);
ret->meanControlScore = sqlFloatComma(&s);
ret->sdControlScore = sqlFloatComma(&s);
ret->seqCount = sqlSignedComma(&s);
ret->consensus = sqlStringComma(&s);
ret->runPos = sqlFloatComma(&s);
ret->runPosSd = sqlFloatComma(&s);
ret->columnCount = sqlSignedComma(&s);
s = sqlEatChar(s, '{');
AllocArray(ret->aProb, ret->columnCount);
for (i=0; i<ret->columnCount; ++i)
    {
    ret->aProb[i] = sqlFloatComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
s = sqlEatChar(s, '{');
AllocArray(ret->cProb, ret->columnCount);
for (i=0; i<ret->columnCount; ++i)
    {
    ret->cProb[i] = sqlFloatComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
s = sqlEatChar(s, '{');
AllocArray(ret->gProb, ret->columnCount);
for (i=0; i<ret->columnCount; ++i)
    {
    ret->gProb[i] = sqlFloatComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
s = sqlEatChar(s, '{');
AllocArray(ret->tProb, ret->columnCount);
for (i=0; i<ret->columnCount; ++i)
    {
    ret->tProb[i] = sqlFloatComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
ret->controlCount = sqlSignedComma(&s);
s = sqlEatChar(s, '{');
AllocArray(ret->controlScores, ret->controlCount);
for (i=0; i<ret->controlCount; ++i)
    {
    ret->controlScores[i] = sqlFloatComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
*pS = s;
return ret;
}

void improbRunInfoFree(struct improbRunInfo **pEl)
/* Free a single dynamically allocated improbRunInfo such as created
 * with improbRunInfoLoad(). */
{
struct improbRunInfo *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->consensus);
freeMem(el->aProb);
freeMem(el->cProb);
freeMem(el->gProb);
freeMem(el->tProb);
freeMem(el->controlScores);
freez(pEl);
}

void improbRunInfoFreeList(struct improbRunInfo **pList)
/* Free a list of dynamically allocated improbRunInfo's */
{
struct improbRunInfo *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    improbRunInfoFree(&el);
    }
*pList = NULL;
}

void improbRunInfoOutput(struct improbRunInfo *el, FILE *f, char sep, char lastSep) 
/* Print out improbRunInfo.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->runScore);
fputc(sep,f);
fprintf(f, "%f", el->bestControlScore);
fputc(sep,f);
fprintf(f, "%f", el->meanControlScore);
fputc(sep,f);
fprintf(f, "%f", el->sdControlScore);
fputc(sep,f);
fprintf(f, "%d", el->seqCount);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->consensus);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->runPos);
fputc(sep,f);
fprintf(f, "%f", el->runPosSd);
fputc(sep,f);
fprintf(f, "%d", el->columnCount);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->columnCount; ++i)
    {
    fprintf(f, "%f", el->aProb[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->columnCount; ++i)
    {
    fprintf(f, "%f", el->cProb[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->columnCount; ++i)
    {
    fprintf(f, "%f", el->gProb[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->columnCount; ++i)
    {
    fprintf(f, "%f", el->tProb[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
fprintf(f, "%d", el->controlCount);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->controlCount; ++i)
    {
    fprintf(f, "%f", el->controlScores[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(lastSep,f);
}

