/* clinvarSub.h was originally generated by the autoSql program, which also 
 * generated clinvarSub.c and clinvarSub.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef CLINVARSUB_H
#define CLINVARSUB_H

#define CLINVARSUB_NUM_COLS 13

extern char *clinvarSubCommaSepFieldNames;

struct clinvarSub
/* ClinVar variant submission info */
    {
    struct clinvarSub *next;  /* Next in singly linked list. */
    int varId;	/* the identifier assigned by ClinVar and used to build the URL, namely https://ncbi.nlm.nih.gov/clinvar/VariationID */
    char *clinSign;	/* interpretation of the variation-condition relationship */
    char *dateLastEval;	/* the last date the variation-condition relationship was evaluated by this submitter */
    char *description;	/* an optional free text description of the basis of the interpretation */
    char *subPhenoInfo;	/* the name(s) or identifier(s)  submitted for the condition that was interpreted relative to the variant */
    char *repPhenoInfo;	/* the MedGen identifier/name combinations ClinVar uses to report the condition that was interpreted. 'na' means there is no public identifer in MedGen for the condition. */
    char *revStatus;	/* the level of review for this submission, namely http//www.ncbi.nlm.nih.gov/clinvar/docs/variation_report/#review_status */
    char *collMethod;	/* the method by which the submitter obtained the information provided */
    char *originCounts;	/* origin and the number of observations for each origin */
    char *submitter;	/* the submitter of this record */
    char *scv;	/* the accession and current version assigned by ClinVar to the submitted interpretation of the variation-condition relationship */
    char *subGeneSymbol;	/* the gene symbol reported in this record */
    char *explOfInterp;	/* more details if ClinicalSignificance is 'other' or 'drug response' */
    };

void clinvarSubStaticLoad(char **row, struct clinvarSub *ret);
/* Load a row from clinvarSub table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct clinvarSub *clinvarSubLoad(char **row);
/* Load a clinvarSub from row fetched with select * from clinvarSub
 * from database.  Dispose of this with clinvarSubFree(). */

struct clinvarSub *clinvarSubLoadAll(char *fileName);
/* Load all clinvarSub from whitespace-separated file.
 * Dispose of this with clinvarSubFreeList(). */

struct clinvarSub *clinvarSubLoadAllByChar(char *fileName, char chopper);
/* Load all clinvarSub from chopper separated file.
 * Dispose of this with clinvarSubFreeList(). */

#define clinvarSubLoadAllByTab(a) clinvarSubLoadAllByChar(a, '\t');
/* Load all clinvarSub from tab separated file.
 * Dispose of this with clinvarSubFreeList(). */

struct clinvarSub *clinvarSubCommaIn(char **pS, struct clinvarSub *ret);
/* Create a clinvarSub out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new clinvarSub */

void clinvarSubFree(struct clinvarSub **pEl);
/* Free a single dynamically allocated clinvarSub such as created
 * with clinvarSubLoad(). */

void clinvarSubFreeList(struct clinvarSub **pList);
/* Free a list of dynamically allocated clinvarSub's */

void clinvarSubOutput(struct clinvarSub *el, FILE *f, char sep, char lastSep);
/* Print out clinvarSub.  Separate fields with sep. Follow last field with lastSep. */

#define clinvarSubTabOut(el,f) clinvarSubOutput(el,f,'\t','\n');
/* Print out clinvarSub as a line in a tab-separated file. */

#define clinvarSubCommaOut(el,f) clinvarSubOutput(el,f,',',',');
/* Print out clinvarSub as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* CLINVARSUB_H */

