/* flyreg2.h was originally generated by the autoSql program, which also 
 * generated flyreg2.c and flyreg2.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2005 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef FLYREG2_H
#define FLYREG2_H

#define FLYREG2_NUM_COLS 7

struct flyreg2
/* Flyreg data (version 2) from Casey Bergman */
    {
    struct flyreg2 *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Factor */
    char *target;	/* Target */
    unsigned pmid;	/* PubMed ID */
    unsigned fpid;	/* Footprint ID -- stable ID across versions */
    };

void flyreg2StaticLoad(char **row, struct flyreg2 *ret);
/* Load a row from flyreg2 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct flyreg2 *flyreg2Load(char **row);
/* Load a flyreg2 from row fetched with select * from flyreg2
 * from database.  Dispose of this with flyreg2Free(). */

struct flyreg2 *flyreg2LoadAll(char *fileName);
/* Load all flyreg2 from whitespace-separated file.
 * Dispose of this with flyreg2FreeList(). */

struct flyreg2 *flyreg2LoadAllByChar(char *fileName, char chopper);
/* Load all flyreg2 from chopper separated file.
 * Dispose of this with flyreg2FreeList(). */

#define flyreg2LoadAllByTab(a) flyreg2LoadAllByChar(a, '\t');
/* Load all flyreg2 from tab separated file.
 * Dispose of this with flyreg2FreeList(). */

struct flyreg2 *flyreg2CommaIn(char **pS, struct flyreg2 *ret);
/* Create a flyreg2 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new flyreg2 */

void flyreg2Free(struct flyreg2 **pEl);
/* Free a single dynamically allocated flyreg2 such as created
 * with flyreg2Load(). */

void flyreg2FreeList(struct flyreg2 **pList);
/* Free a list of dynamically allocated flyreg2's */

void flyreg2Output(struct flyreg2 *el, FILE *f, char sep, char lastSep);
/* Print out flyreg2.  Separate fields with sep. Follow last field with lastSep. */

#define flyreg2TabOut(el,f) flyreg2Output(el,f,'\t','\n');
/* Print out flyreg2 as a line in a tab-separated file. */

#define flyreg2CommaOut(el,f) flyreg2Output(el,f,',',',');
/* Print out flyreg2 as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* FLYREG2_H */

