/* llaInfo.h was originally generated by the autoSql program, which also 
 * generated llaInfo.c and llaInfo.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef LLAINFO_H
#define LLAINFO_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define LLAINFO_NUM_COLS 20

struct llaInfo
/* Extra information for a lowe lab array */
    {
    struct llaInfo *next;  /* Next in singly linked list. */
    char *name;	/* Name of primer pair */
    char *type;	/* Type of primer pair (ORF or intergenic) */
    float SnTm;	/* Sense primer annealing temp */
    float SnGc;	/* Sense primer annealing temp */
    float SnSc;	/* Sense primer self-complementarity score */
    float Sn3pSc;	/* Sense primer 3-prime self-complementarity score */
    float AsnTm;	/* Antisense primer annealing temp */
    float AsnGc;	/* Antisense primer annealing temp */
    float AsnSc;	/* Antisense primer self-complementarity score */
    float Asn3pSc;	/* Antisense primer 3-prime self-complementarity score */
    unsigned prodLen;	/* PCR product length */
    unsigned ORFLen;	/* Source ORF length */
    float meltTm;	/* PCR melting temperature */
    float frcc;	/* Forward+reverse primer cross complementarity */
    float fr3pcc;	/* 3-prime forward+reverse primer cross complementarity */
    char *SnSeq;	/* Sense primer sequence */
    char *AsnSeq;	/* Antisense primer sequence */
    unsigned numCorrs;	/* Number of correlations stored */
    char **corrNames;	/* Names of correlated genes */
    float *corrs;	/* Correlations */
    };

struct llaInfo *llaInfoLoad(char **row);
/* Load a llaInfo from row fetched with select * from llaInfo
 * from database.  Dispose of this with llaInfoFree(). */

struct llaInfo *llaInfoLoadAll(char *fileName);
/* Load all llaInfo from whitespace-separated file.
 * Dispose of this with llaInfoFreeList(). */

struct llaInfo *llaInfoLoadAllByChar(char *fileName, char chopper);
/* Load all llaInfo from chopper separated file.
 * Dispose of this with llaInfoFreeList(). */

#define llaInfoLoadAllByTab(a) llaInfoLoadAllByChar(a, '\t');
/* Load all llaInfo from tab separated file.
 * Dispose of this with llaInfoFreeList(). */

struct llaInfo *llaInfoLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all llaInfo from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with llaInfoFreeList(). */

void llaInfoSaveToDb(struct sqlConnection *conn, struct llaInfo *el, char *tableName, int updateSize);
/* Save llaInfo as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct llaInfo *llaInfoCommaIn(char **pS, struct llaInfo *ret);
/* Create a llaInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new llaInfo */

void llaInfoFree(struct llaInfo **pEl);
/* Free a single dynamically allocated llaInfo such as created
 * with llaInfoLoad(). */

void llaInfoFreeList(struct llaInfo **pList);
/* Free a list of dynamically allocated llaInfo's */

void llaInfoOutput(struct llaInfo *el, FILE *f, char sep, char lastSep);
/* Print out llaInfo.  Separate fields with sep. Follow last field with lastSep. */

#define llaInfoTabOut(el,f) llaInfoOutput(el,f,'\t','\n');
/* Print out llaInfo as a line in a tab-separated file. */

#define llaInfoCommaOut(el,f) llaInfoOutput(el,f,',',',');
/* Print out llaInfo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* LLAINFO_H */

