/* mouseSyn.h was originally generated by the autoSql program, which also 
 * generated mouseSyn.c and mouseSyn.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef MOUSESYN_H
#define MOUSESYN_H

struct mouseSyn
/* Synteny between mouse and human chromosomes. */
    {
    struct mouseSyn *next;  /* Next in singly linked list. */
    char *chrom;	/* Name of chromosome */
    unsigned chromStart;	/* Start in chromosome */
    unsigned chromEnd;	/* End in chromosome */
    char *name;	/* Name of mouse chromosome */
    int segment;	/* Number of segment */
    };

void mouseSynStaticLoad(char **row, struct mouseSyn *ret);
/* Load a row from mouseSyn table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct mouseSyn *mouseSynLoad(char **row);
/* Load a mouseSyn from row fetched with select * from mouseSyn
 * from database.  Dispose of this with mouseSynFree(). */

struct mouseSyn *mouseSynCommaIn(char **pS, struct mouseSyn *ret);
/* Create a mouseSyn out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new mouseSyn */

void mouseSynFree(struct mouseSyn **pEl);
/* Free a single dynamically allocated mouseSyn such as created
 * with mouseSynLoad(). */

void mouseSynFreeList(struct mouseSyn **pList);
/* Free a list of dynamically allocated mouseSyn's */

void mouseSynOutput(struct mouseSyn *el, FILE *f, char sep, char lastSep);
/* Print out mouseSyn.  Separate fields with sep. Follow last field with lastSep. */

#define mouseSynTabOut(el,f) mouseSynOutput(el,f,'\t','\n');
/* Print out mouseSyn as a line in a tab-separated file. */

#define mouseSynCommaOut(el,f) mouseSynOutput(el,f,',',',');
/* Print out mouseSyn as a comma separated list including final comma. */

#endif /* MOUSESYN_H */

