/* asmAlias.c was originally generated by the autoSql program, which also 
 * generated asmAlias.h and asmAlias.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "hdb.h"
#include "asmAlias.h"
#include "trackHub.h"



char *asmAliasCommaSepFieldNames = "alias,browser";

void asmAliasStaticLoad(char **row, struct asmAlias *ret)
/* Load a row from asmAlias table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->alias = row[0];
ret->browser = row[1];
}

struct asmAlias *asmAliasLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all asmAlias from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with asmAliasFreeList(). */
{
struct asmAlias *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = asmAliasLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void asmAliasSaveToDb(struct sqlConnection *conn, struct asmAlias *el, char *tableName, int updateSize)
/* Save asmAlias as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s','%s')", 
	tableName,  el->alias,  el->browser);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct asmAlias *asmAliasLoad(char **row)
/* Load a asmAlias from row fetched with select * from asmAlias
 * from database.  Dispose of this with asmAliasFree(). */
{
struct asmAlias *ret;

AllocVar(ret);
ret->alias = cloneString(row[0]);
ret->browser = cloneString(row[1]);
return ret;
}

struct asmAlias *asmAliasLoadAll(char *fileName) 
/* Load all asmAlias from a whitespace-separated file.
 * Dispose of this with asmAliasFreeList(). */
{
struct asmAlias *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = asmAliasLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct asmAlias *asmAliasLoadAllByChar(char *fileName, char chopper) 
/* Load all asmAlias from a chopper separated file.
 * Dispose of this with asmAliasFreeList(). */
{
struct asmAlias *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = asmAliasLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct asmAlias *asmAliasCommaIn(char **pS, struct asmAlias *ret)
/* Create a asmAlias out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new asmAlias */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->alias = sqlStringComma(&s);
ret->browser = sqlStringComma(&s);
*pS = s;
return ret;
}

void asmAliasFree(struct asmAlias **pEl)
/* Free a single dynamically allocated asmAlias such as created
 * with asmAliasLoad(). */
{
struct asmAlias *el;

if ((el = *pEl) == NULL) return;
freeMem(el->alias);
freeMem(el->browser);
freez(pEl);
}

void asmAliasFreeList(struct asmAlias **pList)
/* Free a list of dynamically allocated asmAlias's */
{
struct asmAlias *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    asmAliasFree(&el);
    }
*pList = NULL;
}

void asmAliasOutput(struct asmAlias *el, FILE *f, char sep, char lastSep) 
/* Print out asmAlias.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->alias);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->browser);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

char *asmAliasFind(char *alias)
/* If this assembly is an alias for a db we know about, return it.  Otherwise return what we were sent. */
{
if (alias == NULL)
    return NULL;

char *ret = cloneString(alias);
struct sqlConnection *centralConn = hConnectCentral();

if (!sqlTableExists(centralConn, "asmAlias"))
    {
    hDisconnectCentral(&centralConn);
    return alias;
    }

char buffer[4096];

sqlSafef(buffer, sizeof buffer, "select * from asmAlias where alias='%s' limit 1", trackHubSkipHubName(alias));
struct asmAlias *asmAlias = asmAliasLoadByQuery(centralConn, buffer);
hDisconnectCentral(&centralConn);
if (asmAlias)
    ret = asmAlias->browser;

return ret;
}
