/* encodeDataWarehouse.h was originally generated by the autoSql program, which also 
 * generated encodeDataWarehouse.c and encodeDataWarehouse.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ENCODEDATAWAREHOUSE_H
#define ENCODEDATAWAREHOUSE_H

#include "jksql.h"
#define EDWSETTINGS_NUM_COLS 3

extern char *edwSettingsCommaSepFieldNames;

struct edwSettings
/* Settings used to configure warehouse */
    {
    struct edwSettings *next;  /* Next in singly linked list. */
    unsigned id;	/* Settings ID */
    char *name;	/* Settings name, can't be reused */
    char *val;	/* Settings value, some undefined but not huge thing */
    };

void edwSettingsStaticLoad(char **row, struct edwSettings *ret);
/* Load a row from edwSettings table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwSettings *edwSettingsLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwSettings from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwSettingsFreeList(). */

void edwSettingsSaveToDb(struct sqlConnection *conn, struct edwSettings *el, char *tableName, int updateSize);
/* Save edwSettings as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwSettings *edwSettingsLoad(char **row);
/* Load a edwSettings from row fetched with select * from edwSettings
 * from database.  Dispose of this with edwSettingsFree(). */

struct edwSettings *edwSettingsLoadAll(char *fileName);
/* Load all edwSettings from whitespace-separated file.
 * Dispose of this with edwSettingsFreeList(). */

struct edwSettings *edwSettingsLoadAllByChar(char *fileName, char chopper);
/* Load all edwSettings from chopper separated file.
 * Dispose of this with edwSettingsFreeList(). */

#define edwSettingsLoadAllByTab(a) edwSettingsLoadAllByChar(a, '\t');
/* Load all edwSettings from tab separated file.
 * Dispose of this with edwSettingsFreeList(). */

struct edwSettings *edwSettingsCommaIn(char **pS, struct edwSettings *ret);
/* Create a edwSettings out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwSettings */

void edwSettingsFree(struct edwSettings **pEl);
/* Free a single dynamically allocated edwSettings such as created
 * with edwSettingsLoad(). */

void edwSettingsFreeList(struct edwSettings **pList);
/* Free a list of dynamically allocated edwSettings's */

void edwSettingsOutput(struct edwSettings *el, FILE *f, char sep, char lastSep);
/* Print out edwSettings.  Separate fields with sep. Follow last field with lastSep. */

#define edwSettingsTabOut(el,f) edwSettingsOutput(el,f,'\t','\n');
/* Print out edwSettings as a line in a tab-separated file. */

#define edwSettingsCommaOut(el,f) edwSettingsOutput(el,f,',',',');
/* Print out edwSettings as a comma separated list including final comma. */

#define EDWUSER_NUM_COLS 4

extern char *edwUserCommaSepFieldNames;

struct edwUser
/* Someone who submits files to or otherwise interacts with big data warehouse */
    {
    struct edwUser *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented user ID */
    char *email;	/* Email address - required */
    char uuid[38];	/* Help to synchronize us with Stanford. */
    signed char isAdmin;	/* If true the use can modify other people's files too. */
    };

void edwUserStaticLoad(char **row, struct edwUser *ret);
/* Load a row from edwUser table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwUser *edwUserLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwUser from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwUserFreeList(). */

void edwUserSaveToDb(struct sqlConnection *conn, struct edwUser *el, char *tableName, int updateSize);
/* Save edwUser as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwUser *edwUserLoad(char **row);
/* Load a edwUser from row fetched with select * from edwUser
 * from database.  Dispose of this with edwUserFree(). */

struct edwUser *edwUserLoadAll(char *fileName);
/* Load all edwUser from whitespace-separated file.
 * Dispose of this with edwUserFreeList(). */

struct edwUser *edwUserLoadAllByChar(char *fileName, char chopper);
/* Load all edwUser from chopper separated file.
 * Dispose of this with edwUserFreeList(). */

#define edwUserLoadAllByTab(a) edwUserLoadAllByChar(a, '\t');
/* Load all edwUser from tab separated file.
 * Dispose of this with edwUserFreeList(). */

struct edwUser *edwUserCommaIn(char **pS, struct edwUser *ret);
/* Create a edwUser out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwUser */

void edwUserFree(struct edwUser **pEl);
/* Free a single dynamically allocated edwUser such as created
 * with edwUserLoad(). */

void edwUserFreeList(struct edwUser **pList);
/* Free a list of dynamically allocated edwUser's */

void edwUserOutput(struct edwUser *el, FILE *f, char sep, char lastSep);
/* Print out edwUser.  Separate fields with sep. Follow last field with lastSep. */

#define edwUserTabOut(el,f) edwUserOutput(el,f,'\t','\n');
/* Print out edwUser as a line in a tab-separated file. */

#define edwUserCommaOut(el,f) edwUserOutput(el,f,',',',');
/* Print out edwUser as a comma separated list including final comma. */

#define EDWSCRIPTREGISTRY_NUM_COLS 6

extern char *edwScriptRegistryCommaSepFieldNames;

struct edwScriptRegistry
/* A script that is authorized to submit on behalf of a user */
    {
    struct edwScriptRegistry *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented script ID */
    unsigned userId;	/* Associated user */
    char *name;	/* Script name - unique in system and autogenerated */
    char *description;	/* Script description */
    char *secretHash;	/* Hashed script password */
    int submitCount;	/* Number of submissions attempted */
    };

void edwScriptRegistryStaticLoad(char **row, struct edwScriptRegistry *ret);
/* Load a row from edwScriptRegistry table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwScriptRegistry *edwScriptRegistryLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwScriptRegistry from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwScriptRegistryFreeList(). */

void edwScriptRegistrySaveToDb(struct sqlConnection *conn, struct edwScriptRegistry *el, char *tableName, int updateSize);
/* Save edwScriptRegistry as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwScriptRegistry *edwScriptRegistryLoad(char **row);
/* Load a edwScriptRegistry from row fetched with select * from edwScriptRegistry
 * from database.  Dispose of this with edwScriptRegistryFree(). */

struct edwScriptRegistry *edwScriptRegistryLoadAll(char *fileName);
/* Load all edwScriptRegistry from whitespace-separated file.
 * Dispose of this with edwScriptRegistryFreeList(). */

struct edwScriptRegistry *edwScriptRegistryLoadAllByChar(char *fileName, char chopper);
/* Load all edwScriptRegistry from chopper separated file.
 * Dispose of this with edwScriptRegistryFreeList(). */

#define edwScriptRegistryLoadAllByTab(a) edwScriptRegistryLoadAllByChar(a, '\t');
/* Load all edwScriptRegistry from tab separated file.
 * Dispose of this with edwScriptRegistryFreeList(). */

struct edwScriptRegistry *edwScriptRegistryCommaIn(char **pS, struct edwScriptRegistry *ret);
/* Create a edwScriptRegistry out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwScriptRegistry */

void edwScriptRegistryFree(struct edwScriptRegistry **pEl);
/* Free a single dynamically allocated edwScriptRegistry such as created
 * with edwScriptRegistryLoad(). */

void edwScriptRegistryFreeList(struct edwScriptRegistry **pList);
/* Free a list of dynamically allocated edwScriptRegistry's */

void edwScriptRegistryOutput(struct edwScriptRegistry *el, FILE *f, char sep, char lastSep);
/* Print out edwScriptRegistry.  Separate fields with sep. Follow last field with lastSep. */

#define edwScriptRegistryTabOut(el,f) edwScriptRegistryOutput(el,f,'\t','\n');
/* Print out edwScriptRegistry as a line in a tab-separated file. */

#define edwScriptRegistryCommaOut(el,f) edwScriptRegistryOutput(el,f,',',',');
/* Print out edwScriptRegistry as a comma separated list including final comma. */

#define EDWHOST_NUM_COLS 10

extern char *edwHostCommaSepFieldNames;

struct edwHost
/* A web host we have collected files from - something like www.ncbi.nlm.gov or google.com */
    {
    struct edwHost *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented host id */
    char *name;	/* Name (before DNS lookup) */
    long long lastOkTime;	/* Last time host was ok in seconds since 1970 */
    long long lastNotOkTime;	/* Last time host was not ok in seconds since 1970 */
    long long firstAdded;	/* Time host was first seen */
    char *errorMessage;	/* If non-empty contains last error message from host. If empty host is ok */
    long long openSuccesses;	/* Number of times files have been opened ok from this host */
    long long openFails;	/* Number of times files have failed to open from this host */
    long long historyBits;	/* Open history with most recent in least significant bit. 0 for connection failed, 1 for success */
    int paraFetchStreams;	/* Number of open streams for paraFetch command.  10 for most places, 30 for Barcelona */
    };

void edwHostStaticLoad(char **row, struct edwHost *ret);
/* Load a row from edwHost table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwHost *edwHostLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwHost from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwHostFreeList(). */

void edwHostSaveToDb(struct sqlConnection *conn, struct edwHost *el, char *tableName, int updateSize);
/* Save edwHost as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwHost *edwHostLoad(char **row);
/* Load a edwHost from row fetched with select * from edwHost
 * from database.  Dispose of this with edwHostFree(). */

struct edwHost *edwHostLoadAll(char *fileName);
/* Load all edwHost from whitespace-separated file.
 * Dispose of this with edwHostFreeList(). */

struct edwHost *edwHostLoadAllByChar(char *fileName, char chopper);
/* Load all edwHost from chopper separated file.
 * Dispose of this with edwHostFreeList(). */

#define edwHostLoadAllByTab(a) edwHostLoadAllByChar(a, '\t');
/* Load all edwHost from tab separated file.
 * Dispose of this with edwHostFreeList(). */

struct edwHost *edwHostCommaIn(char **pS, struct edwHost *ret);
/* Create a edwHost out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwHost */

void edwHostFree(struct edwHost **pEl);
/* Free a single dynamically allocated edwHost such as created
 * with edwHostLoad(). */

void edwHostFreeList(struct edwHost **pList);
/* Free a list of dynamically allocated edwHost's */

void edwHostOutput(struct edwHost *el, FILE *f, char sep, char lastSep);
/* Print out edwHost.  Separate fields with sep. Follow last field with lastSep. */

#define edwHostTabOut(el,f) edwHostOutput(el,f,'\t','\n');
/* Print out edwHost as a line in a tab-separated file. */

#define edwHostCommaOut(el,f) edwHostOutput(el,f,',',',');
/* Print out edwHost as a comma separated list including final comma. */

#define EDWSUBMITDIR_NUM_COLS 10

extern char *edwSubmitDirCommaSepFieldNames;

struct edwSubmitDir
/* An external data directory we have collected a submit from */
    {
    struct edwSubmitDir *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented id */
    char *url;	/* Web-mounted directory. Includes protocol, host, and final '/' */
    unsigned hostId;	/* Id of host it's on */
    long long lastOkTime;	/* Last time submit dir was ok in seconds since 1970 */
    long long lastNotOkTime;	/* Last time submit dir was not ok in seconds since 1970 */
    long long firstAdded;	/* Time submit dir was first seen */
    char *errorMessage;	/* If non-empty contains last error message from dir. If empty dir is ok */
    long long openSuccesses;	/* Number of times files have been opened ok from this dir */
    long long openFails;	/* Number of times files have failed to open from this dir */
    long long historyBits;	/* Open history with most recent in least significant bit. 0 for upload failed, 1 for success */
    };

void edwSubmitDirStaticLoad(char **row, struct edwSubmitDir *ret);
/* Load a row from edwSubmitDir table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwSubmitDir *edwSubmitDirLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwSubmitDir from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwSubmitDirFreeList(). */

void edwSubmitDirSaveToDb(struct sqlConnection *conn, struct edwSubmitDir *el, char *tableName, int updateSize);
/* Save edwSubmitDir as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwSubmitDir *edwSubmitDirLoad(char **row);
/* Load a edwSubmitDir from row fetched with select * from edwSubmitDir
 * from database.  Dispose of this with edwSubmitDirFree(). */

struct edwSubmitDir *edwSubmitDirLoadAll(char *fileName);
/* Load all edwSubmitDir from whitespace-separated file.
 * Dispose of this with edwSubmitDirFreeList(). */

struct edwSubmitDir *edwSubmitDirLoadAllByChar(char *fileName, char chopper);
/* Load all edwSubmitDir from chopper separated file.
 * Dispose of this with edwSubmitDirFreeList(). */

#define edwSubmitDirLoadAllByTab(a) edwSubmitDirLoadAllByChar(a, '\t');
/* Load all edwSubmitDir from tab separated file.
 * Dispose of this with edwSubmitDirFreeList(). */

struct edwSubmitDir *edwSubmitDirCommaIn(char **pS, struct edwSubmitDir *ret);
/* Create a edwSubmitDir out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwSubmitDir */

void edwSubmitDirFree(struct edwSubmitDir **pEl);
/* Free a single dynamically allocated edwSubmitDir such as created
 * with edwSubmitDirLoad(). */

void edwSubmitDirFreeList(struct edwSubmitDir **pList);
/* Free a list of dynamically allocated edwSubmitDir's */

void edwSubmitDirOutput(struct edwSubmitDir *el, FILE *f, char sep, char lastSep);
/* Print out edwSubmitDir.  Separate fields with sep. Follow last field with lastSep. */

#define edwSubmitDirTabOut(el,f) edwSubmitDirOutput(el,f,'\t','\n');
/* Print out edwSubmitDir as a line in a tab-separated file. */

#define edwSubmitDirCommaOut(el,f) edwSubmitDirOutput(el,f,',',',');
/* Print out edwSubmitDir as a comma separated list including final comma. */

#define EDWFILE_NUM_COLS 14

extern char *edwFileCommaSepFieldNames;

struct edwFile
/* A file we are tracking that we intend to and maybe have uploaded */
    {
    struct edwFile *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincrementing file id */
    unsigned submitId;	/* Links to id in submit table */
    unsigned submitDirId;	/* Links to id in submitDir table */
    char *submitFileName;	/* File name in submit relative to submit dir */
    char *edwFileName;	/* File name in big data warehouse relative to edw root dir */
    long long startUploadTime;	/* Time when upload started - 0 if not started */
    long long endUploadTime;	/* Time when upload finished - 0 if not finished */
    long long updateTime;	/* Update time (on system it was uploaded from) */
    long long size;	/* File size in manifest */
    char md5[33];	/* md5 sum of file contents */
    char *tags;	/* CGI encoded name=val pairs from manifest */
    char *errorMessage;	/* If non-empty contains last error message from upload. If empty upload is ok */
    char *deprecated;	/* If non-empty why you shouldn't use this file any more. */
    unsigned replacedBy;	/* If non-zero id of file that replaces this one. */
    };

void edwFileStaticLoad(char **row, struct edwFile *ret);
/* Load a row from edwFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwFile *edwFileLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwFileFreeList(). */

void edwFileSaveToDb(struct sqlConnection *conn, struct edwFile *el, char *tableName, int updateSize);
/* Save edwFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwFile *edwFileLoad(char **row);
/* Load a edwFile from row fetched with select * from edwFile
 * from database.  Dispose of this with edwFileFree(). */

struct edwFile *edwFileLoadAll(char *fileName);
/* Load all edwFile from whitespace-separated file.
 * Dispose of this with edwFileFreeList(). */

struct edwFile *edwFileLoadAllByChar(char *fileName, char chopper);
/* Load all edwFile from chopper separated file.
 * Dispose of this with edwFileFreeList(). */

#define edwFileLoadAllByTab(a) edwFileLoadAllByChar(a, '\t');
/* Load all edwFile from tab separated file.
 * Dispose of this with edwFileFreeList(). */

struct edwFile *edwFileCommaIn(char **pS, struct edwFile *ret);
/* Create a edwFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwFile */

void edwFileFree(struct edwFile **pEl);
/* Free a single dynamically allocated edwFile such as created
 * with edwFileLoad(). */

void edwFileFreeList(struct edwFile **pList);
/* Free a list of dynamically allocated edwFile's */

void edwFileOutput(struct edwFile *el, FILE *f, char sep, char lastSep);
/* Print out edwFile.  Separate fields with sep. Follow last field with lastSep. */

#define edwFileTabOut(el,f) edwFileOutput(el,f,'\t','\n');
/* Print out edwFile as a line in a tab-separated file. */

#define edwFileCommaOut(el,f) edwFileOutput(el,f,',',',');
/* Print out edwFile as a comma separated list including final comma. */

#define EDWSUBMIT_NUM_COLS 16

extern char *edwSubmitCommaSepFieldNames;

struct edwSubmit
/* A data submit, typically containing many files.  Always associated with a submit dir. */
    {
    struct edwSubmit *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented submit id */
    char *url;	/* Url to validated.txt format file. We copy this file over and give it a fileId if we can. */
    long long startUploadTime;	/* Time at start of submit */
    long long endUploadTime;	/* Time at end of upload - 0 if not finished */
    unsigned userId;	/* Connects to user table id field */
    unsigned submitFileId;	/* Points to validated.txt file for submit. */
    unsigned submitDirId;	/* Points to the submitDir */
    unsigned fileCount;	/* Number of files that will be in submit if it were complete. */
    unsigned oldFiles;	/* Number of files in submission that were already in warehouse. */
    unsigned newFiles;	/* Number of files in submission that are newly uploaded. */
    long long byteCount;	/* Total bytes in submission including old and new */
    long long oldBytes;	/* Bytes in old files. */
    long long newBytes;	/* Bytes in new files (so far). */
    char *errorMessage;	/* If non-empty contains last error message. If empty submit is ok */
    unsigned fileIdInTransit;	/* edwFile.id of file currently being transferred or zero */
    unsigned metaChangeCount;	/* Number of files where metadata changed by submission */
    };

void edwSubmitStaticLoad(char **row, struct edwSubmit *ret);
/* Load a row from edwSubmit table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwSubmit *edwSubmitLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwSubmit from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwSubmitFreeList(). */

void edwSubmitSaveToDb(struct sqlConnection *conn, struct edwSubmit *el, char *tableName, int updateSize);
/* Save edwSubmit as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwSubmit *edwSubmitLoad(char **row);
/* Load a edwSubmit from row fetched with select * from edwSubmit
 * from database.  Dispose of this with edwSubmitFree(). */

struct edwSubmit *edwSubmitLoadAll(char *fileName);
/* Load all edwSubmit from whitespace-separated file.
 * Dispose of this with edwSubmitFreeList(). */

struct edwSubmit *edwSubmitLoadAllByChar(char *fileName, char chopper);
/* Load all edwSubmit from chopper separated file.
 * Dispose of this with edwSubmitFreeList(). */

#define edwSubmitLoadAllByTab(a) edwSubmitLoadAllByChar(a, '\t');
/* Load all edwSubmit from tab separated file.
 * Dispose of this with edwSubmitFreeList(). */

struct edwSubmit *edwSubmitCommaIn(char **pS, struct edwSubmit *ret);
/* Create a edwSubmit out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwSubmit */

void edwSubmitFree(struct edwSubmit **pEl);
/* Free a single dynamically allocated edwSubmit such as created
 * with edwSubmitLoad(). */

void edwSubmitFreeList(struct edwSubmit **pList);
/* Free a list of dynamically allocated edwSubmit's */

void edwSubmitOutput(struct edwSubmit *el, FILE *f, char sep, char lastSep);
/* Print out edwSubmit.  Separate fields with sep. Follow last field with lastSep. */

#define edwSubmitTabOut(el,f) edwSubmitOutput(el,f,'\t','\n');
/* Print out edwSubmit as a line in a tab-separated file. */

#define edwSubmitCommaOut(el,f) edwSubmitOutput(el,f,',',',');
/* Print out edwSubmit as a comma separated list including final comma. */

#define EDWSUBSCRIBER_NUM_COLS 7

extern char *edwSubscriberCommaSepFieldNames;

struct edwSubscriber
/* Subscribers can have programs that are called at various points during data submission */
    {
    struct edwSubscriber *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of subscriber */
    char *name;	/* Name of subscriber */
    double runOrder;	/* Determines order subscribers run in. In case of tie lowest id wins. */
    char *filePattern;	/* A string with * and ? wildcards to match files we care about */
    char *dirPattern;	/* A string with * and ? wildcards to match hub dir URLs we care about */
    char *tagPattern;	/* A cgi-encoded string of tag=wildcard pairs. */
    char *onFileEndUpload;	/* A unix command string to run with a %u where file id goes */
    };

void edwSubscriberStaticLoad(char **row, struct edwSubscriber *ret);
/* Load a row from edwSubscriber table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwSubscriber *edwSubscriberLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwSubscriber from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwSubscriberFreeList(). */

void edwSubscriberSaveToDb(struct sqlConnection *conn, struct edwSubscriber *el, char *tableName, int updateSize);
/* Save edwSubscriber as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwSubscriber *edwSubscriberLoad(char **row);
/* Load a edwSubscriber from row fetched with select * from edwSubscriber
 * from database.  Dispose of this with edwSubscriberFree(). */

struct edwSubscriber *edwSubscriberLoadAll(char *fileName);
/* Load all edwSubscriber from whitespace-separated file.
 * Dispose of this with edwSubscriberFreeList(). */

struct edwSubscriber *edwSubscriberLoadAllByChar(char *fileName, char chopper);
/* Load all edwSubscriber from chopper separated file.
 * Dispose of this with edwSubscriberFreeList(). */

#define edwSubscriberLoadAllByTab(a) edwSubscriberLoadAllByChar(a, '\t');
/* Load all edwSubscriber from tab separated file.
 * Dispose of this with edwSubscriberFreeList(). */

struct edwSubscriber *edwSubscriberCommaIn(char **pS, struct edwSubscriber *ret);
/* Create a edwSubscriber out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwSubscriber */

void edwSubscriberFree(struct edwSubscriber **pEl);
/* Free a single dynamically allocated edwSubscriber such as created
 * with edwSubscriberLoad(). */

void edwSubscriberFreeList(struct edwSubscriber **pList);
/* Free a list of dynamically allocated edwSubscriber's */

void edwSubscriberOutput(struct edwSubscriber *el, FILE *f, char sep, char lastSep);
/* Print out edwSubscriber.  Separate fields with sep. Follow last field with lastSep. */

#define edwSubscriberTabOut(el,f) edwSubscriberOutput(el,f,'\t','\n');
/* Print out edwSubscriber as a line in a tab-separated file. */

#define edwSubscriberCommaOut(el,f) edwSubscriberOutput(el,f,',',',');
/* Print out edwSubscriber as a comma separated list including final comma. */

#define EDWASSEMBLY_NUM_COLS 8

extern char *edwAssemblyCommaSepFieldNames;

struct edwAssembly
/* An assembly - includes reference to a two bit file, and a little name and summary info. */
    {
    struct edwAssembly *next;  /* Next in singly linked list. */
    unsigned id;	/* Assembly ID */
    unsigned taxon;	/* NCBI taxon number */
    char *name;	/* Some human readable name to distinguish this from other collections of DNA */
    char *ucscDb;	/* Which UCSC database (mm9?  hg19?) associated with it. */
    unsigned twoBitId;	/* File ID of associated twoBit file */
    long long baseCount;	/* Count of bases including N's */
    long long realBaseCount;	/* Count of non-N bases in assembly */
    unsigned seqCount;	/* Number of chromosomes or other distinct sequences in assembly */
    };

void edwAssemblyStaticLoad(char **row, struct edwAssembly *ret);
/* Load a row from edwAssembly table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwAssembly *edwAssemblyLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwAssembly from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwAssemblyFreeList(). */

void edwAssemblySaveToDb(struct sqlConnection *conn, struct edwAssembly *el, char *tableName, int updateSize);
/* Save edwAssembly as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwAssembly *edwAssemblyLoad(char **row);
/* Load a edwAssembly from row fetched with select * from edwAssembly
 * from database.  Dispose of this with edwAssemblyFree(). */

struct edwAssembly *edwAssemblyLoadAll(char *fileName);
/* Load all edwAssembly from whitespace-separated file.
 * Dispose of this with edwAssemblyFreeList(). */

struct edwAssembly *edwAssemblyLoadAllByChar(char *fileName, char chopper);
/* Load all edwAssembly from chopper separated file.
 * Dispose of this with edwAssemblyFreeList(). */

#define edwAssemblyLoadAllByTab(a) edwAssemblyLoadAllByChar(a, '\t');
/* Load all edwAssembly from tab separated file.
 * Dispose of this with edwAssemblyFreeList(). */

struct edwAssembly *edwAssemblyCommaIn(char **pS, struct edwAssembly *ret);
/* Create a edwAssembly out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwAssembly */

void edwAssemblyFree(struct edwAssembly **pEl);
/* Free a single dynamically allocated edwAssembly such as created
 * with edwAssemblyLoad(). */

void edwAssemblyFreeList(struct edwAssembly **pList);
/* Free a list of dynamically allocated edwAssembly's */

void edwAssemblyOutput(struct edwAssembly *el, FILE *f, char sep, char lastSep);
/* Print out edwAssembly.  Separate fields with sep. Follow last field with lastSep. */

#define edwAssemblyTabOut(el,f) edwAssemblyOutput(el,f,'\t','\n');
/* Print out edwAssembly as a line in a tab-separated file. */

#define edwAssemblyCommaOut(el,f) edwAssemblyOutput(el,f,',',',');
/* Print out edwAssembly as a comma separated list including final comma. */

#define EDWBIOSAMPLE_NUM_COLS 4

extern char *edwBiosampleCommaSepFieldNames;

struct edwBiosample
/* A biosample - not much info here, just enough to drive analysis pipeline */
    {
    struct edwBiosample *next;  /* Next in singly linked list. */
    unsigned id;	/* Biosample id */
    char *term;	/* Human readable.  Shared with ENCODE2. */
    unsigned taxon;	/* NCBI taxon number - 9606 for human. */
    char *sex;	/* One letter code: M male, F female, B both, U unknown */
    };

void edwBiosampleStaticLoad(char **row, struct edwBiosample *ret);
/* Load a row from edwBiosample table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwBiosample *edwBiosampleLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwBiosample from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwBiosampleFreeList(). */

void edwBiosampleSaveToDb(struct sqlConnection *conn, struct edwBiosample *el, char *tableName, int updateSize);
/* Save edwBiosample as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwBiosample *edwBiosampleLoad(char **row);
/* Load a edwBiosample from row fetched with select * from edwBiosample
 * from database.  Dispose of this with edwBiosampleFree(). */

struct edwBiosample *edwBiosampleLoadAll(char *fileName);
/* Load all edwBiosample from whitespace-separated file.
 * Dispose of this with edwBiosampleFreeList(). */

struct edwBiosample *edwBiosampleLoadAllByChar(char *fileName, char chopper);
/* Load all edwBiosample from chopper separated file.
 * Dispose of this with edwBiosampleFreeList(). */

#define edwBiosampleLoadAllByTab(a) edwBiosampleLoadAllByChar(a, '\t');
/* Load all edwBiosample from tab separated file.
 * Dispose of this with edwBiosampleFreeList(). */

struct edwBiosample *edwBiosampleCommaIn(char **pS, struct edwBiosample *ret);
/* Create a edwBiosample out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwBiosample */

void edwBiosampleFree(struct edwBiosample **pEl);
/* Free a single dynamically allocated edwBiosample such as created
 * with edwBiosampleLoad(). */

void edwBiosampleFreeList(struct edwBiosample **pList);
/* Free a list of dynamically allocated edwBiosample's */

void edwBiosampleOutput(struct edwBiosample *el, FILE *f, char sep, char lastSep);
/* Print out edwBiosample.  Separate fields with sep. Follow last field with lastSep. */

#define edwBiosampleTabOut(el,f) edwBiosampleOutput(el,f,'\t','\n');
/* Print out edwBiosample as a line in a tab-separated file. */

#define edwBiosampleCommaOut(el,f) edwBiosampleOutput(el,f,',',',');
/* Print out edwBiosample as a comma separated list including final comma. */

#define EDWEXPERIMENT_NUM_COLS 8

extern char *edwExperimentCommaSepFieldNames;

struct edwExperiment
/* An experiment - ideally will include a couple of biological replicates. Downloaded from Stanford. */
    {
    struct edwExperiment *next;  /* Next in singly linked list. */
    char accession[17];	/* Something like ENCSR000CFA. ID shared with Stanford. */
    char *dataType;	/* Something liek RNA-seq, DNase-seq, ChIP-seq. Computed at UCSC. */
    char *lab;	/* Lab PI name and institution. Is lab.title at Stanford. */
    char *biosample;	/* Cell line name, tissue source, etc. Is biosample_term_name at Stanford. */
    char *rfa;	/* Something like 'ENCODE2' or 'ENCODE3'.  Is award.rfa at Stanford. */
    char *assayType;	/* Similar to dataType. Is assay_term_name at Stanford. */
    char *ipTarget;	/* The target for the immunoprecipitation in ChIP & RIP. */
    char *control;	/* Primary control for experiment.  Usually another experiment accession. */
    };

void edwExperimentStaticLoad(char **row, struct edwExperiment *ret);
/* Load a row from edwExperiment table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwExperiment *edwExperimentLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwExperiment from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwExperimentFreeList(). */

void edwExperimentSaveToDb(struct sqlConnection *conn, struct edwExperiment *el, char *tableName, int updateSize);
/* Save edwExperiment as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwExperiment *edwExperimentLoad(char **row);
/* Load a edwExperiment from row fetched with select * from edwExperiment
 * from database.  Dispose of this with edwExperimentFree(). */

struct edwExperiment *edwExperimentLoadAll(char *fileName);
/* Load all edwExperiment from whitespace-separated file.
 * Dispose of this with edwExperimentFreeList(). */

struct edwExperiment *edwExperimentLoadAllByChar(char *fileName, char chopper);
/* Load all edwExperiment from chopper separated file.
 * Dispose of this with edwExperimentFreeList(). */

#define edwExperimentLoadAllByTab(a) edwExperimentLoadAllByChar(a, '\t');
/* Load all edwExperiment from tab separated file.
 * Dispose of this with edwExperimentFreeList(). */

struct edwExperiment *edwExperimentCommaIn(char **pS, struct edwExperiment *ret);
/* Create a edwExperiment out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwExperiment */

void edwExperimentFree(struct edwExperiment **pEl);
/* Free a single dynamically allocated edwExperiment such as created
 * with edwExperimentLoad(). */

void edwExperimentFreeList(struct edwExperiment **pList);
/* Free a list of dynamically allocated edwExperiment's */

void edwExperimentOutput(struct edwExperiment *el, FILE *f, char sep, char lastSep);
/* Print out edwExperiment.  Separate fields with sep. Follow last field with lastSep. */

#define edwExperimentTabOut(el,f) edwExperimentOutput(el,f,'\t','\n');
/* Print out edwExperiment as a line in a tab-separated file. */

#define edwExperimentCommaOut(el,f) edwExperimentOutput(el,f,',',',');
/* Print out edwExperiment as a comma separated list including final comma. */

#define EDWVALIDFILE_NUM_COLS 24

extern char *edwValidFileCommaSepFieldNames;

struct edwValidFile
/* A file that has been uploaded, the format checked, and for which at least minimal metadata exists */
    {
    struct edwValidFile *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of validated file */
    char licensePlate[17];	/* A abc123 looking license-platish thing. */
    unsigned fileId;	/* Pointer to file in main file table */
    char *format;	/* What format it's in from manifest */
    char *outputType;	/* What output_type it is from manifest */
    char *experiment;	/* What experiment it's in from manifest */
    char *replicate;	/* What replicate it is from manifest.  Values 1,2,3... pooled, or '' */
    char *validKey;	/* The valid_key tag from manifest */
    char *enrichedIn;	/* The enriched_in tag from manifest */
    char *ucscDb;	/* Something like hg19 or mm9 */
    long long itemCount;	/* # of items in file: reads for fastqs, lines for beds, bases w/data for wig. */
    long long basesInItems;	/* # of bases in items */
    long long sampleCount;	/* # of items in sample if we are just subsampling as we do for reads. */
    long long basesInSample;	/* # of bases in our sample */
    char *sampleBed;	/* Path to a temporary bed file holding sample items */
    double mapRatio;	/* Proportion of items that map to genome */
    double sampleCoverage;	/* Proportion of assembly covered by at least one item in sample */
    double depth;	/* Estimated genome-equivalents covered by possibly overlapping data */
    signed char singleQaStatus;	/* 0 = untested, 1 =  pass, -1 = fail, 2 = forced pass, -2 = forced fail */
    signed char replicateQaStatus;	/* 0 = untested, 1 = pass, -1 = fail, 2 = forced pass, -2 = forced fail */
    char *technicalReplicate;	/* Manifest's technical_replicate tag. Values 1,2,3... pooled or '' */
    char *pairedEnd;	/* The paired_end tag from the manifest.  Values 1,2 or '' */
    signed char qaVersion;	/* Version of QA pipeline making status decisions */
    double uniqueMapRatio;	/* Fraction of reads that map uniquely to genome for bams and fastqs */
    };

void edwValidFileStaticLoad(char **row, struct edwValidFile *ret);
/* Load a row from edwValidFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwValidFile *edwValidFileLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwValidFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwValidFileFreeList(). */

void edwValidFileSaveToDb(struct sqlConnection *conn, struct edwValidFile *el, char *tableName, int updateSize);
/* Save edwValidFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwValidFile *edwValidFileLoad(char **row);
/* Load a edwValidFile from row fetched with select * from edwValidFile
 * from database.  Dispose of this with edwValidFileFree(). */

struct edwValidFile *edwValidFileLoadAll(char *fileName);
/* Load all edwValidFile from whitespace-separated file.
 * Dispose of this with edwValidFileFreeList(). */

struct edwValidFile *edwValidFileLoadAllByChar(char *fileName, char chopper);
/* Load all edwValidFile from chopper separated file.
 * Dispose of this with edwValidFileFreeList(). */

#define edwValidFileLoadAllByTab(a) edwValidFileLoadAllByChar(a, '\t');
/* Load all edwValidFile from tab separated file.
 * Dispose of this with edwValidFileFreeList(). */

struct edwValidFile *edwValidFileCommaIn(char **pS, struct edwValidFile *ret);
/* Create a edwValidFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwValidFile */

void edwValidFileFree(struct edwValidFile **pEl);
/* Free a single dynamically allocated edwValidFile such as created
 * with edwValidFileLoad(). */

void edwValidFileFreeList(struct edwValidFile **pList);
/* Free a list of dynamically allocated edwValidFile's */

void edwValidFileOutput(struct edwValidFile *el, FILE *f, char sep, char lastSep);
/* Print out edwValidFile.  Separate fields with sep. Follow last field with lastSep. */

#define edwValidFileTabOut(el,f) edwValidFileOutput(el,f,'\t','\n');
/* Print out edwValidFile as a line in a tab-separated file. */

#define edwValidFileCommaOut(el,f) edwValidFileOutput(el,f,',',',');
/* Print out edwValidFile as a comma separated list including final comma. */

#define EDWFASTQFILE_NUM_COLS 29

extern char *edwFastqFileCommaSepFieldNames;

struct edwFastqFile
/* info on a file in fastq short read format beyond what's in edwValidFile */
    {
    struct edwFastqFile *next;  /* Next in singly linked list. */
    unsigned id;	/* ID in this table */
    unsigned fileId;	/* ID in edwFile table */
    long long sampleCount;	/* # of reads in sample. */
    long long basesInSample;	/* # of bases in sample. */
    char *sampleFileName;	/* Name of file containing sampleCount randomly selected items from file. */
    long long readCount;	/* # of reads in file */
    long long baseCount;	/* # of bases in all reads added up */
    double readSizeMean;	/* Average read size */
    double readSizeStd;	/* Standard deviation of read size */
    int readSizeMin;	/* Minimum read size */
    int readSizeMax;	/* Maximum read size */
    double qualMean;	/* Mean quality scored as 10*-log10(errorProbability) or close to it.  >25 is good */
    double qualStd;	/* Standard deviation of quality */
    double qualMin;	/* Minimum observed quality */
    double qualMax;	/* Maximum observed quality */
    char *qualType;	/* For fastq files either 'sanger' or 'illumina' */
    int qualZero;	/* For fastq files offset to get to zero value in ascii encoding */
    double atRatio;	/* Ratio of A+T to total sequence (not including Ns) */
    double aRatio;	/* Ratio of A to total sequence (including Ns) */
    double cRatio;	/* Ratio of C to total sequence (including Ns) */
    double gRatio;	/* Ratio of G to total sequence (including Ns) */
    double tRatio;	/* Ratio of T to total sequence (including Ns) */
    double nRatio;	/* Ratio of N or . to total sequence */
    double *qualPos;	/* Mean value for each position in a read up to some max. */
    double *aAtPos;	/* % of As at each pos */
    double *cAtPos;	/* % of Cs at each pos */
    double *gAtPos;	/* % of Gs at each pos */
    double *tAtPos;	/* % of Ts at each pos */
    double *nAtPos;	/* % of '.' or 'N' at each pos */
    };

struct edwFastqFile *edwFastqFileLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwFastqFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwFastqFileFreeList(). */

void edwFastqFileSaveToDb(struct sqlConnection *conn, struct edwFastqFile *el, char *tableName, int updateSize);
/* Save edwFastqFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwFastqFile *edwFastqFileLoad(char **row);
/* Load a edwFastqFile from row fetched with select * from edwFastqFile
 * from database.  Dispose of this with edwFastqFileFree(). */

struct edwFastqFile *edwFastqFileLoadAll(char *fileName);
/* Load all edwFastqFile from whitespace-separated file.
 * Dispose of this with edwFastqFileFreeList(). */

struct edwFastqFile *edwFastqFileLoadAllByChar(char *fileName, char chopper);
/* Load all edwFastqFile from chopper separated file.
 * Dispose of this with edwFastqFileFreeList(). */

#define edwFastqFileLoadAllByTab(a) edwFastqFileLoadAllByChar(a, '\t');
/* Load all edwFastqFile from tab separated file.
 * Dispose of this with edwFastqFileFreeList(). */

struct edwFastqFile *edwFastqFileCommaIn(char **pS, struct edwFastqFile *ret);
/* Create a edwFastqFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwFastqFile */

void edwFastqFileFree(struct edwFastqFile **pEl);
/* Free a single dynamically allocated edwFastqFile such as created
 * with edwFastqFileLoad(). */

void edwFastqFileFreeList(struct edwFastqFile **pList);
/* Free a list of dynamically allocated edwFastqFile's */

void edwFastqFileOutput(struct edwFastqFile *el, FILE *f, char sep, char lastSep);
/* Print out edwFastqFile.  Separate fields with sep. Follow last field with lastSep. */

#define edwFastqFileTabOut(el,f) edwFastqFileOutput(el,f,'\t','\n');
/* Print out edwFastqFile as a line in a tab-separated file. */

#define edwFastqFileCommaOut(el,f) edwFastqFileOutput(el,f,',',',');
/* Print out edwFastqFile as a comma separated list including final comma. */

#define EDWBAMFILE_NUM_COLS 17

extern char *edwBamFileCommaSepFieldNames;

struct edwBamFile
/* Info on what is in a bam file beyond whet's in edwValidFile */
    {
    struct edwBamFile *next;  /* Next in singly linked list. */
    unsigned id;	/* ID in this table */
    unsigned fileId;	/* ID in edwFile table. */
    signed char isPaired;	/* Set to 1 if paired reads, 0 if single */
    signed char isSortedByTarget;	/* Set to 1 if sorted by target,pos */
    long long readCount;	/* # of reads in file */
    long long readBaseCount;	/* # of bases in all reads added up */
    long long mappedCount;	/* # of reads that map */
    long long uniqueMappedCount;	/* # of reads that map to a unique position */
    double readSizeMean;	/* Average read size */
    double readSizeStd;	/* Standard deviation of read size */
    int readSizeMin;	/* Minimum read size */
    int readSizeMax;	/* Maximum read size */
    int u4mReadCount;	/* Uniquely-mapped 4 million read actual read # (usually 4M) */
    int u4mUniquePos;	/* Unique positions in target of the 4M reads that map to single pos */
    double u4mUniqueRatio;	/* u4mUniqPos/u4mReadCount - measures library diversity */
    long long targetBaseCount;	/* Count of bases in mapping target */
    unsigned targetSeqCount;	/* Number of chromosomes or other distinct sequences in mapping target */
    };

void edwBamFileStaticLoad(char **row, struct edwBamFile *ret);
/* Load a row from edwBamFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwBamFile *edwBamFileLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwBamFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwBamFileFreeList(). */

void edwBamFileSaveToDb(struct sqlConnection *conn, struct edwBamFile *el, char *tableName, int updateSize);
/* Save edwBamFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwBamFile *edwBamFileLoad(char **row);
/* Load a edwBamFile from row fetched with select * from edwBamFile
 * from database.  Dispose of this with edwBamFileFree(). */

struct edwBamFile *edwBamFileLoadAll(char *fileName);
/* Load all edwBamFile from whitespace-separated file.
 * Dispose of this with edwBamFileFreeList(). */

struct edwBamFile *edwBamFileLoadAllByChar(char *fileName, char chopper);
/* Load all edwBamFile from chopper separated file.
 * Dispose of this with edwBamFileFreeList(). */

#define edwBamFileLoadAllByTab(a) edwBamFileLoadAllByChar(a, '\t');
/* Load all edwBamFile from tab separated file.
 * Dispose of this with edwBamFileFreeList(). */

struct edwBamFile *edwBamFileCommaIn(char **pS, struct edwBamFile *ret);
/* Create a edwBamFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwBamFile */

void edwBamFileFree(struct edwBamFile **pEl);
/* Free a single dynamically allocated edwBamFile such as created
 * with edwBamFileLoad(). */

void edwBamFileFreeList(struct edwBamFile **pList);
/* Free a list of dynamically allocated edwBamFile's */

void edwBamFileOutput(struct edwBamFile *el, FILE *f, char sep, char lastSep);
/* Print out edwBamFile.  Separate fields with sep. Follow last field with lastSep. */

#define edwBamFileTabOut(el,f) edwBamFileOutput(el,f,'\t','\n');
/* Print out edwBamFile as a line in a tab-separated file. */

#define edwBamFileCommaOut(el,f) edwBamFileOutput(el,f,',',',');
/* Print out edwBamFile as a comma separated list including final comma. */

#define EDWQAFAIL_NUM_COLS 4

extern char *edwQaFailCommaSepFieldNames;

struct edwQaFail
/* Record of a QA failure. */
    {
    struct edwQaFail *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of failure */
    unsigned fileId;	/* File that failed */
    unsigned qaVersion;	/* QA pipeline version */
    char *reason;	/* reason for failure */
    };

void edwQaFailStaticLoad(char **row, struct edwQaFail *ret);
/* Load a row from edwQaFail table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwQaFail *edwQaFailLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwQaFail from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaFailFreeList(). */

void edwQaFailSaveToDb(struct sqlConnection *conn, struct edwQaFail *el, char *tableName, int updateSize);
/* Save edwQaFail as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwQaFail *edwQaFailLoad(char **row);
/* Load a edwQaFail from row fetched with select * from edwQaFail
 * from database.  Dispose of this with edwQaFailFree(). */

struct edwQaFail *edwQaFailLoadAll(char *fileName);
/* Load all edwQaFail from whitespace-separated file.
 * Dispose of this with edwQaFailFreeList(). */

struct edwQaFail *edwQaFailLoadAllByChar(char *fileName, char chopper);
/* Load all edwQaFail from chopper separated file.
 * Dispose of this with edwQaFailFreeList(). */

#define edwQaFailLoadAllByTab(a) edwQaFailLoadAllByChar(a, '\t');
/* Load all edwQaFail from tab separated file.
 * Dispose of this with edwQaFailFreeList(). */

struct edwQaFail *edwQaFailCommaIn(char **pS, struct edwQaFail *ret);
/* Create a edwQaFail out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaFail */

void edwQaFailFree(struct edwQaFail **pEl);
/* Free a single dynamically allocated edwQaFail such as created
 * with edwQaFailLoad(). */

void edwQaFailFreeList(struct edwQaFail **pList);
/* Free a list of dynamically allocated edwQaFail's */

void edwQaFailOutput(struct edwQaFail *el, FILE *f, char sep, char lastSep);
/* Print out edwQaFail.  Separate fields with sep. Follow last field with lastSep. */

#define edwQaFailTabOut(el,f) edwQaFailOutput(el,f,'\t','\n');
/* Print out edwQaFail as a line in a tab-separated file. */

#define edwQaFailCommaOut(el,f) edwQaFailOutput(el,f,',',',');
/* Print out edwQaFail as a comma separated list including final comma. */

#define EDWQAENRICHTARGET_NUM_COLS 5

extern char *edwQaEnrichTargetCommaSepFieldNames;

struct edwQaEnrichTarget
/* A target for our enrichment analysis. */
    {
    struct edwQaEnrichTarget *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of this enrichment target */
    unsigned assemblyId;	/* Which assembly this goes to */
    char *name;	/* Something like 'exon' or 'promoter' */
    unsigned fileId;	/* A simple BED 3 format file that defines target. Bases covered are unique */
    long long targetSize;	/* Total number of bases covered by target */
    };

void edwQaEnrichTargetStaticLoad(char **row, struct edwQaEnrichTarget *ret);
/* Load a row from edwQaEnrichTarget table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwQaEnrichTarget *edwQaEnrichTargetLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwQaEnrichTarget from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaEnrichTargetFreeList(). */

void edwQaEnrichTargetSaveToDb(struct sqlConnection *conn, struct edwQaEnrichTarget *el, char *tableName, int updateSize);
/* Save edwQaEnrichTarget as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwQaEnrichTarget *edwQaEnrichTargetLoad(char **row);
/* Load a edwQaEnrichTarget from row fetched with select * from edwQaEnrichTarget
 * from database.  Dispose of this with edwQaEnrichTargetFree(). */

struct edwQaEnrichTarget *edwQaEnrichTargetLoadAll(char *fileName);
/* Load all edwQaEnrichTarget from whitespace-separated file.
 * Dispose of this with edwQaEnrichTargetFreeList(). */

struct edwQaEnrichTarget *edwQaEnrichTargetLoadAllByChar(char *fileName, char chopper);
/* Load all edwQaEnrichTarget from chopper separated file.
 * Dispose of this with edwQaEnrichTargetFreeList(). */

#define edwQaEnrichTargetLoadAllByTab(a) edwQaEnrichTargetLoadAllByChar(a, '\t');
/* Load all edwQaEnrichTarget from tab separated file.
 * Dispose of this with edwQaEnrichTargetFreeList(). */

struct edwQaEnrichTarget *edwQaEnrichTargetCommaIn(char **pS, struct edwQaEnrichTarget *ret);
/* Create a edwQaEnrichTarget out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaEnrichTarget */

void edwQaEnrichTargetFree(struct edwQaEnrichTarget **pEl);
/* Free a single dynamically allocated edwQaEnrichTarget such as created
 * with edwQaEnrichTargetLoad(). */

void edwQaEnrichTargetFreeList(struct edwQaEnrichTarget **pList);
/* Free a list of dynamically allocated edwQaEnrichTarget's */

void edwQaEnrichTargetOutput(struct edwQaEnrichTarget *el, FILE *f, char sep, char lastSep);
/* Print out edwQaEnrichTarget.  Separate fields with sep. Follow last field with lastSep. */

#define edwQaEnrichTargetTabOut(el,f) edwQaEnrichTargetOutput(el,f,'\t','\n');
/* Print out edwQaEnrichTarget as a line in a tab-separated file. */

#define edwQaEnrichTargetCommaOut(el,f) edwQaEnrichTargetOutput(el,f,',',',');
/* Print out edwQaEnrichTarget as a comma separated list including final comma. */

#define EDWQAENRICH_NUM_COLS 8

extern char *edwQaEnrichCommaSepFieldNames;

struct edwQaEnrich
/* An enrichment analysis applied to file. */
    {
    struct edwQaEnrich *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of this enrichment analysis */
    unsigned fileId;	/* File we are looking at skeptically */
    unsigned qaEnrichTargetId;	/* Information about a target for this analysis */
    long long targetBaseHits;	/* Number of hits to bases in target */
    long long targetUniqHits;	/* Number of unique bases hit in target */
    double coverage;	/* Coverage of target - just targetUniqHits/targetSize */
    double enrichment;	/* Amount we hit target/amount we hit genome */
    double uniqEnrich;	/* coverage/sampleCoverage */
    };

void edwQaEnrichStaticLoad(char **row, struct edwQaEnrich *ret);
/* Load a row from edwQaEnrich table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwQaEnrich *edwQaEnrichLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwQaEnrich from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaEnrichFreeList(). */

void edwQaEnrichSaveToDb(struct sqlConnection *conn, struct edwQaEnrich *el, char *tableName, int updateSize);
/* Save edwQaEnrich as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwQaEnrich *edwQaEnrichLoad(char **row);
/* Load a edwQaEnrich from row fetched with select * from edwQaEnrich
 * from database.  Dispose of this with edwQaEnrichFree(). */

struct edwQaEnrich *edwQaEnrichLoadAll(char *fileName);
/* Load all edwQaEnrich from whitespace-separated file.
 * Dispose of this with edwQaEnrichFreeList(). */

struct edwQaEnrich *edwQaEnrichLoadAllByChar(char *fileName, char chopper);
/* Load all edwQaEnrich from chopper separated file.
 * Dispose of this with edwQaEnrichFreeList(). */

#define edwQaEnrichLoadAllByTab(a) edwQaEnrichLoadAllByChar(a, '\t');
/* Load all edwQaEnrich from tab separated file.
 * Dispose of this with edwQaEnrichFreeList(). */

struct edwQaEnrich *edwQaEnrichCommaIn(char **pS, struct edwQaEnrich *ret);
/* Create a edwQaEnrich out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaEnrich */

void edwQaEnrichFree(struct edwQaEnrich **pEl);
/* Free a single dynamically allocated edwQaEnrich such as created
 * with edwQaEnrichLoad(). */

void edwQaEnrichFreeList(struct edwQaEnrich **pList);
/* Free a list of dynamically allocated edwQaEnrich's */

void edwQaEnrichOutput(struct edwQaEnrich *el, FILE *f, char sep, char lastSep);
/* Print out edwQaEnrich.  Separate fields with sep. Follow last field with lastSep. */

#define edwQaEnrichTabOut(el,f) edwQaEnrichOutput(el,f,'\t','\n');
/* Print out edwQaEnrich as a line in a tab-separated file. */

#define edwQaEnrichCommaOut(el,f) edwQaEnrichOutput(el,f,',',',');
/* Print out edwQaEnrich as a comma separated list including final comma. */

#define EDWQACONTAMTARGET_NUM_COLS 2

extern char *edwQaContamTargetCommaSepFieldNames;

struct edwQaContamTarget
/* A target for our contamination analysis. */
    {
    struct edwQaContamTarget *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of this contamination target */
    unsigned assemblyId;	/* Assembly we're aligning against to check  for contamination. */
    };

void edwQaContamTargetStaticLoad(char **row, struct edwQaContamTarget *ret);
/* Load a row from edwQaContamTarget table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwQaContamTarget *edwQaContamTargetLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwQaContamTarget from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaContamTargetFreeList(). */

void edwQaContamTargetSaveToDb(struct sqlConnection *conn, struct edwQaContamTarget *el, char *tableName, int updateSize);
/* Save edwQaContamTarget as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwQaContamTarget *edwQaContamTargetLoad(char **row);
/* Load a edwQaContamTarget from row fetched with select * from edwQaContamTarget
 * from database.  Dispose of this with edwQaContamTargetFree(). */

struct edwQaContamTarget *edwQaContamTargetLoadAll(char *fileName);
/* Load all edwQaContamTarget from whitespace-separated file.
 * Dispose of this with edwQaContamTargetFreeList(). */

struct edwQaContamTarget *edwQaContamTargetLoadAllByChar(char *fileName, char chopper);
/* Load all edwQaContamTarget from chopper separated file.
 * Dispose of this with edwQaContamTargetFreeList(). */

#define edwQaContamTargetLoadAllByTab(a) edwQaContamTargetLoadAllByChar(a, '\t');
/* Load all edwQaContamTarget from tab separated file.
 * Dispose of this with edwQaContamTargetFreeList(). */

struct edwQaContamTarget *edwQaContamTargetCommaIn(char **pS, struct edwQaContamTarget *ret);
/* Create a edwQaContamTarget out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaContamTarget */

void edwQaContamTargetFree(struct edwQaContamTarget **pEl);
/* Free a single dynamically allocated edwQaContamTarget such as created
 * with edwQaContamTargetLoad(). */

void edwQaContamTargetFreeList(struct edwQaContamTarget **pList);
/* Free a list of dynamically allocated edwQaContamTarget's */

void edwQaContamTargetOutput(struct edwQaContamTarget *el, FILE *f, char sep, char lastSep);
/* Print out edwQaContamTarget.  Separate fields with sep. Follow last field with lastSep. */

#define edwQaContamTargetTabOut(el,f) edwQaContamTargetOutput(el,f,'\t','\n');
/* Print out edwQaContamTarget as a line in a tab-separated file. */

#define edwQaContamTargetCommaOut(el,f) edwQaContamTargetOutput(el,f,',',',');
/* Print out edwQaContamTarget as a comma separated list including final comma. */

#define EDWQACONTAM_NUM_COLS 4

extern char *edwQaContamCommaSepFieldNames;

struct edwQaContam
/* Results of contamination analysis of one file against one target */
    {
    struct edwQaContam *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of this contamination analysis */
    unsigned fileId;	/* File we are looking at skeptically */
    unsigned qaContamTargetId;	/* Information about a target for this analysis */
    double mapRatio;	/* Proportion of items that map to target */
    };

void edwQaContamStaticLoad(char **row, struct edwQaContam *ret);
/* Load a row from edwQaContam table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwQaContam *edwQaContamLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwQaContam from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaContamFreeList(). */

void edwQaContamSaveToDb(struct sqlConnection *conn, struct edwQaContam *el, char *tableName, int updateSize);
/* Save edwQaContam as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwQaContam *edwQaContamLoad(char **row);
/* Load a edwQaContam from row fetched with select * from edwQaContam
 * from database.  Dispose of this with edwQaContamFree(). */

struct edwQaContam *edwQaContamLoadAll(char *fileName);
/* Load all edwQaContam from whitespace-separated file.
 * Dispose of this with edwQaContamFreeList(). */

struct edwQaContam *edwQaContamLoadAllByChar(char *fileName, char chopper);
/* Load all edwQaContam from chopper separated file.
 * Dispose of this with edwQaContamFreeList(). */

#define edwQaContamLoadAllByTab(a) edwQaContamLoadAllByChar(a, '\t');
/* Load all edwQaContam from tab separated file.
 * Dispose of this with edwQaContamFreeList(). */

struct edwQaContam *edwQaContamCommaIn(char **pS, struct edwQaContam *ret);
/* Create a edwQaContam out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaContam */

void edwQaContamFree(struct edwQaContam **pEl);
/* Free a single dynamically allocated edwQaContam such as created
 * with edwQaContamLoad(). */

void edwQaContamFreeList(struct edwQaContam **pList);
/* Free a list of dynamically allocated edwQaContam's */

void edwQaContamOutput(struct edwQaContam *el, FILE *f, char sep, char lastSep);
/* Print out edwQaContam.  Separate fields with sep. Follow last field with lastSep. */

#define edwQaContamTabOut(el,f) edwQaContamOutput(el,f,'\t','\n');
/* Print out edwQaContam as a line in a tab-separated file. */

#define edwQaContamCommaOut(el,f) edwQaContamOutput(el,f,',',',');
/* Print out edwQaContam as a comma separated list including final comma. */

#define EDWQAREPEAT_NUM_COLS 4

extern char *edwQaRepeatCommaSepFieldNames;

struct edwQaRepeat
/* What percentage of data set aligns to various repeat classes. */
    {
    struct edwQaRepeat *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of this repeat analysis. */
    unsigned fileId;	/* File we are analysing. */
    char *repeatClass;	/* RepeatMasker high end classification,  or 'total' for all repeats. */
    double mapRatio;	/* Proportion that map to this repeat. */
    };

void edwQaRepeatStaticLoad(char **row, struct edwQaRepeat *ret);
/* Load a row from edwQaRepeat table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwQaRepeat *edwQaRepeatLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwQaRepeat from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaRepeatFreeList(). */

void edwQaRepeatSaveToDb(struct sqlConnection *conn, struct edwQaRepeat *el, char *tableName, int updateSize);
/* Save edwQaRepeat as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwQaRepeat *edwQaRepeatLoad(char **row);
/* Load a edwQaRepeat from row fetched with select * from edwQaRepeat
 * from database.  Dispose of this with edwQaRepeatFree(). */

struct edwQaRepeat *edwQaRepeatLoadAll(char *fileName);
/* Load all edwQaRepeat from whitespace-separated file.
 * Dispose of this with edwQaRepeatFreeList(). */

struct edwQaRepeat *edwQaRepeatLoadAllByChar(char *fileName, char chopper);
/* Load all edwQaRepeat from chopper separated file.
 * Dispose of this with edwQaRepeatFreeList(). */

#define edwQaRepeatLoadAllByTab(a) edwQaRepeatLoadAllByChar(a, '\t');
/* Load all edwQaRepeat from tab separated file.
 * Dispose of this with edwQaRepeatFreeList(). */

struct edwQaRepeat *edwQaRepeatCommaIn(char **pS, struct edwQaRepeat *ret);
/* Create a edwQaRepeat out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaRepeat */

void edwQaRepeatFree(struct edwQaRepeat **pEl);
/* Free a single dynamically allocated edwQaRepeat such as created
 * with edwQaRepeatLoad(). */

void edwQaRepeatFreeList(struct edwQaRepeat **pList);
/* Free a list of dynamically allocated edwQaRepeat's */

void edwQaRepeatOutput(struct edwQaRepeat *el, FILE *f, char sep, char lastSep);
/* Print out edwQaRepeat.  Separate fields with sep. Follow last field with lastSep. */

#define edwQaRepeatTabOut(el,f) edwQaRepeatOutput(el,f,'\t','\n');
/* Print out edwQaRepeat as a line in a tab-separated file. */

#define edwQaRepeatCommaOut(el,f) edwQaRepeatOutput(el,f,',',',');
/* Print out edwQaRepeat as a comma separated list including final comma. */

#define EDWQAPAIRSAMPLEOVERLAP_NUM_COLS 7

extern char *edwQaPairSampleOverlapCommaSepFieldNames;

struct edwQaPairSampleOverlap
/* A comparison of the amount of overlap between two samples that cover ~0.1% to 10% of target. */
    {
    struct edwQaPairSampleOverlap *next;  /* Next in singly linked list. */
    unsigned id;	/* Id of this qa pair */
    unsigned elderFileId;	/* Id of elder (smaller fileId) in correlated pair */
    unsigned youngerFileId;	/* Id of younger (larger fileId) in correlated pair */
    long long elderSampleBases;	/* Number of bases in elder sample */
    long long youngerSampleBases;	/* Number of bases in younger sample */
    long long sampleOverlapBases;	/* Number of bases that overlap between younger and elder sample */
    double sampleSampleEnrichment;	/* Amount samples overlap more than expected. */
    };

void edwQaPairSampleOverlapStaticLoad(char **row, struct edwQaPairSampleOverlap *ret);
/* Load a row from edwQaPairSampleOverlap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwQaPairSampleOverlap *edwQaPairSampleOverlapLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwQaPairSampleOverlap from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaPairSampleOverlapFreeList(). */

void edwQaPairSampleOverlapSaveToDb(struct sqlConnection *conn, struct edwQaPairSampleOverlap *el, char *tableName, int updateSize);
/* Save edwQaPairSampleOverlap as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwQaPairSampleOverlap *edwQaPairSampleOverlapLoad(char **row);
/* Load a edwQaPairSampleOverlap from row fetched with select * from edwQaPairSampleOverlap
 * from database.  Dispose of this with edwQaPairSampleOverlapFree(). */

struct edwQaPairSampleOverlap *edwQaPairSampleOverlapLoadAll(char *fileName);
/* Load all edwQaPairSampleOverlap from whitespace-separated file.
 * Dispose of this with edwQaPairSampleOverlapFreeList(). */

struct edwQaPairSampleOverlap *edwQaPairSampleOverlapLoadAllByChar(char *fileName, char chopper);
/* Load all edwQaPairSampleOverlap from chopper separated file.
 * Dispose of this with edwQaPairSampleOverlapFreeList(). */

#define edwQaPairSampleOverlapLoadAllByTab(a) edwQaPairSampleOverlapLoadAllByChar(a, '\t');
/* Load all edwQaPairSampleOverlap from tab separated file.
 * Dispose of this with edwQaPairSampleOverlapFreeList(). */

struct edwQaPairSampleOverlap *edwQaPairSampleOverlapCommaIn(char **pS, struct edwQaPairSampleOverlap *ret);
/* Create a edwQaPairSampleOverlap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaPairSampleOverlap */

void edwQaPairSampleOverlapFree(struct edwQaPairSampleOverlap **pEl);
/* Free a single dynamically allocated edwQaPairSampleOverlap such as created
 * with edwQaPairSampleOverlapLoad(). */

void edwQaPairSampleOverlapFreeList(struct edwQaPairSampleOverlap **pList);
/* Free a list of dynamically allocated edwQaPairSampleOverlap's */

void edwQaPairSampleOverlapOutput(struct edwQaPairSampleOverlap *el, FILE *f, char sep, char lastSep);
/* Print out edwQaPairSampleOverlap.  Separate fields with sep. Follow last field with lastSep. */

#define edwQaPairSampleOverlapTabOut(el,f) edwQaPairSampleOverlapOutput(el,f,'\t','\n');
/* Print out edwQaPairSampleOverlap as a line in a tab-separated file. */

#define edwQaPairSampleOverlapCommaOut(el,f) edwQaPairSampleOverlapOutput(el,f,',',',');
/* Print out edwQaPairSampleOverlap as a comma separated list including final comma. */

#define EDWQAPAIRCORRELATION_NUM_COLS 6

extern char *edwQaPairCorrelationCommaSepFieldNames;

struct edwQaPairCorrelation
/* A correlation between two files of the same type. */
    {
    struct edwQaPairCorrelation *next;  /* Next in singly linked list. */
    unsigned id;	/* Id of this correlation pair */
    unsigned elderFileId;	/* Id of elder (smaller fileId) in correlated pair */
    unsigned youngerFileId;	/* Id of younger (larger fileId) in correlated pair */
    double pearsonInEnriched;	/* Pearson's R inside enriched areas where there is overlap */
    double pearsonOverall;	/* Pearson's R over all places where both have data */
    double pearsonClipped;	/* Pearson's R clipped at two standard deviations up from the mean */
    };

void edwQaPairCorrelationStaticLoad(char **row, struct edwQaPairCorrelation *ret);
/* Load a row from edwQaPairCorrelation table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwQaPairCorrelation *edwQaPairCorrelationLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwQaPairCorrelation from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaPairCorrelationFreeList(). */

void edwQaPairCorrelationSaveToDb(struct sqlConnection *conn, struct edwQaPairCorrelation *el, char *tableName, int updateSize);
/* Save edwQaPairCorrelation as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwQaPairCorrelation *edwQaPairCorrelationLoad(char **row);
/* Load a edwQaPairCorrelation from row fetched with select * from edwQaPairCorrelation
 * from database.  Dispose of this with edwQaPairCorrelationFree(). */

struct edwQaPairCorrelation *edwQaPairCorrelationLoadAll(char *fileName);
/* Load all edwQaPairCorrelation from whitespace-separated file.
 * Dispose of this with edwQaPairCorrelationFreeList(). */

struct edwQaPairCorrelation *edwQaPairCorrelationLoadAllByChar(char *fileName, char chopper);
/* Load all edwQaPairCorrelation from chopper separated file.
 * Dispose of this with edwQaPairCorrelationFreeList(). */

#define edwQaPairCorrelationLoadAllByTab(a) edwQaPairCorrelationLoadAllByChar(a, '\t');
/* Load all edwQaPairCorrelation from tab separated file.
 * Dispose of this with edwQaPairCorrelationFreeList(). */

struct edwQaPairCorrelation *edwQaPairCorrelationCommaIn(char **pS, struct edwQaPairCorrelation *ret);
/* Create a edwQaPairCorrelation out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaPairCorrelation */

void edwQaPairCorrelationFree(struct edwQaPairCorrelation **pEl);
/* Free a single dynamically allocated edwQaPairCorrelation such as created
 * with edwQaPairCorrelationLoad(). */

void edwQaPairCorrelationFreeList(struct edwQaPairCorrelation **pList);
/* Free a list of dynamically allocated edwQaPairCorrelation's */

void edwQaPairCorrelationOutput(struct edwQaPairCorrelation *el, FILE *f, char sep, char lastSep);
/* Print out edwQaPairCorrelation.  Separate fields with sep. Follow last field with lastSep. */

#define edwQaPairCorrelationTabOut(el,f) edwQaPairCorrelationOutput(el,f,'\t','\n');
/* Print out edwQaPairCorrelation as a line in a tab-separated file. */

#define edwQaPairCorrelationCommaOut(el,f) edwQaPairCorrelationOutput(el,f,',',',');
/* Print out edwQaPairCorrelation as a comma separated list including final comma. */

#define EDWQAPAIREDENDFASTQ_NUM_COLS 9

extern char *edwQaPairedEndFastqCommaSepFieldNames;

struct edwQaPairedEndFastq
/* Information about two paired-end fastqs */
    {
    struct edwQaPairedEndFastq *next;  /* Next in singly linked list. */
    unsigned id;	/* Id of this set of paired end files */
    unsigned fileId1;	/* Id of first in pair */
    unsigned fileId2;	/* Id of second in pair */
    double concordance;	/* % of uniquely aligning reads where pairs nearby and point right way */
    double distanceMean;	/* Average distance between reads */
    double distanceStd;	/* Standard deviation of distance */
    double distanceMin;	/* Minimum distance */
    double distanceMax;	/* Maximum distatnce */
    signed char recordComplete;	/* Flag to avoid a race condition. Ignore record if this is 0 */
    };

void edwQaPairedEndFastqStaticLoad(char **row, struct edwQaPairedEndFastq *ret);
/* Load a row from edwQaPairedEndFastq table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwQaPairedEndFastq *edwQaPairedEndFastqLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwQaPairedEndFastq from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaPairedEndFastqFreeList(). */

void edwQaPairedEndFastqSaveToDb(struct sqlConnection *conn, struct edwQaPairedEndFastq *el, char *tableName, int updateSize);
/* Save edwQaPairedEndFastq as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwQaPairedEndFastq *edwQaPairedEndFastqLoad(char **row);
/* Load a edwQaPairedEndFastq from row fetched with select * from edwQaPairedEndFastq
 * from database.  Dispose of this with edwQaPairedEndFastqFree(). */

struct edwQaPairedEndFastq *edwQaPairedEndFastqLoadAll(char *fileName);
/* Load all edwQaPairedEndFastq from whitespace-separated file.
 * Dispose of this with edwQaPairedEndFastqFreeList(). */

struct edwQaPairedEndFastq *edwQaPairedEndFastqLoadAllByChar(char *fileName, char chopper);
/* Load all edwQaPairedEndFastq from chopper separated file.
 * Dispose of this with edwQaPairedEndFastqFreeList(). */

#define edwQaPairedEndFastqLoadAllByTab(a) edwQaPairedEndFastqLoadAllByChar(a, '\t');
/* Load all edwQaPairedEndFastq from tab separated file.
 * Dispose of this with edwQaPairedEndFastqFreeList(). */

struct edwQaPairedEndFastq *edwQaPairedEndFastqCommaIn(char **pS, struct edwQaPairedEndFastq *ret);
/* Create a edwQaPairedEndFastq out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaPairedEndFastq */

void edwQaPairedEndFastqFree(struct edwQaPairedEndFastq **pEl);
/* Free a single dynamically allocated edwQaPairedEndFastq such as created
 * with edwQaPairedEndFastqLoad(). */

void edwQaPairedEndFastqFreeList(struct edwQaPairedEndFastq **pList);
/* Free a list of dynamically allocated edwQaPairedEndFastq's */

void edwQaPairedEndFastqOutput(struct edwQaPairedEndFastq *el, FILE *f, char sep, char lastSep);
/* Print out edwQaPairedEndFastq.  Separate fields with sep. Follow last field with lastSep. */

#define edwQaPairedEndFastqTabOut(el,f) edwQaPairedEndFastqOutput(el,f,'\t','\n');
/* Print out edwQaPairedEndFastq as a line in a tab-separated file. */

#define edwQaPairedEndFastqCommaOut(el,f) edwQaPairedEndFastqOutput(el,f,',',',');
/* Print out edwQaPairedEndFastq as a comma separated list including final comma. */

#define EDWQAWIGSPOT_NUM_COLS 9

extern char *edwQaWigSpotCommaSepFieldNames;

struct edwQaWigSpot
/* Information about proportion of signal in a wig that lands under spots in a peak or bed file */
    {
    struct edwQaWigSpot *next;  /* Next in singly linked list. */
    unsigned id;	/* Id of this wig/spot intersection */
    unsigned wigId;	/* Id of bigWig file */
    unsigned spotId;	/* Id of a bigBed file probably broadPeak or narrowPeak */
    double spotRatio;	/* Ratio of signal in spots to total signal,  between 0 and 1 */
    double enrichment;	/* Enrichment in spots compared to genome overall */
    long long basesInGenome;	/* Number of bases in genome */
    long long basesInSpots;	/* Number of bases in spots */
    double sumSignal;	/* Total signal */
    double spotSumSignal;	/* Total signal in spots */
    };

void edwQaWigSpotStaticLoad(char **row, struct edwQaWigSpot *ret);
/* Load a row from edwQaWigSpot table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwQaWigSpot *edwQaWigSpotLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwQaWigSpot from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaWigSpotFreeList(). */

void edwQaWigSpotSaveToDb(struct sqlConnection *conn, struct edwQaWigSpot *el, char *tableName, int updateSize);
/* Save edwQaWigSpot as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwQaWigSpot *edwQaWigSpotLoad(char **row);
/* Load a edwQaWigSpot from row fetched with select * from edwQaWigSpot
 * from database.  Dispose of this with edwQaWigSpotFree(). */

struct edwQaWigSpot *edwQaWigSpotLoadAll(char *fileName);
/* Load all edwQaWigSpot from whitespace-separated file.
 * Dispose of this with edwQaWigSpotFreeList(). */

struct edwQaWigSpot *edwQaWigSpotLoadAllByChar(char *fileName, char chopper);
/* Load all edwQaWigSpot from chopper separated file.
 * Dispose of this with edwQaWigSpotFreeList(). */

#define edwQaWigSpotLoadAllByTab(a) edwQaWigSpotLoadAllByChar(a, '\t');
/* Load all edwQaWigSpot from tab separated file.
 * Dispose of this with edwQaWigSpotFreeList(). */

struct edwQaWigSpot *edwQaWigSpotCommaIn(char **pS, struct edwQaWigSpot *ret);
/* Create a edwQaWigSpot out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaWigSpot */

void edwQaWigSpotFree(struct edwQaWigSpot **pEl);
/* Free a single dynamically allocated edwQaWigSpot such as created
 * with edwQaWigSpotLoad(). */

void edwQaWigSpotFreeList(struct edwQaWigSpot **pList);
/* Free a list of dynamically allocated edwQaWigSpot's */

void edwQaWigSpotOutput(struct edwQaWigSpot *el, FILE *f, char sep, char lastSep);
/* Print out edwQaWigSpot.  Separate fields with sep. Follow last field with lastSep. */

#define edwQaWigSpotTabOut(el,f) edwQaWigSpotOutput(el,f,'\t','\n');
/* Print out edwQaWigSpot as a line in a tab-separated file. */

#define edwQaWigSpotCommaOut(el,f) edwQaWigSpotOutput(el,f,',',',');
/* Print out edwQaWigSpot as a comma separated list including final comma. */

#define EDWQADNASESINGLESTATS5M_NUM_COLS 18

extern char *edwQaDnaseSingleStats5mCommaSepFieldNames;

struct edwQaDnaseSingleStats5m
/* Statistics calculated based on a 5M sample of DNAse aligned reads from a bam file. */
    {
    struct edwQaDnaseSingleStats5m *next;  /* Next in singly linked list. */
    unsigned id;	/* Id of this row in table. */
    unsigned fileId;	/* Id of bam file this is calculated from */
    unsigned sampleReads;	/* Number of mapped reads  */
    double spotRatio;	/* Ratio of signal in spots to total signal,  between 0 and 1 */
    double enrichment;	/* Enrichment in spots compared to genome overall */
    long long basesInGenome;	/* Number of bases in genome */
    long long basesInSpots;	/* Number of bases in spots */
    double sumSignal;	/* Total signal */
    double spotSumSignal;	/* Total signal in spots */
    char *estFragLength;	/* Up to three comma separated strand cross-correlation peaks */
    char *corrEstFragLen;	/* Up to three cross strand correlations at the given peaks */
    int phantomPeak;	/* Read length/phantom peak strand shift */
    double corrPhantomPeak;	/* Correlation value at phantom peak */
    int argMinCorr;	/* strand shift at which cross-correlation is lowest */
    double minCorr;	/* minimum value of cross-correlation */
    double nsc;	/* Normalized strand cross-correlation coefficient (NSC) = corrEstFragLen/minCorr */
    double rsc;	/* Relative strand cross-correlation coefficient (RSC) */
    int rscQualityTag;	/* based on thresholded RSC (codes: -2:veryLow,-1:Low,0:Medium,1:High,2:veryHigh) */
    };

void edwQaDnaseSingleStats5mStaticLoad(char **row, struct edwQaDnaseSingleStats5m *ret);
/* Load a row from edwQaDnaseSingleStats5m table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwQaDnaseSingleStats5m *edwQaDnaseSingleStats5mLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwQaDnaseSingleStats5m from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaDnaseSingleStats5mFreeList(). */

void edwQaDnaseSingleStats5mSaveToDb(struct sqlConnection *conn, struct edwQaDnaseSingleStats5m *el, char *tableName, int updateSize);
/* Save edwQaDnaseSingleStats5m as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwQaDnaseSingleStats5m *edwQaDnaseSingleStats5mLoad(char **row);
/* Load a edwQaDnaseSingleStats5m from row fetched with select * from edwQaDnaseSingleStats5m
 * from database.  Dispose of this with edwQaDnaseSingleStats5mFree(). */

struct edwQaDnaseSingleStats5m *edwQaDnaseSingleStats5mLoadAll(char *fileName);
/* Load all edwQaDnaseSingleStats5m from whitespace-separated file.
 * Dispose of this with edwQaDnaseSingleStats5mFreeList(). */

struct edwQaDnaseSingleStats5m *edwQaDnaseSingleStats5mLoadAllByChar(char *fileName, char chopper);
/* Load all edwQaDnaseSingleStats5m from chopper separated file.
 * Dispose of this with edwQaDnaseSingleStats5mFreeList(). */

#define edwQaDnaseSingleStats5mLoadAllByTab(a) edwQaDnaseSingleStats5mLoadAllByChar(a, '\t');
/* Load all edwQaDnaseSingleStats5m from tab separated file.
 * Dispose of this with edwQaDnaseSingleStats5mFreeList(). */

struct edwQaDnaseSingleStats5m *edwQaDnaseSingleStats5mCommaIn(char **pS, struct edwQaDnaseSingleStats5m *ret);
/* Create a edwQaDnaseSingleStats5m out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaDnaseSingleStats5m */

void edwQaDnaseSingleStats5mFree(struct edwQaDnaseSingleStats5m **pEl);
/* Free a single dynamically allocated edwQaDnaseSingleStats5m such as created
 * with edwQaDnaseSingleStats5mLoad(). */

void edwQaDnaseSingleStats5mFreeList(struct edwQaDnaseSingleStats5m **pList);
/* Free a list of dynamically allocated edwQaDnaseSingleStats5m's */

void edwQaDnaseSingleStats5mOutput(struct edwQaDnaseSingleStats5m *el, FILE *f, char sep, char lastSep);
/* Print out edwQaDnaseSingleStats5m.  Separate fields with sep. Follow last field with lastSep. */

#define edwQaDnaseSingleStats5mTabOut(el,f) edwQaDnaseSingleStats5mOutput(el,f,'\t','\n');
/* Print out edwQaDnaseSingleStats5m as a line in a tab-separated file. */

#define edwQaDnaseSingleStats5mCommaOut(el,f) edwQaDnaseSingleStats5mOutput(el,f,',',',');
/* Print out edwQaDnaseSingleStats5m as a comma separated list including final comma. */

#define EDWJOB_NUM_COLS 7

extern char *edwJobCommaSepFieldNames;

struct edwJob
/* A job to be run asynchronously and not too many all at once. */
    {
    struct edwJob *next;  /* Next in singly linked list. */
    unsigned id;	/* Job id */
    char *commandLine;	/* Command line of job */
    long long startTime;	/* Start time in seconds since 1970 */
    long long endTime;	/* End time in seconds since 1970 */
    char *stderr;	/* The output to stderr of the run - may be nonempty even with success */
    int returnCode;	/* The return code from system command - 0 for success */
    int pid;	/* Process ID for running processes */
    };

void edwJobStaticLoad(char **row, struct edwJob *ret);
/* Load a row from edwJob table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwJob *edwJobLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwJob from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwJobFreeList(). */

void edwJobSaveToDb(struct sqlConnection *conn, struct edwJob *el, char *tableName, int updateSize);
/* Save edwJob as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwJob *edwJobLoad(char **row);
/* Load a edwJob from row fetched with select * from edwJob
 * from database.  Dispose of this with edwJobFree(). */

struct edwJob *edwJobLoadAll(char *fileName);
/* Load all edwJob from whitespace-separated file.
 * Dispose of this with edwJobFreeList(). */

struct edwJob *edwJobLoadAllByChar(char *fileName, char chopper);
/* Load all edwJob from chopper separated file.
 * Dispose of this with edwJobFreeList(). */

#define edwJobLoadAllByTab(a) edwJobLoadAllByChar(a, '\t');
/* Load all edwJob from tab separated file.
 * Dispose of this with edwJobFreeList(). */

struct edwJob *edwJobCommaIn(char **pS, struct edwJob *ret);
/* Create a edwJob out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwJob */

void edwJobFree(struct edwJob **pEl);
/* Free a single dynamically allocated edwJob such as created
 * with edwJobLoad(). */

void edwJobFreeList(struct edwJob **pList);
/* Free a list of dynamically allocated edwJob's */

void edwJobOutput(struct edwJob *el, FILE *f, char sep, char lastSep);
/* Print out edwJob.  Separate fields with sep. Follow last field with lastSep. */

#define edwJobTabOut(el,f) edwJobOutput(el,f,'\t','\n');
/* Print out edwJob as a line in a tab-separated file. */

#define edwJobCommaOut(el,f) edwJobOutput(el,f,',',',');
/* Print out edwJob as a comma separated list including final comma. */

#define EDWSUBMITJOB_NUM_COLS 7

extern char *edwSubmitJobCommaSepFieldNames;

struct edwSubmitJob
/* A submission job to be run asynchronously and not too many all at once. */
    {
    struct edwSubmitJob *next;  /* Next in singly linked list. */
    unsigned id;	/* Job id */
    char *commandLine;	/* Command line of job */
    long long startTime;	/* Start time in seconds since 1970 */
    long long endTime;	/* End time in seconds since 1970 */
    char *stderr;	/* The output to stderr of the run - may be nonempty even with success */
    int returnCode;	/* The return code from system command - 0 for success */
    int pid;	/* Process ID for running processes */
    };

void edwSubmitJobStaticLoad(char **row, struct edwSubmitJob *ret);
/* Load a row from edwSubmitJob table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct edwSubmitJob *edwSubmitJobLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all edwSubmitJob from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwSubmitJobFreeList(). */

void edwSubmitJobSaveToDb(struct sqlConnection *conn, struct edwSubmitJob *el, char *tableName, int updateSize);
/* Save edwSubmitJob as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct edwSubmitJob *edwSubmitJobLoad(char **row);
/* Load a edwSubmitJob from row fetched with select * from edwSubmitJob
 * from database.  Dispose of this with edwSubmitJobFree(). */

struct edwSubmitJob *edwSubmitJobLoadAll(char *fileName);
/* Load all edwSubmitJob from whitespace-separated file.
 * Dispose of this with edwSubmitJobFreeList(). */

struct edwSubmitJob *edwSubmitJobLoadAllByChar(char *fileName, char chopper);
/* Load all edwSubmitJob from chopper separated file.
 * Dispose of this with edwSubmitJobFreeList(). */

#define edwSubmitJobLoadAllByTab(a) edwSubmitJobLoadAllByChar(a, '\t');
/* Load all edwSubmitJob from tab separated file.
 * Dispose of this with edwSubmitJobFreeList(). */

struct edwSubmitJob *edwSubmitJobCommaIn(char **pS, struct edwSubmitJob *ret);
/* Create a edwSubmitJob out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwSubmitJob */

void edwSubmitJobFree(struct edwSubmitJob **pEl);
/* Free a single dynamically allocated edwSubmitJob such as created
 * with edwSubmitJobLoad(). */

void edwSubmitJobFreeList(struct edwSubmitJob **pList);
/* Free a list of dynamically allocated edwSubmitJob's */

void edwSubmitJobOutput(struct edwSubmitJob *el, FILE *f, char sep, char lastSep);
/* Print out edwSubmitJob.  Separate fields with sep. Follow last field with lastSep. */

#define edwSubmitJobTabOut(el,f) edwSubmitJobOutput(el,f,'\t','\n');
/* Print out edwSubmitJob as a line in a tab-separated file. */

#define edwSubmitJobCommaOut(el,f) edwSubmitJobOutput(el,f,',',',');
/* Print out edwSubmitJob as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ENCODEDATAWAREHOUSE_H */

