/* ancientRref.h was originally generated by the autoSql program, which also 
 * generated ancientRref.c and ancientRref.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2002 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ANCIENTRREF_H
#define ANCIENTRREF_H

struct ancientRref
/* Reference table for details page of human/mouse ancient repeat track. */
    {
    struct ancientRref *next;  /* Next in singly linked list. */
    char *id;	/* Unique id for each repeat */
    char *name;	/* human repeat name  */
    char *class;	/* repeat class */
    char *family;	/* repeat family */
    char *hseq;	/* Human sequence with gaps */
    char *mseq;	/* mouse sequence with gaps */
    };

void ancientRrefStaticLoad(char **row, struct ancientRref *ret);
/* Load a row from ancientRref table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct ancientRref *ancientRrefLoad(char **row);
/* Load a ancientRref from row fetched with select * from ancientRref
 * from database.  Dispose of this with ancientRrefFree(). */

struct ancientRref *ancientRrefLoadAll(char *fileName);
/* Load all ancientRref from a tab-separated file.
 * Dispose of this with ancientRrefFreeList(). */

struct ancientRref *ancientRrefCommaIn(char **pS, struct ancientRref *ret);
/* Create a ancientRref out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ancientRref */

void ancientRrefFree(struct ancientRref **pEl);
/* Free a single dynamically allocated ancientRref such as created
 * with ancientRrefLoad(). */

void ancientRrefFreeList(struct ancientRref **pList);
/* Free a list of dynamically allocated ancientRref's */

void ancientRrefOutput(struct ancientRref *el, FILE *f, char sep, char lastSep);
/* Print out ancientRref.  Separate fields with sep. Follow last field with lastSep. */

#define ancientRrefTabOut(el,f) ancientRrefOutput(el,f,'\t','\n');
/* Print out ancientRref as a line in a tab-separated file. */

#define ancientRrefCommaOut(el,f) ancientRrefOutput(el,f,',',',');
/* Print out ancientRref as a comma separated list including final comma. */

#endif /* ANCIENTRREF_H */

