/* asmSummary.h was originally generated by the autoSql program, which also 
 * generated asmSummary.c and asmSummary.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef ASMSUMMARY_H
#define ASMSUMMARY_H

#include "jksql.h"
#define ASMSUMMARY_NUM_COLS 37

extern char *asmSummaryCommaSepFieldNames;

struct asmSummary
/* NCBI assembly_summary data, see: https://ftp.ncbi.nlm.nih.gov/genomes/ASSEMBLY_REPORTS/README_assembly_summary.txt */
    {
    struct asmSummary *next;  /* Next in singly linked list. */
    char *assemblyAccession;	/* www.ncbi.nlm.nih.gov/assembly/?term=xxx */
    char *bioproject;	/* www.ncbi.nlm.nih.gov/bioproject/?term=xxx */
    char *biosample;	/* www.ncbi.nlm.nih.gov/biosample/?term=xxx */
    char *wgsMaster;	/* www.ncbi.nlm.nih.gov/nuccore/xxx */
    char *refseqCategory;	/* representative or reference */
    unsigned taxId;	/* www.ncbi.nlm.nih.gov/taxonomy/?term=xxx */
    unsigned speciesTaxid;	/* www.ncbi.nlm.nih.gov/taxonomy/?term=xxx */
    char *organismName;	/* binomial scientific name */
    char *infraspecificName;	/* strain/cultivar/ecotype/breed */
    char *isolate;	/* source of sample */
    char *versionStatus;	/* latest/suppressed/replaced */
    char *assemblyLevel;	/* Contig/Scaffold/Complete Genome/Chromosome */
    char *releaseType;	/* Major/Minor/Patch */
    char *genomeRep;	/* Full/Partial */
    char *seqRelDate;	/* date YYYY/MM/DD sequence released to INSDC */
    char *asmName;	/* submitter supplied name */
    char *asmSubmitter;	/* institution submitting assembly */
    char *gbrsPairedAsm;	/* GenBank<->RefSeq GCA/GCF relationship */
    char *pairedAsmComp;	/* identical/different for GCA<->GCF relationship */
    char *ftpPath;	/* ftp.ncbi.nlm.nih.gov/genomes/all/GCx/012/345/678/asmId */
    char *excludedFromRefseq;	/* noted reason for exclusion from RefSeq */
    char *relationToTypeMaterial;	/* note of assembly relation to sample */
    char *assemblyType;	/* haploid/diploid/haploid-with-alt-loci/alternate-pseudohaplotype */
    char *phyloGroup;	/* bacteria/viral/archaea/fungi/metagenomes/invertebrate/other/vertebrate_other/plant/vertebrate_mammalian/protozoa */
    long long genomeSize;	/* total length of all top-level sequences in the primary assembly */
    long long genomeSizeUngapped;	/* genome length not counting gaps (gap == 10 or more Ns) */
    float gcPercent;	/* GC percent */
    unsigned short repliconCount;	/* total number of chromosomes, organelle genomes and plasmids */
    unsigned scaffoldCount;	/* number of scaffolds: placed, unlocalzes, unplace, alternate loci and patch */
    unsigned contigCount;	/* number of conts in the primary assembly */
    char *annotationProvider;	/* the group that provied the annotation on the assembly */
    char *annotationName;	/* the name of the annotation */
    char *annotationDate;	/* annotation date YYYY/MM/DD */
    char *totalGeneCount;	/* total gene count in annotation */
    unsigned proteinCodingGeneCount;	/* protein coding gene count in annotation */
    char *nonCodingGeneCount;	/* non coding gene count in annotation */
    char *pubmedId;	/* comma separated list of PubMed ID(s) */
    };

void asmSummaryStaticLoadWithNull(char **row, struct asmSummary *ret);
/* Load a row from asmSummary table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct asmSummary *asmSummaryLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all asmSummary from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with asmSummaryFreeList(). */

void asmSummarySaveToDb(struct sqlConnection *conn, struct asmSummary *el, char *tableName, int updateSize);
/* Save asmSummary as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct asmSummary *asmSummaryLoadWithNull(char **row);
/* Load a asmSummary from row fetched with select * from asmSummary
 * from database.  Dispose of this with asmSummaryFree(). */

struct asmSummary *asmSummaryLoadAll(char *fileName);
/* Load all asmSummary from whitespace-separated file.
 * Dispose of this with asmSummaryFreeList(). */

struct asmSummary *asmSummaryLoadAllByChar(char *fileName, char chopper);
/* Load all asmSummary from chopper separated file.
 * Dispose of this with asmSummaryFreeList(). */

#define asmSummaryLoadAllByTab(a) asmSummaryLoadAllByChar(a, '\t');
/* Load all asmSummary from tab separated file.
 * Dispose of this with asmSummaryFreeList(). */

struct asmSummary *asmSummaryCommaIn(char **pS, struct asmSummary *ret);
/* Create a asmSummary out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new asmSummary */

void asmSummaryFree(struct asmSummary **pEl);
/* Free a single dynamically allocated asmSummary such as created
 * with asmSummaryLoad(). */

void asmSummaryFreeList(struct asmSummary **pList);
/* Free a list of dynamically allocated asmSummary's */

void asmSummaryOutput(struct asmSummary *el, FILE *f, char sep, char lastSep);
/* Print out asmSummary.  Separate fields with sep. Follow last field with lastSep. */

#define asmSummaryTabOut(el,f) asmSummaryOutput(el,f,'\t','\n');
/* Print out asmSummary as a line in a tab-separated file. */

#define asmSummaryCommaOut(el,f) asmSummaryOutput(el,f,',',',');
/* Print out asmSummary as a comma separated list including final comma. */

void asmSummaryJsonOutput(struct asmSummary *el, FILE *f);
/* Print out asmSummary in JSON format. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct asmSummary *asmSummaryFullText(struct sqlConnection *conn, char *words, long long rowLimit, long long *totalMatch);
/* perform a FULLTEXT search on the asmSummary table with the list
 *   of words string (may be only a single word)
 * return is a list of items found up to rowLimit, or NULL if none found
 *   also returning totalMatch to understand if it is more than the rowLimit
 */

#endif /* ASMSUMMARY_H */

