/* cnpSebat2.h was originally generated by the autoSql program, which also 
 * generated cnpSebat2.c and cnpSebat2.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef CNPSEBAT2_H
#define CNPSEBAT2_H

#define CNPSEBAT2_NUM_COLS 5

struct cnpSebat2
/* CNP Data from the Sebat lab */
    {
    struct cnpSebat2 *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* Gain or Loss */
    unsigned probes;	/* Number of probes */
    };

void cnpSebat2StaticLoad(char **row, struct cnpSebat2 *ret);
/* Load a row from cnpSebat2 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cnpSebat2 *cnpSebat2Load(char **row);
/* Load a cnpSebat2 from row fetched with select * from cnpSebat2
 * from database.  Dispose of this with cnpSebat2Free(). */

struct cnpSebat2 *cnpSebat2LoadAll(char *fileName);
/* Load all cnpSebat2 from whitespace-separated file.
 * Dispose of this with cnpSebat2FreeList(). */

struct cnpSebat2 *cnpSebat2LoadAllByChar(char *fileName, char chopper);
/* Load all cnpSebat2 from chopper separated file.
 * Dispose of this with cnpSebat2FreeList(). */

#define cnpSebat2LoadAllByTab(a) cnpSebat2LoadAllByChar(a, '\t');
/* Load all cnpSebat2 from tab separated file.
 * Dispose of this with cnpSebat2FreeList(). */

struct cnpSebat2 *cnpSebat2CommaIn(char **pS, struct cnpSebat2 *ret);
/* Create a cnpSebat2 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cnpSebat2 */

void cnpSebat2Free(struct cnpSebat2 **pEl);
/* Free a single dynamically allocated cnpSebat2 such as created
 * with cnpSebat2Load(). */

void cnpSebat2FreeList(struct cnpSebat2 **pList);
/* Free a list of dynamically allocated cnpSebat2's */

void cnpSebat2Output(struct cnpSebat2 *el, FILE *f, char sep, char lastSep);
/* Print out cnpSebat2.  Separate fields with sep. Follow last field with lastSep. */

#define cnpSebat2TabOut(el,f) cnpSebat2Output(el,f,'\t','\n');
/* Print out cnpSebat2 as a line in a tab-separated file. */

#define cnpSebat2CommaOut(el,f) cnpSebat2Output(el,f,',',',');
/* Print out cnpSebat2 as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* CNPSEBAT2_H */

