/* gtexTissue.h was originally generated by the autoSql program, which also 
 * generated gtexTissue.c and gtexTissue.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef GTEXTISSUE_H
#define GTEXTISSUE_H

#include "jksql.h"
#define GTEXTISSUE_NUM_COLS 6

extern char *gtexTissueCommaSepFieldNames;

struct gtexTissue
/* GTEx tissue information */
    {
    struct gtexTissue *next;  /* Next in singly linked list. */
    unsigned id;	/* internal id */
    char *name;	/* short UCSC identifier */
    char *description;	/* GTEX tissue type detail */
    char *organ;	/* GTEX tissue collection area */
    unsigned color;	/* GTEX assigned color */
    char *abbrev;	/* GTEX tissue abbreviation */
    };

void gtexTissueStaticLoad(char **row, struct gtexTissue *ret);
/* Load a row from gtexTissue table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct gtexTissue *gtexTissueLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all gtexTissue from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with gtexTissueFreeList(). */

void gtexTissueSaveToDb(struct sqlConnection *conn, struct gtexTissue *el, char *tableName, int updateSize);
/* Save gtexTissue as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct gtexTissue *gtexTissueLoad(char **row);
/* Load a gtexTissue from row fetched with select * from gtexTissue
 * from database.  Dispose of this with gtexTissueFree(). */

struct gtexTissue *gtexTissueLoadAll(char *fileName);
/* Load all gtexTissue from whitespace-separated file.
 * Dispose of this with gtexTissueFreeList(). */

struct gtexTissue *gtexTissueLoadAllByChar(char *fileName, char chopper);
/* Load all gtexTissue from chopper separated file.
 * Dispose of this with gtexTissueFreeList(). */

#define gtexTissueLoadAllByTab(a) gtexTissueLoadAllByChar(a, '\t');
/* Load all gtexTissue from tab separated file.
 * Dispose of this with gtexTissueFreeList(). */

struct gtexTissue *gtexTissueCommaIn(char **pS, struct gtexTissue *ret);
/* Create a gtexTissue out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexTissue */

void gtexTissueFree(struct gtexTissue **pEl);
/* Free a single dynamically allocated gtexTissue such as created
 * with gtexTissueLoad(). */

void gtexTissueFreeList(struct gtexTissue **pList);
/* Free a list of dynamically allocated gtexTissue's */

void gtexTissueOutput(struct gtexTissue *el, FILE *f, char sep, char lastSep);
/* Print out gtexTissue.  Separate fields with sep. Follow last field with lastSep. */

#define gtexTissueTabOut(el,f) gtexTissueOutput(el,f,'\t','\n');
/* Print out gtexTissue as a line in a tab-separated file. */

#define gtexTissueCommaOut(el,f) gtexTissueOutput(el,f,',',',');
/* Print out gtexTissue as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void gtexTissueCreateTable(struct sqlConnection *conn, char *table);
/* Create expression record format table of given name. */

struct gtexTissue *gtexGetTissues(char *version);
/* Get tissue id, descriptions, colors, etc. */

struct hash *gtexGetTissueSampleCount(char *version);
/* Return hash of sample counts keyed by tissue name */

struct rgbColor gtexTissueBrightenColor(struct rgbColor rgb);
/* Increase brightness for better visibility of small items */

char *gtexGetTissueDescription(int id, char *version);
/* Get description for a tissue specified by id.  
 * Use for single queries (o/w use gtexGetTissues) */

#endif /* GTEXTISSUE_H */
