/* wgEncodeGencodeTag.c was originally generated by the autoSql program, which also 
 * generated wgEncodeGencodeTag.h and wgEncodeGencodeTag.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2011 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "encode/wgEncodeGencodeTag.h"


void wgEncodeGencodeTagStaticLoad(char **row, struct wgEncodeGencodeTag *ret)
/* Load a row from wgEncodeGencodeTag table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->transcriptId = row[0];
ret->tag = row[1];
}

struct wgEncodeGencodeTag *wgEncodeGencodeTagLoad(char **row)
/* Load a wgEncodeGencodeTag from row fetched with select * from wgEncodeGencodeTag
 * from database.  Dispose of this with wgEncodeGencodeTagFree(). */
{
struct wgEncodeGencodeTag *ret;

AllocVar(ret);
ret->transcriptId = cloneString(row[0]);
ret->tag = cloneString(row[1]);
return ret;
}

struct wgEncodeGencodeTag *wgEncodeGencodeTagLoadAll(char *fileName) 
/* Load all wgEncodeGencodeTag from a whitespace-separated file.
 * Dispose of this with wgEncodeGencodeTagFreeList(). */
{
struct wgEncodeGencodeTag *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = wgEncodeGencodeTagLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct wgEncodeGencodeTag *wgEncodeGencodeTagLoadAllByChar(char *fileName, char chopper) 
/* Load all wgEncodeGencodeTag from a chopper separated file.
 * Dispose of this with wgEncodeGencodeTagFreeList(). */
{
struct wgEncodeGencodeTag *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = wgEncodeGencodeTagLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct wgEncodeGencodeTag *wgEncodeGencodeTagCommaIn(char **pS, struct wgEncodeGencodeTag *ret)
/* Create a wgEncodeGencodeTag out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new wgEncodeGencodeTag */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->transcriptId = sqlStringComma(&s);
ret->tag = sqlStringComma(&s);
*pS = s;
return ret;
}

void wgEncodeGencodeTagFree(struct wgEncodeGencodeTag **pEl)
/* Free a single dynamically allocated wgEncodeGencodeTag such as created
 * with wgEncodeGencodeTagLoad(). */
{
struct wgEncodeGencodeTag *el;

if ((el = *pEl) == NULL) return;
freeMem(el->transcriptId);
freeMem(el->tag);
freez(pEl);
}

void wgEncodeGencodeTagFreeList(struct wgEncodeGencodeTag **pList)
/* Free a list of dynamically allocated wgEncodeGencodeTag's */
{
struct wgEncodeGencodeTag *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    wgEncodeGencodeTagFree(&el);
    }
*pList = NULL;
}

void wgEncodeGencodeTagOutput(struct wgEncodeGencodeTag *el, FILE *f, char sep, char lastSep) 
/* Print out wgEncodeGencodeTag.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->transcriptId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tag);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

