/* sgdOther.c was originally generated by the autoSql program, which also 
 * generated sgdOther.h and sgdOther.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "sgdOther.h"


void sgdOtherStaticLoad(char **row, struct sgdOther *ret)
/* Load a row from sgdOther table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlSigned(row[1]);
ret->chromEnd = sqlSigned(row[2]);
ret->name = row[3];
ret->score = sqlSigned(row[4]);
strcpy(ret->strand, row[5]);
ret->type = row[6];
}

struct sgdOther *sgdOtherLoad(char **row)
/* Load a sgdOther from row fetched with select * from sgdOther
 * from database.  Dispose of this with sgdOtherFree(). */
{
struct sgdOther *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlSigned(row[1]);
ret->chromEnd = sqlSigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlSigned(row[4]);
strcpy(ret->strand, row[5]);
ret->type = cloneString(row[6]);
return ret;
}

struct sgdOther *sgdOtherLoadAll(char *fileName) 
/* Load all sgdOther from a whitespace-separated file.
 * Dispose of this with sgdOtherFreeList(). */
{
struct sgdOther *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = sgdOtherLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct sgdOther *sgdOtherLoadAllByChar(char *fileName, char chopper) 
/* Load all sgdOther from a chopper separated file.
 * Dispose of this with sgdOtherFreeList(). */
{
struct sgdOther *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = sgdOtherLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct sgdOther *sgdOtherCommaIn(char **pS, struct sgdOther *ret)
/* Create a sgdOther out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new sgdOther */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlSignedComma(&s);
ret->chromEnd = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlSignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->type = sqlStringComma(&s);
*pS = s;
return ret;
}

void sgdOtherFree(struct sgdOther **pEl)
/* Free a single dynamically allocated sgdOther such as created
 * with sgdOtherLoad(). */
{
struct sgdOther *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->type);
freez(pEl);
}

void sgdOtherFreeList(struct sgdOther **pList)
/* Free a list of dynamically allocated sgdOther's */
{
struct sgdOther *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    sgdOtherFree(&el);
    }
*pList = NULL;
}

void sgdOtherOutput(struct sgdOther *el, FILE *f, char sep, char lastSep) 
/* Print out sgdOther.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->chromStart);
fputc(sep,f);
fprintf(f, "%d", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

