# targetDb.sql was originally generated by the autoSql program, which also 
# generated targetDb.c and targetDb.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Description of non-genomic target sequences (e.g. native mRNAs for PCR)
CREATE TABLE targetDb (
    name varchar(255) not null,	# Identifier for this target
    description varchar(255) not null,	# Brief description for select box
    db varchar(255) not null,	# Database to which target has been mapped
    pslTable varchar(255) not null,	# PSL table in db that maps target coords to db coords
    seqTable varchar(255) not null,	# Table in db that has extFileTable indices of target sequences
    extFileTable varchar(255) not null,	# Table in db that has .id, .path, and .size of target sequence files
    seqFile varchar(255) not null,	# Target sequence file path (typically /gbdb/$db/targetDb/$name.2bit)
    priority float not null,		# Relative priority compared to other targets for same db (smaller numbers are higher priority)
    time datetime not null,	# Time at which this record was updated -- should be newer than db tables (so should blat server)
    settings longblob not null,	# .ra-formatted metadata
              #Indices
    PRIMARY KEY(name),
    INDEX(db)
);
