# txAliDiff.sql was originally generated by the autoSql program, which also 
# generated txAliDiff.c and txAliDiff.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Differences between reference genome and transcript sequences
CREATE TABLE txAliDiff (
    chrom varchar(255) not null,	# Reference sequence chromosome or scaffold
    chromStart int unsigned not null,	# Start position in chromosome of ambiguous gap placement region
    chromEnd int unsigned not null,	# End position in chromosome of ambiguous gap placement region
    name varchar(255) not null,	# Name of item
    score int unsigned not null,	# Not used
    strand char(1) not null,	# Transcript orientation on genome: + or -
    thickStart int unsigned not null,	# Start position of 3'-most location for gaps that can shift position without introducing mismatches
    thickEnd int unsigned not null,	# End position of 3'-most gap location for gaps that can shift position without introducing mismatches
    reserved int unsigned not null,	# RGB color of this item
    txName varchar(255) not null,	# Transcript identifier
    txStart int unsigned not null,	# Start position in transcript (of ambiguous gap placement region where applicable)
    txEnd int unsigned not null,	# End position in transcript (of ambiguous gap placement region where applicable)
    gSkipped int unsigned not null,	# Number of bases skipped on genome, if any
    txSkipped int unsigned not null,	# Number of bases skipped on transcript, if any
    shiftL int unsigned not null,	# Number of bases that gap can be shifted left on genome with no mismatches
    shiftR int unsigned not null,	# Number of bases that gap can be shifted right on genome with no mismatches
    hgvsG longblob not null,	# HGVS g. notation of genome change to match transcript
    hgvsCN longblob not null,	# HGVS c./n. notation of part of transcript not matched in genome
    hgvsN longblob not null,	# HGVS c./n. notation of transcript change to match genome
    hgvsPosCN longblob not null,	# HGVS c./n. position range of transcript ambiguous gap placement region
              #Indices
    PRIMARY KEY(chrom)
);
