/* binTest.h was originally generated by the autoSql program, which also 
 * generated binTest.c and binTest.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BINTEST_H
#define BINTEST_H

#define NONGENOMIC_NUM_COLS 3

struct nonGenomic
/* A table with non-genomic data */
    {
    struct nonGenomic *next;  /* Next in singly linked list. */
    unsigned key;	/* Private key */
    char *name;	/* A name in any format */
    char *address;	/* Address in free format */
    };

void nonGenomicStaticLoad(char **row, struct nonGenomic *ret);
/* Load a row from nonGenomic table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct nonGenomic *nonGenomicLoad(char **row);
/* Load a nonGenomic from row fetched with select * from nonGenomic
 * from database.  Dispose of this with nonGenomicFree(). */

struct nonGenomic *nonGenomicLoadAll(char *fileName);
/* Load all nonGenomic from whitespace-separated file.
 * Dispose of this with nonGenomicFreeList(). */

struct nonGenomic *nonGenomicLoadAllByChar(char *fileName, char chopper);
/* Load all nonGenomic from chopper separated file.
 * Dispose of this with nonGenomicFreeList(). */

#define nonGenomicLoadAllByTab(a) nonGenomicLoadAllByChar(a, '\t');
/* Load all nonGenomic from tab separated file.
 * Dispose of this with nonGenomicFreeList(). */

struct nonGenomic *nonGenomicCommaIn(char **pS, struct nonGenomic *ret);
/* Create a nonGenomic out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new nonGenomic */

void nonGenomicFree(struct nonGenomic **pEl);
/* Free a single dynamically allocated nonGenomic such as created
 * with nonGenomicLoad(). */

void nonGenomicFreeList(struct nonGenomic **pList);
/* Free a list of dynamically allocated nonGenomic's */

void nonGenomicOutput(struct nonGenomic *el, FILE *f, char sep, char lastSep);
/* Print out nonGenomic.  Separate fields with sep. Follow last field with lastSep. */

#define nonGenomicTabOut(el,f) nonGenomicOutput(el,f,'\t','\n');
/* Print out nonGenomic as a line in a tab-separated file. */

#define nonGenomicCommaOut(el,f) nonGenomicOutput(el,f,',',',');
/* Print out nonGenomic as a comma separated list including final comma. */

#define ALREADYBINNED_NUM_COLS 6

struct alreadyBinned
/* A table that already has chrom and bin */
    {
    struct alreadyBinned *next;  /* Next in singly linked list. */
    unsigned bin;	/* Browser speedup thing */
    char *chrom;	/* CHromosome */
    int start;	/* Start 0-based */
    int end;	/* End - non-inclusive */
    char *name;	/* What we are normally called */
    unsigned id;	/* What they use to look us up in database */
    };

void alreadyBinnedStaticLoad(char **row, struct alreadyBinned *ret);
/* Load a row from alreadyBinned table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct alreadyBinned *alreadyBinnedLoad(char **row);
/* Load a alreadyBinned from row fetched with select * from alreadyBinned
 * from database.  Dispose of this with alreadyBinnedFree(). */

struct alreadyBinned *alreadyBinnedLoadAll(char *fileName);
/* Load all alreadyBinned from whitespace-separated file.
 * Dispose of this with alreadyBinnedFreeList(). */

struct alreadyBinned *alreadyBinnedLoadAllByChar(char *fileName, char chopper);
/* Load all alreadyBinned from chopper separated file.
 * Dispose of this with alreadyBinnedFreeList(). */

#define alreadyBinnedLoadAllByTab(a) alreadyBinnedLoadAllByChar(a, '\t');
/* Load all alreadyBinned from tab separated file.
 * Dispose of this with alreadyBinnedFreeList(). */

struct alreadyBinned *alreadyBinnedCommaIn(char **pS, struct alreadyBinned *ret);
/* Create a alreadyBinned out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new alreadyBinned */

void alreadyBinnedFree(struct alreadyBinned **pEl);
/* Free a single dynamically allocated alreadyBinned such as created
 * with alreadyBinnedLoad(). */

void alreadyBinnedFreeList(struct alreadyBinned **pList);
/* Free a list of dynamically allocated alreadyBinned's */

void alreadyBinnedOutput(struct alreadyBinned *el, FILE *f, char sep, char lastSep);
/* Print out alreadyBinned.  Separate fields with sep. Follow last field with lastSep. */

#define alreadyBinnedTabOut(el,f) alreadyBinnedOutput(el,f,'\t','\n');
/* Print out alreadyBinned as a line in a tab-separated file. */

#define alreadyBinnedCommaOut(el,f) alreadyBinnedOutput(el,f,',',',');
/* Print out alreadyBinned as a comma separated list including final comma. */

#define NEEDBIN_NUM_COLS 6

struct needBin
/* A table that already chrom but needs bin */
    {
    struct needBin *next;  /* Next in singly linked list. */
    unsigned bin;	/* Bin number for browser speedup */
    char *chrom;	/* Chromosome */
    int start;	/* Start 0-based */
    int end;	/* End - non-inclusive */
    char *name;	/* What we are normally called */
    unsigned id;	/* What they use to look us up in database */
    };

void needBinStaticLoad(char **row, struct needBin *ret);
/* Load a row from needBin table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct needBin *needBinLoad(char **row);
/* Load a needBin from row fetched with select * from needBin
 * from database.  Dispose of this with needBinFree(). */

struct needBin *needBinLoadAll(char *fileName);
/* Load all needBin from whitespace-separated file.
 * Dispose of this with needBinFreeList(). */

struct needBin *needBinLoadAllByChar(char *fileName, char chopper);
/* Load all needBin from chopper separated file.
 * Dispose of this with needBinFreeList(). */

#define needBinLoadAllByTab(a) needBinLoadAllByChar(a, '\t');
/* Load all needBin from tab separated file.
 * Dispose of this with needBinFreeList(). */

struct needBin *needBinCommaIn(char **pS, struct needBin *ret);
/* Create a needBin out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new needBin */

void needBinFree(struct needBin **pEl);
/* Free a single dynamically allocated needBin such as created
 * with needBinLoad(). */

void needBinFreeList(struct needBin **pList);
/* Free a list of dynamically allocated needBin's */

void needBinOutput(struct needBin *el, FILE *f, char sep, char lastSep);
/* Print out needBin.  Separate fields with sep. Follow last field with lastSep. */

#define needBinTabOut(el,f) needBinOutput(el,f,'\t','\n');
/* Print out needBin as a line in a tab-separated file. */

#define needBinCommaOut(el,f) needBinOutput(el,f,',',',');
/* Print out needBin as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* BINTEST_H */

