/* pgPolyphenPred.c was originally generated by the autoSql program, which also 
 * generated pgPolyphenPred.h and pgPolyphenPred.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "pgPolyphenPred.h"
#include "hdb.h"


void pgPolyphenPredStaticLoadWithNull(char **row, struct pgPolyphenPred *ret)
/* Load a row from pgPolyphenPred table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
if (row[1] != NULL)
    {
    ret->chromStart = needMem(sizeof(*(ret->chromStart)));
    *(ret->chromStart) = sqlUnsigned(row[1]);
    }
else
    {
    ret->chromStart = NULL;
    }
if (row[2] != NULL)
    {
    ret->chromEnd = needMem(sizeof(*(ret->chromEnd)));
    *(ret->chromEnd) = sqlUnsigned(row[2]);
    }
else
    {
    ret->chromEnd = NULL;
    }
ret->prediction = row[3];
ret->basedOn = row[4];
ret->geneName = row[5];
ret->aaChange = row[6];
}

struct pgPolyphenPred *pgPolyphenPredLoadWithNull(char **row)
/* Load a pgPolyphenPred from row fetched with select * from pgPolyphenPred
 * from database.  Dispose of this with pgPolyphenPredFree(). */
{
struct pgPolyphenPred *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
if (row[1] != NULL)
    {
    ret->chromStart = needMem(sizeof(*(ret->chromStart)));
    *(ret->chromStart) = sqlUnsigned(row[1]);
    }
else
    {
    ret->chromStart = NULL;
    }
if (row[2] != NULL)
    {
    ret->chromEnd = needMem(sizeof(*(ret->chromEnd)));
    *(ret->chromEnd) = sqlUnsigned(row[2]);
    }
else
    {
    ret->chromEnd = NULL;
    }
ret->prediction = cloneString(row[3]);
ret->basedOn = cloneString(row[4]);
ret->geneName = cloneString(row[5]);
ret->aaChange = cloneString(row[6]);
return ret;
}

struct pgPolyphenPred *pgPolyphenPredLoadAll(char *fileName) 
/* Load all pgPolyphenPred from a whitespace-separated file.
 * Dispose of this with pgPolyphenPredFreeList(). */
{
struct pgPolyphenPred *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = pgPolyphenPredLoadWithNull(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct pgPolyphenPred *pgPolyphenPredLoadAllByChar(char *fileName, char chopper) 
/* Load all pgPolyphenPred from a chopper separated file.
 * Dispose of this with pgPolyphenPredFreeList(). */
{
struct pgPolyphenPred *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = pgPolyphenPredLoadWithNull(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct pgPolyphenPred *pgPolyphenPredCommaIn(char **pS, struct pgPolyphenPred *ret)
/* Create a pgPolyphenPred out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new pgPolyphenPred */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = needMem(sizeof(unsigned));
*(ret->chromStart) = sqlUnsignedComma(&s);
ret->chromEnd = needMem(sizeof(unsigned));
*(ret->chromEnd) = sqlUnsignedComma(&s);
ret->prediction = sqlStringComma(&s);
ret->basedOn = sqlStringComma(&s);
ret->geneName = sqlStringComma(&s);
ret->aaChange = sqlStringComma(&s);
*pS = s;
return ret;
}

void pgPolyphenPredFree(struct pgPolyphenPred **pEl)
/* Free a single dynamically allocated pgPolyphenPred such as created
 * with pgPolyphenPredLoad(). */
{
struct pgPolyphenPred *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->prediction);
freeMem(el->basedOn);
freeMem(el->geneName);
freeMem(el->aaChange);
freez(pEl);
}

void pgPolyphenPredFreeList(struct pgPolyphenPred **pList)
/* Free a list of dynamically allocated pgPolyphenPred's */
{
struct pgPolyphenPred *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    pgPolyphenPredFree(&el);
    }
*pList = NULL;
}

void pgPolyphenPredOutput(struct pgPolyphenPred *el, FILE *f, char sep, char lastSep) 
/* Print out pgPolyphenPred.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", *(el->chromStart));
fputc(sep,f);
fprintf(f, "%u", *(el->chromEnd));
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->prediction);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->basedOn);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->aaChange);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void printPgPolyphenPred (char *db, char *tableName, struct pgSnp *item)
/* print the predictions for an hgc item click for a pgSnp track */
{
struct pgPolyphenPred *el;
struct sqlResult *sr;
char **row;
char query[512];
struct sqlConnection *conn = hAllocConn(db);

sqlSafef(query, sizeof(query), "select * from %s where chrom = '%s' and chromStart = %d and chromEnd = %d",
    tableName, item->chrom, item->chromStart, item->chromEnd);
sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = pgPolyphenPredLoadWithNull(row);
    printf("<br><b>Polyphen prediction</b>: %s\n", el->prediction);
    printf("<ul>");
    if (el->basedOn != NULL && differentString(el->basedOn, ""))
        printf("<li>based on: %s</li>\n", el->basedOn);
    if (el->geneName != NULL && differentString(el->geneName, ""))
        printf("<li>Protein name: %s</li>\n", el->geneName);
    if (el->aaChange != NULL && differentString(el->aaChange, ""))
        printf("<li>Amino acid change: %s</li>\n", el->aaChange);
    printf("</ul>\n");
    }
}

