/* interaction.c was originally generated by the autoSql program, which also 
 * generated interaction.h and interaction.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "interaction.h"


void interactionStaticLoad(char **row, struct interaction *ret)
/* Load a row from interaction table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->fromX = row[0];
ret->toY = row[1];
ret->score = atof(row[2]);
}

struct interaction *interactionLoad(char **row)
/* Load a interaction from row fetched with select * from interaction
 * from database.  Dispose of this with interactionFree(). */
{
struct interaction *ret;

AllocVar(ret);
ret->fromX = cloneString(row[0]);
ret->toY = cloneString(row[1]);
ret->score = atof(row[2]);
return ret;
}

struct interaction *interactionLoadAll(char *fileName) 
/* Load all interaction from a whitespace-separated file.
 * Dispose of this with interactionFreeList(). */
{
struct interaction *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = interactionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct interaction *interactionLoadAllByChar(char *fileName, char chopper) 
/* Load all interaction from a chopper separated file.
 * Dispose of this with interactionFreeList(). */
{
struct interaction *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = interactionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct interaction *interactionLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all interaction from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with interactionFreeList(). */
{
struct interaction *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = interactionLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void interactionSaveToDb(struct sqlConnection *conn, struct interaction *el, char *tableName, int updateSize)
/* Save interaction as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s','%s',%g)", 
	tableName,  el->fromX,  el->toY,  el->score);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}


struct interaction *interactionCommaIn(char **pS, struct interaction *ret)
/* Create a interaction out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new interaction */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->fromX = sqlStringComma(&s);
ret->toY = sqlStringComma(&s);
ret->score = sqlFloatComma(&s);
*pS = s;
return ret;
}

void interactionFree(struct interaction **pEl)
/* Free a single dynamically allocated interaction such as created
 * with interactionLoad(). */
{
struct interaction *el;

if ((el = *pEl) == NULL) return;
freeMem(el->fromX);
freeMem(el->toY);
freez(pEl);
}

void interactionFreeList(struct interaction **pList)
/* Free a list of dynamically allocated interaction's */
{
struct interaction *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    interactionFree(&el);
    }
*pList = NULL;
}

void interactionOutput(struct interaction *el, FILE *f, char sep, char lastSep) 
/* Print out interaction.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fromX);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->toY);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->score);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

