/* rnaGene.h was originally generated by the autoSql program, which also 
 * generated rnaGene.c and rnaGene.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef RNAGENE_H
#define RNAGENE_H

struct rnaGene
/* Describes functional RNA genes. */
    {
    struct rnaGene *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome gene is on */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of gene */
    unsigned score;	/* Score from 0 to 1000 */
    char strand[2];	/* Strand: + or - */
    char *source;	/* Source as in Sean Eddy's files. */
    char *type;	/* Type - snRNA, rRNA, tRNA, etc. */
    float fullScore;	/* Score as in Sean Eddy's files. */
    unsigned char isPsuedo;	/* TRUE(1) if psuedo, FALSE(0) otherwise */
    };

void rnaGeneStaticLoad(char **row, struct rnaGene *ret);
/* Load a row from rnaGene table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct rnaGene *rnaGeneLoad(char **row);
/* Load a rnaGene from row fetched with select * from rnaGene
 * from database.  Dispose of this with rnaGeneFree(). */

struct rnaGene *rnaGeneCommaIn(char **pS, struct rnaGene *ret);
/* Create a rnaGene out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rnaGene */

void rnaGeneFree(struct rnaGene **pEl);
/* Free a single dynamically allocated rnaGene such as created
 * with rnaGeneLoad(). */

void rnaGeneFreeList(struct rnaGene **pList);
/* Free a list of dynamically allocated rnaGene's */

void rnaGeneOutput(struct rnaGene *el, FILE *f, char sep, char lastSep);
/* Print out rnaGene.  Separate fields with sep. Follow last field with lastSep. */

#define rnaGeneTabOut(el,f) rnaGeneOutput(el,f,'\t','\n');
/* Print out rnaGene as a line in a tab-separated file. */

#define rnaGeneCommaOut(el,f) rnaGeneOutput(el,f,',',',');
/* Print out rnaGene as a comma separated list including final comma. */

#endif /* RNAGENE_H */

