/* doc.h was originally generated by the autoSql program, which also 
 * generated doc.c and doc.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef DOC_H
#define DOC_H

#define ADDRESSBOOK_NUM_COLS 5

extern char *addressBookCommaSepFieldNames;

struct addressBook
/* A simple address book */
    {
    struct addressBook *next;  /* Next in singly linked list. */
    char *name;	/* Name - first or last or both, we don't care */
    char *address;	/* Street address */
    char *city;	/* City */
    unsigned zipCode;	/* A zip code is always positive, so can be unsigned */
    char state[3];	/* Just store the abbreviation for the state */
    };

void addressBookStaticLoad(char **row, struct addressBook *ret);
/* Load a row from addressBook table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct addressBook *addressBookLoad(char **row);
/* Load a addressBook from row fetched with select * from addressBook
 * from database.  Dispose of this with addressBookFree(). */

struct addressBook *addressBookLoadAll(char *fileName);
/* Load all addressBook from whitespace-separated file.
 * Dispose of this with addressBookFreeList(). */

struct addressBook *addressBookLoadAllByChar(char *fileName, char chopper);
/* Load all addressBook from chopper separated file.
 * Dispose of this with addressBookFreeList(). */

#define addressBookLoadAllByTab(a) addressBookLoadAllByChar(a, '\t');
/* Load all addressBook from tab separated file.
 * Dispose of this with addressBookFreeList(). */

struct addressBook *addressBookCommaIn(char **pS, struct addressBook *ret);
/* Create a addressBook out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new addressBook */

void addressBookFree(struct addressBook **pEl);
/* Free a single dynamically allocated addressBook such as created
 * with addressBookLoad(). */

void addressBookFreeList(struct addressBook **pList);
/* Free a list of dynamically allocated addressBook's */

void addressBookOutput(struct addressBook *el, FILE *f, char sep, char lastSep);
/* Print out addressBook.  Separate fields with sep. Follow last field with lastSep. */

#define addressBookTabOut(el,f) addressBookOutput(el,f,'\t','\n');
/* Print out addressBook as a line in a tab-separated file. */

#define addressBookCommaOut(el,f) addressBookOutput(el,f,',',',');
/* Print out addressBook as a comma separated list including final comma. */

void addressBookJsonOutput(struct addressBook *el, FILE *f);
/* Print out addressBook in JSON format. */

#define SYMBOLCOLS_NUM_COLS 3

extern char *symbolColsCommaSepFieldNames;

enum symbolColsSex
    {
    symbolColsMale = 0,
    symbolColsFemale = 1,
    };
enum symbolColsSkills
    {
    symbolColsCProg = 0x0001,
    symbolColsJavaProg = 0x0002,
    symbolColsPythonProg = 0x0004,
    symbolColsAwkProg = 0x0008,
    };
struct symbolCols
/* example of enum and set symbolic columns */
    {
    struct symbolCols *next;  /* Next in singly linked list. */
    int id;	/* unique id */
    enum symbolColsSex sex;	/* enumerated column */
    unsigned skills;	/* set column */
    };

void symbolColsStaticLoad(char **row, struct symbolCols *ret);
/* Load a row from symbolCols table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct symbolCols *symbolColsLoad(char **row);
/* Load a symbolCols from row fetched with select * from symbolCols
 * from database.  Dispose of this with symbolColsFree(). */

struct symbolCols *symbolColsLoadAll(char *fileName);
/* Load all symbolCols from whitespace-separated file.
 * Dispose of this with symbolColsFreeList(). */

struct symbolCols *symbolColsLoadAllByChar(char *fileName, char chopper);
/* Load all symbolCols from chopper separated file.
 * Dispose of this with symbolColsFreeList(). */

#define symbolColsLoadAllByTab(a) symbolColsLoadAllByChar(a, '\t');
/* Load all symbolCols from tab separated file.
 * Dispose of this with symbolColsFreeList(). */

struct symbolCols *symbolColsCommaIn(char **pS, struct symbolCols *ret);
/* Create a symbolCols out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new symbolCols */

void symbolColsFree(struct symbolCols **pEl);
/* Free a single dynamically allocated symbolCols such as created
 * with symbolColsLoad(). */

void symbolColsFreeList(struct symbolCols **pList);
/* Free a list of dynamically allocated symbolCols's */

void symbolColsOutput(struct symbolCols *el, FILE *f, char sep, char lastSep);
/* Print out symbolCols.  Separate fields with sep. Follow last field with lastSep. */

#define symbolColsTabOut(el,f) symbolColsOutput(el,f,'\t','\n');
/* Print out symbolCols as a line in a tab-separated file. */

#define symbolColsCommaOut(el,f) symbolColsOutput(el,f,',',',');
/* Print out symbolCols as a comma separated list including final comma. */

void symbolColsJsonOutput(struct symbolCols *el, FILE *f);
/* Print out symbolCols in JSON format. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* DOC_H */

