/* decoration.h was originally generated by the autoSql program, which also 
 * generated decoration.c and decoration.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef DECORATION_H
#define DECORATION_H

#define DECORATION_NUM_COLS 16

extern char *decorationCommaSepFieldNames;

struct decoration
/* Browser extensible data (12 fields) plus information about what item this decorates and how. */
    {
    struct decoration *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome (or contig, scaffold, etc.) */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item */
    unsigned score;	/* Score from 0-1000 */
    char strand[2];	/* + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned color;	/* Primary RGB color for the decoration */
    int blockCount;	/* Number of blocks */
    int *blockSizes;	/* Comma separated list of block sizes */
    int *chromStarts;	/* Start positions relative to chromStart */
    char *decoratedItem;	/* Identity of the decorated item in chr:start-end:item_name format */
    char *style;	/* Draw style for the decoration (e.g. block, glyph) */
    char *fillColor;	/* Secondary color to use for filling decoration, blocks, supports RGBA */
    char *glyph;	/* The glyph to draw in glyph mode; ignored for other styles */
    char *mouseOver;    /* Extra field for storing synthesized mouseOver data, not part of the .as */
    };

struct decoration *decorationLoad(char **row);
/* Load a decoration from row fetched with select * from decoration
 * from database.  Dispose of this with decorationFree(). */

struct decoration *decorationLoadAll(char *fileName);
/* Load all decoration from whitespace-separated file.
 * Dispose of this with decorationFreeList(). */

struct decoration *decorationLoadAllByChar(char *fileName, char chopper);
/* Load all decoration from chopper separated file.
 * Dispose of this with decorationFreeList(). */

#define decorationLoadAllByTab(a) decorationLoadAllByChar(a, '\t');
/* Load all decoration from tab separated file.
 * Dispose of this with decorationFreeList(). */

struct decoration *decorationCommaIn(char **pS, struct decoration *ret);
/* Create a decoration out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new decoration */

void decorationFree(struct decoration **pEl);
/* Free a single dynamically allocated decoration such as created
 * with decorationLoad(). */

void decorationFreeList(struct decoration **pList);
/* Free a list of dynamically allocated decoration's */

void decorationOutput(struct decoration *el, FILE *f, char sep, char lastSep);
/* Print out decoration.  Separate fields with sep. Follow last field with lastSep. */

#define decorationTabOut(el,f) decorationOutput(el,f,'\t','\n');
/* Print out decoration as a line in a tab-separated file. */

#define decorationCommaOut(el,f) decorationOutput(el,f,',',',');
/* Print out decoration as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#include "bigBed.h"
#include "asParse.h"

struct asObject *decorationAsObj();
/* Return asObject describing fields of a decoration object */

struct decoration *decorationFromInterval (char *chrom, struct bigBedInterval *interval);
/* Convert a bigBedInterval read from a bigBed file into a decoration structure.
 * errAbort if the bigBedInterval doesn't have enough rows to support this.
 */

typedef enum {DECORATION_STYLE_UNKNOWN, DECORATION_STYLE_BLOCK, DECORATION_STYLE_GLYPH} decorationStyle;

decorationStyle decorationGetStyle(struct decoration *decoration);
/* Return the enum value that corresponds to the string in the decoration's style field */

int decorationGetParentExtent(struct decoration *decoration, char **chrom, int *start, int *end);
/* Parse out the chrom:start-end from the "decoratedItem" field of a decoration and return
 * those in the corresponding pointers if they're non-NULL.  The chromosome string must be
 * freeMem()ed after use.
 */

#endif /* DECORATION_H */

