/* protFeat.h was originally generated by the autoSql program, which also 
 * generated protFeat.c and protFeat.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef PROTFEAT_H
#define PROTFEAT_H

#define PROTFEAT_NUM_COLS 5

struct protFeat
/* A protein feature, like a domain or something. */
    {
    struct protFeat *next;  /* Next in singly linked list. */
    char *protein;	/* Name of protein */
    int start;	/* Start of feature (zero based) */
    int end;	/* End of feature (non-inclusive) */
    char *feature;	/* Feature name */
    double score;	/* Some sort of score, often an eVal */
    };

void protFeatStaticLoad(char **row, struct protFeat *ret);
/* Load a row from protFeat table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct protFeat *protFeatLoad(char **row);
/* Load a protFeat from row fetched with select * from protFeat
 * from database.  Dispose of this with protFeatFree(). */

struct protFeat *protFeatLoadAll(char *fileName);
/* Load all protFeat from whitespace-separated file.
 * Dispose of this with protFeatFreeList(). */

struct protFeat *protFeatLoadAllByChar(char *fileName, char chopper);
/* Load all protFeat from chopper separated file.
 * Dispose of this with protFeatFreeList(). */

#define protFeatLoadAllByTab(a) protFeatLoadAllByChar(a, '\t');
/* Load all protFeat from tab separated file.
 * Dispose of this with protFeatFreeList(). */

struct protFeat *protFeatCommaIn(char **pS, struct protFeat *ret);
/* Create a protFeat out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new protFeat */

void protFeatFree(struct protFeat **pEl);
/* Free a single dynamically allocated protFeat such as created
 * with protFeatLoad(). */

void protFeatFreeList(struct protFeat **pList);
/* Free a list of dynamically allocated protFeat's */

void protFeatOutput(struct protFeat *el, FILE *f, char sep, char lastSep);
/* Print out protFeat.  Separate fields with sep. Follow last field with lastSep. */

#define protFeatTabOut(el,f) protFeatOutput(el,f,'\t','\n');
/* Print out protFeat as a line in a tab-separated file. */

#define protFeatCommaOut(el,f) protFeatOutput(el,f,',',',');
/* Print out protFeat as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* PROTFEAT_H */

