# altGraph.sql was originally generated by the autoSql program, which also 
# generated altGraph.c and altGraph.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#An alternatively spliced gene graph.
CREATE TABLE altGraph (
    id int unsigned not null auto_increment,	# Unique ID
    tName varchar(255) not null,	# name of target sequence, often a chrom.
    tStart int not null,	# First bac touched by graph
    tEnd int not null,	# Start position in first bac
    strand char(2) not null,	# + or - strand
    vertexCount int unsigned not null,	# Number of vertices in graph
    vTypes longblob not null,	# Type for each vertex
    vPositions longblob not null,	# Position in target for each vertex
    edgeCount int unsigned not null,	# Number of edges in graph
    edgeStarts longblob not null,	# Array with start vertex of edges
    edgeEnds longblob not null,	# Array with end vertex of edges.
    mrnaRefCount int not null,	# Number of supporting mRNAs.
    mrnaRefs longblob not null,	# Ids of mrnas supporting this.
              #Indices
    PRIMARY KEY(id),
    index(tName(16), tStart, tEnd)
);
