/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLQueryParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLQueryParser.class);
    private final String query;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private boolean parsed = false;

    public URLQueryParser(String query) {
        this.query = query;
    }

    public void parse() {
        if (!this.parsed) {
            String[] pairs;
            if (this.query == null) {
                this.parsed = true;
                return;
            }
            String queryString = this.query;
            int indexOf = this.query.indexOf("?");
            if (indexOf != -1) {
                queryString = this.query.substring(indexOf + 1);
            }
            for (String pair : pairs = queryString.split("&")) {
                String[] keyValue = pair.split("=", 2);
                String key = "";
                String value = "";
                try {
                    key = URLDecoder.decode(keyValue[0], "UTF-8");
                    value = keyValue.length == 2 ? URLDecoder.decode(keyValue[1], "UTF-8") : "";
                    this.parameters.put(key, value);
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.warn("Could not decode: [ " + key + ", " + value + " ]", e);
                }
            }
            this.parsed = true;
        }
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }
}

