/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.requesthandlers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestScope
implements Scope {
    private final ThreadLocal<Map<Key<?>, Object>> values = new ThreadLocal();

    RequestScope() {
    }

    public void enter() {
        Preconditions.checkState(this.values.get() == null, "Scope already entered.");
        this.values.set(Maps.newHashMap());
    }

    public void exit() {
        Preconditions.checkState(this.values.get() != null, "Scope not entered.");
        this.values.remove();
    }

    public <T> void seed(Key<T> key, T value) {
        Map<Key<?>, Object> scopedObjects = this.getScopedObjectMap(key);
        Preconditions.checkState(!scopedObjects.containsKey(key), "Error");
        scopedObjects.put(key, value);
    }

    public <T> void seed(Class<T> clazz, T value) {
        this.seed(Key.get(clazz), value);
    }

    @Override
    public <T> Provider<T> scope(final Key<T> tKey, final Provider<T> tProvider) {
        return new Provider<T>(){

            @Override
            public T get() {
                Map scopedObjects = RequestScope.this.getScopedObjectMap(tKey);
                Object current = scopedObjects.get(tKey);
                if (current == null && !scopedObjects.containsKey(tKey)) {
                    current = tProvider.get();
                    scopedObjects.put(tKey, current);
                }
                return current;
            }
        };
    }

    private <T> Map<Key<?>, Object> getScopedObjectMap(Key<T> key) {
        Map<Key<?>, Object> scopedObjects = this.values.get();
        if (scopedObjects == null) {
            throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block.");
        }
        return scopedObjects;
    }
}

