/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.servlet.RequestParameters;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HeartbeatGetHandler
implements RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatGetHandler.class);
    private final CapturedBrowsers capturedBrowsers;
    private final Map<String, String[]> parameters;
    private final Gson gson;
    private final HttpServletResponse response;

    @Inject
    public HeartbeatGetHandler(CapturedBrowsers capturedBrowsers, @RequestParameters Map<String, String[]> parameters, Gson gson, HttpServletResponse response) {
        this.capturedBrowsers = capturedBrowsers;
        this.parameters = parameters;
        this.gson = gson;
        this.response = response;
    }

    @Override
    public void handleIt() throws IOException {
        this.response.setContentType("text/plain; charset=utf-8");
        String[] ids = this.parameters.get("id");
        PrintWriter writer = this.response.getWriter();
        if (ids != null && ids[0] != null) {
            String id = ids[0];
            SlaveBrowser browser = this.capturedBrowsers.getBrowser(id);
            if (browser != null) {
                LOGGER.debug("requesting " + browser);
                if (!browser.isAlive()) {
                    this.capturedBrowsers.removeSlave(id);
                    writer.write("DEAD:" + this.gson.toJson(browser.getBrowserInfo()));
                } else {
                    writer.write("OK");
                }
            } else {
                LOGGER.debug("heartbeat " + id + "with no browser.");
                writer.write("DEAD: can't find browser.");
            }
        } else {
            LOGGER.debug("no heartbeat, no browser.");
            writer.write("DEAD");
        }
        writer.flush();
    }
}

