/* borf.h was originally generated by the autoSql program, which also 
 * generated borf.c and borf.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2008 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef BORF_H
#define BORF_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#ifndef BED_H
#include "bed.h"
#endif

#define BORF_NUM_COLS  12  /* number of columns in a borf */

struct borf
/* Parsed output from Victor Solovyev's bestorf program */
    {
    struct borf *next;  /* Next in singly linked list. */
    char *name;	/* Name of mRNA */
    int size;	/* Size of mRNA */
    char strand[2];	/* + or - */
    char *feature;	/* Feature name - Always seems to be CDSo */
    int cdsStart;	/* Start of cds (starting with 0) */
    int cdsEnd;	/* End of cds (non-exclusive) */
    float score;	/* A score of 50 or more is decent */
    int orfStart;	/* Start of orf (not always same as CDS) */
    int orfEnd;	/* Start of orf (not always same as CDS) */
    int cdsSize;	/* Size of cds in bases */
    char frame[4];	/* Seems to be +1, +2, +3 or -1, -2, -3 */
    char *protein;	/* Predicted protein */
    };

void borfStaticLoad(char **row, struct borf *ret);
/* Load a row from borf table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct borf *borfLoad(char **row);
/* Load a borf from row fetched with select * from borf
 * from database.  Dispose of this with borfFree(). */

struct borf *borfLoadAll(char *fileName);
/* Load all borf from a tab-separated file.
 * Dispose of this with borfFreeList(). */

struct borf *borfLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all borf from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with borfFreeList(). */

struct borf *borfCommaIn(char **pS, struct borf *ret);
/* Create a borf out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new borf */

void borfFree(struct borf **pEl);
/* Free a single dynamically allocated borf such as created
 * with borfLoad(). */

void borfFreeList(struct borf **pList);
/* Free a list of dynamically allocated borf's */

void borfOutput(struct borf *el, FILE *f, char sep, char lastSep);
/* Print out borf.  Separate fields with sep. Follow last field with lastSep. */

#define borfTabOut(el,f) borfOutput(el,f,'\t','\n');
/* Print out borf as a line in a tab-separated file. */

#define borfCommaOut(el,f) borfOutput(el,f,',',',');
/* Print out borf as a comma separated list including final comma. */

/*------------ End AutoSql generated code. -------------------*/

struct borf *borfFromBestorfOutput(char *fileName);
/* Convert bestorf output to borf structure. */

struct borf *borfFromGenomeBed(char *db, struct bed *bed);
/* borfBig - Run Victor Solovyev's bestOrf on a genome bed's coordinates. */

void borfSetExeAndParam(char *exePath, char *paramPath);
/* Set the path to the bestOrf probram and parameter file to be used
   for running borfFromGenomeBed. */

#endif /* BORF_H */

