/* wgEncodeCell.c was originally generated by the autoSql program, which also 
 * generated wgEncodeCell.h and wgEncodeCell.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "encode/wgEncodeCell.h"



char *wgEncodeCellCommaSepFieldNames = "id,term,description,tissue,type,cancer,developmental,sex,vendor,vendorId,url,ontoTerm,btOntoTerm,donor";

void wgEncodeCellStaticLoad(char **row, struct wgEncodeCell *ret)
/* Load a row from wgEncodeCell table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->term = row[1];
ret->description = row[2];
ret->tissue = row[3];
ret->type = row[4];
ret->cancer = row[5];
ret->developmental = row[6];
ret->sex = row[7];
ret->vendor = row[8];
ret->vendorId = row[9];
ret->url = row[10];
ret->ontoTerm = row[11];
ret->btOntoTerm = row[12];
ret->donor = row[13];
}

struct wgEncodeCell *wgEncodeCellLoad(char **row)
/* Load a wgEncodeCell from row fetched with select * from wgEncodeCell
 * from database.  Dispose of this with wgEncodeCellFree(). */
{
struct wgEncodeCell *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->term = cloneString(row[1]);
ret->description = cloneString(row[2]);
ret->tissue = cloneString(row[3]);
ret->type = cloneString(row[4]);
ret->cancer = cloneString(row[5]);
ret->developmental = cloneString(row[6]);
ret->sex = cloneString(row[7]);
ret->vendor = cloneString(row[8]);
ret->vendorId = cloneString(row[9]);
ret->url = cloneString(row[10]);
ret->ontoTerm = cloneString(row[11]);
ret->btOntoTerm = cloneString(row[12]);
ret->donor = cloneString(row[13]);
return ret;
}

struct wgEncodeCell *wgEncodeCellLoadAll(char *fileName) 
/* Load all wgEncodeCell from a whitespace-separated file.
 * Dispose of this with wgEncodeCellFreeList(). */
{
struct wgEncodeCell *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = wgEncodeCellLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct wgEncodeCell *wgEncodeCellLoadAllByChar(char *fileName, char chopper) 
/* Load all wgEncodeCell from a chopper separated file.
 * Dispose of this with wgEncodeCellFreeList(). */
{
struct wgEncodeCell *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = wgEncodeCellLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct wgEncodeCell *wgEncodeCellCommaIn(char **pS, struct wgEncodeCell *ret)
/* Create a wgEncodeCell out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new wgEncodeCell */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->term = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->tissue = sqlStringComma(&s);
ret->type = sqlStringComma(&s);
ret->cancer = sqlStringComma(&s);
ret->developmental = sqlStringComma(&s);
ret->sex = sqlStringComma(&s);
ret->vendor = sqlStringComma(&s);
ret->vendorId = sqlStringComma(&s);
ret->url = sqlStringComma(&s);
ret->ontoTerm = sqlStringComma(&s);
ret->btOntoTerm = sqlStringComma(&s);
ret->donor = sqlStringComma(&s);
*pS = s;
return ret;
}

void wgEncodeCellFree(struct wgEncodeCell **pEl)
/* Free a single dynamically allocated wgEncodeCell such as created
 * with wgEncodeCellLoad(). */
{
struct wgEncodeCell *el;

if ((el = *pEl) == NULL) return;
freeMem(el->term);
freeMem(el->description);
freeMem(el->tissue);
freeMem(el->type);
freeMem(el->cancer);
freeMem(el->developmental);
freeMem(el->sex);
freeMem(el->vendor);
freeMem(el->vendorId);
freeMem(el->url);
freeMem(el->ontoTerm);
freeMem(el->btOntoTerm);
freeMem(el->donor);
freez(pEl);
}

void wgEncodeCellFreeList(struct wgEncodeCell **pList)
/* Free a list of dynamically allocated wgEncodeCell's */
{
struct wgEncodeCell *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    wgEncodeCellFree(&el);
    }
*pList = NULL;
}

void wgEncodeCellOutput(struct wgEncodeCell *el, FILE *f, char sep, char lastSep) 
/* Print out wgEncodeCell.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->term);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tissue);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cancer);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->developmental);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sex);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->vendor);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->vendorId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->url);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ontoTerm);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->btOntoTerm);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->donor);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

