/* barChartData.c was originally generated by the autoSql program, which also 
 * generated barChartData.h and barChartData.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "barChartData.h"



char *barChartDataCommaSepFieldNames = "locus,sample,value";

void barChartDataStaticLoad(char **row, struct barChartData *ret)
/* Load a row from barChartData table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->locus = row[0];
ret->sample = row[1];
ret->value = sqlDouble(row[2]);
}

struct barChartData *barChartDataLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all barChartData from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with barChartDataFreeList(). */
{
struct barChartData *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = barChartDataLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void barChartDataSaveToDb(struct sqlConnection *conn, struct barChartData *el, char *tableName, int updateSize)
/* Save barChartData as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s','%s',%g)", 
	tableName,  el->locus,  el->sample,  el->value);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct barChartData *barChartDataLoad(char **row)
/* Load a barChartData from row fetched with select * from barChartData
 * from database.  Dispose of this with barChartDataFree(). */
{
struct barChartData *ret;

AllocVar(ret);
ret->locus = cloneString(row[0]);
ret->sample = cloneString(row[1]);
ret->value = sqlDouble(row[2]);
return ret;
}

struct barChartData *barChartDataLoadAll(char *fileName) 
/* Load all barChartData from a whitespace-separated file.
 * Dispose of this with barChartDataFreeList(). */
{
struct barChartData *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = barChartDataLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct barChartData *barChartDataLoadAllByChar(char *fileName, char chopper) 
/* Load all barChartData from a chopper separated file.
 * Dispose of this with barChartDataFreeList(). */
{
struct barChartData *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = barChartDataLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct barChartData *barChartDataCommaIn(char **pS, struct barChartData *ret)
/* Create a barChartData out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new barChartData */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->locus = sqlStringComma(&s);
ret->sample = sqlStringComma(&s);
ret->value = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void barChartDataFree(struct barChartData **pEl)
/* Free a single dynamically allocated barChartData such as created
 * with barChartDataLoad(). */
{
struct barChartData *el;

if ((el = *pEl) == NULL) return;
freeMem(el->locus);
freeMem(el->sample);
freez(pEl);
}

void barChartDataFreeList(struct barChartData **pList)
/* Free a list of dynamically allocated barChartData's */
{
struct barChartData *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    barChartDataFree(&el);
    }
*pList = NULL;
}

void barChartDataOutput(struct barChartData *el, FILE *f, char sep, char lastSep) 
/* Print out barChartData.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->locus);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sample);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->value);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct barChartData *barChartDataLoadForLocus(struct sqlConnection *conn, char *table, char *locus)
/* Load all data for a locus */
{
char query[512];
sqlSafef(query, sizeof(query), "SELECT * FROM %s WHERE locus='%s'", table, locus);
return barChartDataLoadByQuery(conn, query);
}
