/* flyBase2004Xref.h was originally generated by the autoSql program, which also 
 * generated flyBase2004Xref.c and flyBase2004Xref.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2005 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef FLYBASE2004XREF_H
#define FLYBASE2004XREF_H

#define FLYBASE2004XREF_NUM_COLS 8

struct flyBase2004Xref
/* FlyBase cross references circa late 2004 (dm2/4.0; dp3/1.0 uses a subset) */
    {
    struct flyBase2004Xref *next;  /* Next in singly linked list. */
    char *name;	/* FlyBase annotation gene ID */
    char *symbol;	/* Symbolic gene name */
    char *synonyms;	/* Comma-separated list of synonyms */
    char *fbtr;	/* FlyBase FBtr acc */
    char *fbgn;	/* FlyBase FBgn acc */
    char *fbpp;	/* FlyBase FBpp acc */
    char *fban;	/* FlyBase FBan acc */
    char *type;	/* Annotation type (for noncoding only) */
    };

void flyBase2004XrefStaticLoad(char **row, struct flyBase2004Xref *ret);
/* Load a row from flyBase2004Xref table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct flyBase2004Xref *flyBase2004XrefLoad(char **row);
/* Load a flyBase2004Xref from row fetched with select * from flyBase2004Xref
 * from database.  Dispose of this with flyBase2004XrefFree(). */

struct flyBase2004Xref *flyBase2004XrefLoadAll(char *fileName);
/* Load all flyBase2004Xref from whitespace-separated file.
 * Dispose of this with flyBase2004XrefFreeList(). */

struct flyBase2004Xref *flyBase2004XrefLoadAllByChar(char *fileName, char chopper);
/* Load all flyBase2004Xref from chopper separated file.
 * Dispose of this with flyBase2004XrefFreeList(). */

#define flyBase2004XrefLoadAllByTab(a) flyBase2004XrefLoadAllByChar(a, '\t');
/* Load all flyBase2004Xref from tab separated file.
 * Dispose of this with flyBase2004XrefFreeList(). */

struct flyBase2004Xref *flyBase2004XrefCommaIn(char **pS, struct flyBase2004Xref *ret);
/* Create a flyBase2004Xref out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new flyBase2004Xref */

void flyBase2004XrefFree(struct flyBase2004Xref **pEl);
/* Free a single dynamically allocated flyBase2004Xref such as created
 * with flyBase2004XrefLoad(). */

void flyBase2004XrefFreeList(struct flyBase2004Xref **pList);
/* Free a list of dynamically allocated flyBase2004Xref's */

void flyBase2004XrefOutput(struct flyBase2004Xref *el, FILE *f, char sep, char lastSep);
/* Print out flyBase2004Xref.  Separate fields with sep. Follow last field with lastSep. */

#define flyBase2004XrefTabOut(el,f) flyBase2004XrefOutput(el,f,'\t','\n');
/* Print out flyBase2004Xref as a line in a tab-separated file. */

#define flyBase2004XrefCommaOut(el,f) flyBase2004XrefOutput(el,f,',',',');
/* Print out flyBase2004Xref as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* FLYBASE2004XREF_H */

