/* tableStatus.h was originally generated by the autoSql program, which also 
 * generated tableStatus.c and tableStatus.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2005 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef TABLESTATUS_H
#define TABLESTATUS_H

#define TABLESTATUS_NUM_COLS 15

struct tableStatus
/* This describe the fields of returned by mysql's show table status */
    {
    struct tableStatus *next;  /* Next in singly linked list. */
    char *name;	/* Name of table */
    char *type;	/* How table stored: MyISAM/INNOdb etc */
    char *rowFormat;	/* Seems to be mostly Fixed or Dynamic */
    unsigned rows;	/* The number of rows in table */
    unsigned aveRowLength;	/* Average length of row in bytes */
    long long dataLength;	/* Size of data in table */
    long long maxDataLength;	/* Maximum data length for this table type */
    long long indexLength;	/* Length of index in bytes */
    long long dataFree;	/* Usually zero */
    char *autoIncrement;	/* Current value of autoincrement - rows+1 or NULL */
    char *createTime;	/* YYYY-MM-DD HH:MM:SS format creation time */
    char *updateTime;	/* YYYY-MM-DD HH:MM:SS format last update time */
    char *checkTime;	/* YYYY-MM-DD HH:MM:SS format last check (not query) time */
    char *createOptions;	/* Seems to be mostly blank */
    char *comment;	/* Seems mostly to be blank */
    };

void tableStatusStaticLoad(char **row, struct tableStatus *ret);
/* Load a row from tableStatus table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct tableStatus *tableStatusLoad(char **row);
/* Load a tableStatus from row fetched with select * from tableStatus
 * from database.  Dispose of this with tableStatusFree(). */

struct tableStatus *tableStatusLoadAll(char *fileName);
/* Load all tableStatus from whitespace-separated file.
 * Dispose of this with tableStatusFreeList(). */

struct tableStatus *tableStatusLoadAllByChar(char *fileName, char chopper);
/* Load all tableStatus from chopper separated file.
 * Dispose of this with tableStatusFreeList(). */

#define tableStatusLoadAllByTab(a) tableStatusLoadAllByChar(a, '\t');
/* Load all tableStatus from tab separated file.
 * Dispose of this with tableStatusFreeList(). */

struct tableStatus *tableStatusCommaIn(char **pS, struct tableStatus *ret);
/* Create a tableStatus out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new tableStatus */

void tableStatusFree(struct tableStatus **pEl);
/* Free a single dynamically allocated tableStatus such as created
 * with tableStatusLoad(). */

void tableStatusFreeList(struct tableStatus **pList);
/* Free a list of dynamically allocated tableStatus's */

void tableStatusOutput(struct tableStatus *el, FILE *f, char sep, char lastSep);
/* Print out tableStatus.  Separate fields with sep. Follow last field with lastSep. */

#define tableStatusTabOut(el,f) tableStatusOutput(el,f,'\t','\n');
/* Print out tableStatus as a line in a tab-separated file. */

#define tableStatusCommaOut(el,f) tableStatusOutput(el,f,',',',');
/* Print out tableStatus as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* TABLESTATUS_H */

