/* cddInfo.c was originally generated by the autoSql program, which also 
 * generated cddInfo.h and cddInfo.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cddInfo.h"


void cddInfoStaticLoad(char **row, struct cddInfo *ret)
/* Load a row from cddInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->fullname = row[6];
ret->NCBInum = row[7];
ret->evalue = sqlDouble(row[8]);
ret->percentlength = sqlUnsigned(row[9]);
ret->percentident = sqlUnsigned(row[10]);
}

struct cddInfo *cddInfoLoad(char **row)
/* Load a cddInfo from row fetched with select * from cddInfo
 * from database.  Dispose of this with cddInfoFree(). */
{
struct cddInfo *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->fullname = cloneString(row[6]);
ret->NCBInum = cloneString(row[7]);
ret->evalue = sqlDouble(row[8]);
ret->percentlength = sqlUnsigned(row[9]);
ret->percentident = sqlUnsigned(row[10]);
return ret;
}

struct cddInfo *cddInfoLoadAll(char *fileName) 
/* Load all cddInfo from a whitespace-separated file.
 * Dispose of this with cddInfoFreeList(). */
{
struct cddInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileRow(lf, row))
    {
    el = cddInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cddInfo *cddInfoLoadAllByChar(char *fileName, char chopper) 
/* Load all cddInfo from a chopper separated file.
 * Dispose of this with cddInfoFreeList(). */
{
struct cddInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cddInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cddInfo *cddInfoCommaIn(char **pS, struct cddInfo *ret)
/* Create a cddInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cddInfo */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->fullname = sqlStringComma(&s);
ret->NCBInum = sqlStringComma(&s);
ret->evalue = sqlDoubleComma(&s);
ret->percentlength = sqlUnsignedComma(&s);
ret->percentident = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void cddInfoFree(struct cddInfo **pEl)
/* Free a single dynamically allocated cddInfo such as created
 * with cddInfoLoad(). */
{
struct cddInfo *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->fullname);
freeMem(el->NCBInum);
freez(pEl);
}

void cddInfoFreeList(struct cddInfo **pList)
/* Free a list of dynamically allocated cddInfo's */
{
struct cddInfo *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cddInfoFree(&el);
    }
*pList = NULL;
}

void cddInfoOutput(struct cddInfo *el, FILE *f, char sep, char lastSep) 
/* Print out cddInfo.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fullname);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->NCBInum);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->evalue);
fputc(sep,f);
fprintf(f, "%u", el->percentlength);
fputc(sep,f);
fprintf(f, "%u", el->percentident);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

