/* ld.c was originally generated by the autoSql program, which also 
 * generated ld.h and ld.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "ld.h"


void ldStaticLoad(char **row, struct ld *ret)
/* Load a row from ld table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
ret->dprime = row[5];
ret->rsquared = row[6];
ret->lod = row[7];
}

struct ld *ldLoad(char **row)
/* Load a ld from row fetched with select * from ld
 * from database.  Dispose of this with ldFree(). */
{
struct ld *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
ret->dprime = cloneString(row[5]);
ret->rsquared = cloneString(row[6]);
ret->lod = cloneString(row[7]);
return ret;
}

struct ld *ldLoadAll(char *fileName) 
/* Load all ld from a whitespace-separated file.
 * Dispose of this with ldFreeList(). */
{
struct ld *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = ldLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ld *ldLoadAllByChar(char *fileName, char chopper) 
/* Load all ld from a chopper separated file.
 * Dispose of this with ldFreeList(). */
{
struct ld *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = ldLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ld *ldLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all ld from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with ldFreeList(). */
{
struct ld *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = ldLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void ldSaveToDb(struct sqlConnection *conn, struct ld *el, char *tableName, int updateSize)
/* Save ld as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s',%u,%u,'%s',%u,'%s','%s','%s')", 
	tableName,  el->chrom,  el->chromStart,  el->chromEnd,  el->name,  el->score,  el->dprime,  el->rsquared,  el->lod);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}


struct ld *ldCommaIn(char **pS, struct ld *ret)
/* Create a ld out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ld */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
ret->dprime = sqlStringComma(&s);
ret->rsquared = sqlStringComma(&s);
ret->lod = sqlStringComma(&s);
*pS = s;
return ret;
}

void ldFree(struct ld **pEl)
/* Free a single dynamically allocated ld such as created
 * with ldLoad(). */
{
struct ld *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->dprime);
freeMem(el->rsquared);
freeMem(el->lod);
freez(pEl);
}

void ldFreeList(struct ld **pList)
/* Free a list of dynamically allocated ld's */
{
struct ld *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    ldFree(&el);
    }
*pList = NULL;
}

void ldOutput(struct ld *el, FILE *f, char sep, char lastSep) 
/* Print out ld.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dprime);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rsquared);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->lod);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

