/* vegaInfoZfish.c was originally generated by the autoSql program, which also 
 * generated vegaInfoZfish.h and vegaInfoZfish.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "vegaInfoZfish.h"


void vegaInfoZfishStaticLoad(char **row, struct vegaInfoZfish *ret)
/* Load a row from vegaInfoZfish table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->transcriptId = row[0];
ret->geneId = row[1];
ret->sangerName = row[2];
ret->zfinId = row[3];
ret->zfinSymbol = row[4];
ret->method = row[5];
ret->geneDesc = row[6];
ret->confidence = row[7];
}

struct vegaInfoZfish *vegaInfoZfishLoad(char **row)
/* Load a vegaInfoZfish from row fetched with select * from vegaInfoZfish
 * from database.  Dispose of this with vegaInfoZfishFree(). */
{
struct vegaInfoZfish *ret;

AllocVar(ret);
ret->transcriptId = cloneString(row[0]);
ret->geneId = cloneString(row[1]);
ret->sangerName = cloneString(row[2]);
ret->zfinId = cloneString(row[3]);
ret->zfinSymbol = cloneString(row[4]);
ret->method = cloneString(row[5]);
ret->geneDesc = cloneString(row[6]);
ret->confidence = cloneString(row[7]);
return ret;
}

struct vegaInfoZfish *vegaInfoZfishLoadAll(char *fileName) 
/* Load all vegaInfoZfish from a whitespace-separated file.
 * Dispose of this with vegaInfoZfishFreeList(). */
{
struct vegaInfoZfish *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = vegaInfoZfishLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct vegaInfoZfish *vegaInfoZfishLoadAllByChar(char *fileName, char chopper) 
/* Load all vegaInfoZfish from a chopper separated file.
 * Dispose of this with vegaInfoZfishFreeList(). */
{
struct vegaInfoZfish *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = vegaInfoZfishLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct vegaInfoZfish *vegaInfoZfishCommaIn(char **pS, struct vegaInfoZfish *ret)
/* Create a vegaInfoZfish out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new vegaInfoZfish */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->transcriptId = sqlStringComma(&s);
ret->geneId = sqlStringComma(&s);
ret->sangerName = sqlStringComma(&s);
ret->zfinId = sqlStringComma(&s);
ret->zfinSymbol = sqlStringComma(&s);
ret->method = sqlStringComma(&s);
ret->geneDesc = sqlStringComma(&s);
ret->confidence = sqlStringComma(&s);
*pS = s;
return ret;
}

void vegaInfoZfishFree(struct vegaInfoZfish **pEl)
/* Free a single dynamically allocated vegaInfoZfish such as created
 * with vegaInfoZfishLoad(). */
{
struct vegaInfoZfish *el;

if ((el = *pEl) == NULL) return;
freeMem(el->transcriptId);
freeMem(el->geneId);
freeMem(el->sangerName);
freeMem(el->zfinId);
freeMem(el->zfinSymbol);
freeMem(el->method);
freeMem(el->geneDesc);
freeMem(el->confidence);
freez(pEl);
}

void vegaInfoZfishFreeList(struct vegaInfoZfish **pList)
/* Free a list of dynamically allocated vegaInfoZfish's */
{
struct vegaInfoZfish *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    vegaInfoZfishFree(&el);
    }
*pList = NULL;
}

void vegaInfoZfishOutput(struct vegaInfoZfish *el, FILE *f, char sep, char lastSep) 
/* Print out vegaInfoZfish.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->transcriptId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sangerName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->zfinId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->zfinSymbol);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->method);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneDesc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->confidence);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

