/* eapDb.c was originally generated by the autoSql program, which also 
 * generated eapDb.h and eapDb.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "eapDb.h"



char *eapJobCommaSepFieldNames = "id,commandLine,startTime,endTime,stderr,returnCode,cpusRequested,parasolId";

void eapJobStaticLoad(char **row, struct eapJob *ret)
/* Load a row from eapJob table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->commandLine = row[1];
ret->startTime = sqlLongLong(row[2]);
ret->endTime = sqlLongLong(row[3]);
ret->stderr = row[4];
ret->returnCode = sqlSigned(row[5]);
ret->cpusRequested = sqlSigned(row[6]);
ret->parasolId = row[7];
}

struct eapJob *eapJobLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all eapJob from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with eapJobFreeList(). */
{
struct eapJob *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = eapJobLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void eapJobSaveToDb(struct sqlConnection *conn, struct eapJob *el, char *tableName, int updateSize)
/* Save eapJob as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%lld,%lld,'%s',%d,%d,'%s')", 
	tableName,  el->id,  el->commandLine,  el->startTime,  el->endTime,  el->stderr,  el->returnCode,  el->cpusRequested,  el->parasolId);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct eapJob *eapJobLoad(char **row)
/* Load a eapJob from row fetched with select * from eapJob
 * from database.  Dispose of this with eapJobFree(). */
{
struct eapJob *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->commandLine = cloneString(row[1]);
ret->startTime = sqlLongLong(row[2]);
ret->endTime = sqlLongLong(row[3]);
ret->stderr = cloneString(row[4]);
ret->returnCode = sqlSigned(row[5]);
ret->cpusRequested = sqlSigned(row[6]);
ret->parasolId = cloneString(row[7]);
return ret;
}

struct eapJob *eapJobLoadAll(char *fileName) 
/* Load all eapJob from a whitespace-separated file.
 * Dispose of this with eapJobFreeList(). */
{
struct eapJob *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = eapJobLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapJob *eapJobLoadAllByChar(char *fileName, char chopper) 
/* Load all eapJob from a chopper separated file.
 * Dispose of this with eapJobFreeList(). */
{
struct eapJob *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = eapJobLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapJob *eapJobCommaIn(char **pS, struct eapJob *ret)
/* Create a eapJob out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new eapJob */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->commandLine = sqlStringComma(&s);
ret->startTime = sqlLongLongComma(&s);
ret->endTime = sqlLongLongComma(&s);
ret->stderr = sqlStringComma(&s);
ret->returnCode = sqlSignedComma(&s);
ret->cpusRequested = sqlSignedComma(&s);
ret->parasolId = sqlStringComma(&s);
*pS = s;
return ret;
}

void eapJobFree(struct eapJob **pEl)
/* Free a single dynamically allocated eapJob such as created
 * with eapJobLoad(). */
{
struct eapJob *el;

if ((el = *pEl) == NULL) return;
freeMem(el->commandLine);
freeMem(el->stderr);
freeMem(el->parasolId);
freez(pEl);
}

void eapJobFreeList(struct eapJob **pList)
/* Free a list of dynamically allocated eapJob's */
{
struct eapJob *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    eapJobFree(&el);
    }
*pList = NULL;
}

void eapJobOutput(struct eapJob *el, FILE *f, char sep, char lastSep) 
/* Print out eapJob.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->commandLine);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->startTime);
fputc(sep,f);
fprintf(f, "%lld", el->endTime);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->stderr);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->returnCode);
fputc(sep,f);
fprintf(f, "%d", el->cpusRequested);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->parasolId);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *eapSoftwareCommaSepFieldNames = "id,name,url,email,metaUuid";

void eapSoftwareStaticLoad(char **row, struct eapSoftware *ret)
/* Load a row from eapSoftware table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->url = row[2];
ret->email = row[3];
safecpy(ret->metaUuid, sizeof(ret->metaUuid), row[4]);
}

struct eapSoftware *eapSoftwareLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all eapSoftware from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with eapSoftwareFreeList(). */
{
struct eapSoftware *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = eapSoftwareLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void eapSoftwareSaveToDb(struct sqlConnection *conn, struct eapSoftware *el, char *tableName, int updateSize)
/* Save eapSoftware as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s','%s','%s')", 
	tableName,  el->id,  el->name,  el->url,  el->email,  el->metaUuid);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct eapSoftware *eapSoftwareLoad(char **row)
/* Load a eapSoftware from row fetched with select * from eapSoftware
 * from database.  Dispose of this with eapSoftwareFree(). */
{
struct eapSoftware *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->url = cloneString(row[2]);
ret->email = cloneString(row[3]);
safecpy(ret->metaUuid, sizeof(ret->metaUuid), row[4]);
return ret;
}

struct eapSoftware *eapSoftwareLoadAll(char *fileName) 
/* Load all eapSoftware from a whitespace-separated file.
 * Dispose of this with eapSoftwareFreeList(). */
{
struct eapSoftware *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = eapSoftwareLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapSoftware *eapSoftwareLoadAllByChar(char *fileName, char chopper) 
/* Load all eapSoftware from a chopper separated file.
 * Dispose of this with eapSoftwareFreeList(). */
{
struct eapSoftware *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = eapSoftwareLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapSoftware *eapSoftwareCommaIn(char **pS, struct eapSoftware *ret)
/* Create a eapSoftware out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new eapSoftware */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->url = sqlStringComma(&s);
ret->email = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->metaUuid, sizeof(ret->metaUuid));
*pS = s;
return ret;
}

void eapSoftwareFree(struct eapSoftware **pEl)
/* Free a single dynamically allocated eapSoftware such as created
 * with eapSoftwareLoad(). */
{
struct eapSoftware *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->url);
freeMem(el->email);
freez(pEl);
}

void eapSoftwareFreeList(struct eapSoftware **pList)
/* Free a list of dynamically allocated eapSoftware's */
{
struct eapSoftware *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    eapSoftwareFree(&el);
    }
*pList = NULL;
}

void eapSoftwareOutput(struct eapSoftware *el, FILE *f, char sep, char lastSep) 
/* Print out eapSoftware.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->url);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->email);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->metaUuid);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *eapSwVersionCommaSepFieldNames = "id,software,version,md5,redoPriority,notes,metaUuid";

void eapSwVersionStaticLoad(char **row, struct eapSwVersion *ret)
/* Load a row from eapSwVersion table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->software = row[1];
ret->version = row[2];
safecpy(ret->md5, sizeof(ret->md5), row[3]);
ret->redoPriority = sqlSigned(row[4]);
ret->notes = row[5];
safecpy(ret->metaUuid, sizeof(ret->metaUuid), row[6]);
}

struct eapSwVersion *eapSwVersionLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all eapSwVersion from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with eapSwVersionFreeList(). */
{
struct eapSwVersion *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = eapSwVersionLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void eapSwVersionSaveToDb(struct sqlConnection *conn, struct eapSwVersion *el, char *tableName, int updateSize)
/* Save eapSwVersion as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s','%s',%d,'%s','%s')", 
	tableName,  el->id,  el->software,  el->version,  el->md5,  el->redoPriority,  el->notes,  el->metaUuid);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct eapSwVersion *eapSwVersionLoad(char **row)
/* Load a eapSwVersion from row fetched with select * from eapSwVersion
 * from database.  Dispose of this with eapSwVersionFree(). */
{
struct eapSwVersion *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->software = cloneString(row[1]);
ret->version = cloneString(row[2]);
safecpy(ret->md5, sizeof(ret->md5), row[3]);
ret->redoPriority = sqlSigned(row[4]);
ret->notes = cloneString(row[5]);
safecpy(ret->metaUuid, sizeof(ret->metaUuid), row[6]);
return ret;
}

struct eapSwVersion *eapSwVersionLoadAll(char *fileName) 
/* Load all eapSwVersion from a whitespace-separated file.
 * Dispose of this with eapSwVersionFreeList(). */
{
struct eapSwVersion *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = eapSwVersionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapSwVersion *eapSwVersionLoadAllByChar(char *fileName, char chopper) 
/* Load all eapSwVersion from a chopper separated file.
 * Dispose of this with eapSwVersionFreeList(). */
{
struct eapSwVersion *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = eapSwVersionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapSwVersion *eapSwVersionCommaIn(char **pS, struct eapSwVersion *ret)
/* Create a eapSwVersion out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new eapSwVersion */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->software = sqlStringComma(&s);
ret->version = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->md5, sizeof(ret->md5));
ret->redoPriority = sqlSignedComma(&s);
ret->notes = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->metaUuid, sizeof(ret->metaUuid));
*pS = s;
return ret;
}

void eapSwVersionFree(struct eapSwVersion **pEl)
/* Free a single dynamically allocated eapSwVersion such as created
 * with eapSwVersionLoad(). */
{
struct eapSwVersion *el;

if ((el = *pEl) == NULL) return;
freeMem(el->software);
freeMem(el->version);
freeMem(el->notes);
freez(pEl);
}

void eapSwVersionFreeList(struct eapSwVersion **pList)
/* Free a list of dynamically allocated eapSwVersion's */
{
struct eapSwVersion *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    eapSwVersionFree(&el);
    }
*pList = NULL;
}

void eapSwVersionOutput(struct eapSwVersion *el, FILE *f, char sep, char lastSep) 
/* Print out eapSwVersion.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->software);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->version);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->md5);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->redoPriority);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->notes);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->metaUuid);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *eapStepCommaSepFieldNames = "id,name,cpusRequested,description,inCount,inputTypes,inputFormats,inputDescriptions,outCount,outputNamesInTempDir,outputFormats,outputTypes,outputDescriptions,metaUuid";

struct eapStep *eapStepLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all eapStep from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with eapStepFreeList(). */
{
struct eapStep *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = eapStepLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void eapStepSaveToDb(struct sqlConnection *conn, struct eapStep *el, char *tableName, int updateSize)
/* Save eapStep as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
char  *inputTypesArray, *inputFormatsArray, *inputDescriptionsArray, *outputNamesInTempDirArray, *outputFormatsArray, *outputTypesArray, *outputDescriptionsArray;
inputTypesArray = sqlStringArrayToString(el->inputTypes, el->inCount);
inputFormatsArray = sqlStringArrayToString(el->inputFormats, el->inCount);
inputDescriptionsArray = sqlStringArrayToString(el->inputDescriptions, el->inCount);
outputNamesInTempDirArray = sqlStringArrayToString(el->outputNamesInTempDir, el->outCount);
outputFormatsArray = sqlStringArrayToString(el->outputFormats, el->outCount);
outputTypesArray = sqlStringArrayToString(el->outputTypes, el->outCount);
outputDescriptionsArray = sqlStringArrayToString(el->outputDescriptions, el->outCount);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%d,'%s',%u,'%s','%s','%s',%u,'%s','%s','%s','%s','%s')", 
	tableName,  el->id,  el->name,  el->cpusRequested,  el->description,  el->inCount,  inputTypesArray ,  inputFormatsArray ,  inputDescriptionsArray ,  el->outCount,  outputNamesInTempDirArray ,  outputFormatsArray ,  outputTypesArray ,  outputDescriptionsArray ,  el->metaUuid);
sqlUpdate(conn, update->string);
dyStringFree(&update);
freez(&inputTypesArray);
freez(&inputFormatsArray);
freez(&inputDescriptionsArray);
freez(&outputNamesInTempDirArray);
freez(&outputFormatsArray);
freez(&outputTypesArray);
freez(&outputDescriptionsArray);
}

struct eapStep *eapStepLoad(char **row)
/* Load a eapStep from row fetched with select * from eapStep
 * from database.  Dispose of this with eapStepFree(). */
{
struct eapStep *ret;

AllocVar(ret);
ret->inCount = sqlUnsigned(row[4]);
ret->outCount = sqlUnsigned(row[8]);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->cpusRequested = sqlSigned(row[2]);
ret->description = cloneString(row[3]);
{
int sizeOne;
sqlStringDynamicArray(row[5], &ret->inputTypes, &sizeOne);
assert(sizeOne == ret->inCount);
}
{
int sizeOne;
sqlStringDynamicArray(row[6], &ret->inputFormats, &sizeOne);
assert(sizeOne == ret->inCount);
}
{
int sizeOne;
sqlStringDynamicArray(row[7], &ret->inputDescriptions, &sizeOne);
assert(sizeOne == ret->inCount);
}
{
int sizeOne;
sqlStringDynamicArray(row[9], &ret->outputNamesInTempDir, &sizeOne);
assert(sizeOne == ret->outCount);
}
{
int sizeOne;
sqlStringDynamicArray(row[10], &ret->outputFormats, &sizeOne);
assert(sizeOne == ret->outCount);
}
{
int sizeOne;
sqlStringDynamicArray(row[11], &ret->outputTypes, &sizeOne);
assert(sizeOne == ret->outCount);
}
{
int sizeOne;
sqlStringDynamicArray(row[12], &ret->outputDescriptions, &sizeOne);
assert(sizeOne == ret->outCount);
}
safecpy(ret->metaUuid, sizeof(ret->metaUuid), row[13]);
return ret;
}

struct eapStep *eapStepLoadAll(char *fileName) 
/* Load all eapStep from a whitespace-separated file.
 * Dispose of this with eapStepFreeList(). */
{
struct eapStep *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = eapStepLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapStep *eapStepLoadAllByChar(char *fileName, char chopper) 
/* Load all eapStep from a chopper separated file.
 * Dispose of this with eapStepFreeList(). */
{
struct eapStep *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = eapStepLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapStep *eapStepCommaIn(char **pS, struct eapStep *ret)
/* Create a eapStep out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new eapStep */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->cpusRequested = sqlSignedComma(&s);
ret->description = sqlStringComma(&s);
ret->inCount = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->inputTypes, ret->inCount);
for (i=0; i<ret->inCount; ++i)
    {
    ret->inputTypes[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->inputFormats, ret->inCount);
for (i=0; i<ret->inCount; ++i)
    {
    ret->inputFormats[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->inputDescriptions, ret->inCount);
for (i=0; i<ret->inCount; ++i)
    {
    ret->inputDescriptions[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->outCount = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->outputNamesInTempDir, ret->outCount);
for (i=0; i<ret->outCount; ++i)
    {
    ret->outputNamesInTempDir[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->outputFormats, ret->outCount);
for (i=0; i<ret->outCount; ++i)
    {
    ret->outputFormats[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->outputTypes, ret->outCount);
for (i=0; i<ret->outCount; ++i)
    {
    ret->outputTypes[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->outputDescriptions, ret->outCount);
for (i=0; i<ret->outCount; ++i)
    {
    ret->outputDescriptions[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
sqlFixedStringComma(&s, ret->metaUuid, sizeof(ret->metaUuid));
*pS = s;
return ret;
}

void eapStepFree(struct eapStep **pEl)
/* Free a single dynamically allocated eapStep such as created
 * with eapStepLoad(). */
{
struct eapStep *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->description);
/* All strings in inputTypes are allocated at once, so only need to free first. */
if (el->inputTypes != NULL)
    freeMem(el->inputTypes[0]);
freeMem(el->inputTypes);
/* All strings in inputFormats are allocated at once, so only need to free first. */
if (el->inputFormats != NULL)
    freeMem(el->inputFormats[0]);
freeMem(el->inputFormats);
/* All strings in inputDescriptions are allocated at once, so only need to free first. */
if (el->inputDescriptions != NULL)
    freeMem(el->inputDescriptions[0]);
freeMem(el->inputDescriptions);
/* All strings in outputNamesInTempDir are allocated at once, so only need to free first. */
if (el->outputNamesInTempDir != NULL)
    freeMem(el->outputNamesInTempDir[0]);
freeMem(el->outputNamesInTempDir);
/* All strings in outputFormats are allocated at once, so only need to free first. */
if (el->outputFormats != NULL)
    freeMem(el->outputFormats[0]);
freeMem(el->outputFormats);
/* All strings in outputTypes are allocated at once, so only need to free first. */
if (el->outputTypes != NULL)
    freeMem(el->outputTypes[0]);
freeMem(el->outputTypes);
/* All strings in outputDescriptions are allocated at once, so only need to free first. */
if (el->outputDescriptions != NULL)
    freeMem(el->outputDescriptions[0]);
freeMem(el->outputDescriptions);
freez(pEl);
}

void eapStepFreeList(struct eapStep **pList)
/* Free a list of dynamically allocated eapStep's */
{
struct eapStep *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    eapStepFree(&el);
    }
*pList = NULL;
}

void eapStepOutput(struct eapStep *el, FILE *f, char sep, char lastSep) 
/* Print out eapStep.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->cpusRequested);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->inCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->inCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->inputTypes[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->inCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->inputFormats[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->inCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->inputDescriptions[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
fprintf(f, "%u", el->outCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->outCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->outputNamesInTempDir[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->outCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->outputFormats[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->outCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->outputTypes[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->outCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->outputDescriptions[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->metaUuid);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *eapStepSoftwareCommaSepFieldNames = "id,step,software";

void eapStepSoftwareStaticLoad(char **row, struct eapStepSoftware *ret)
/* Load a row from eapStepSoftware table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->step = row[1];
ret->software = row[2];
}

struct eapStepSoftware *eapStepSoftwareLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all eapStepSoftware from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with eapStepSoftwareFreeList(). */
{
struct eapStepSoftware *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = eapStepSoftwareLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void eapStepSoftwareSaveToDb(struct sqlConnection *conn, struct eapStepSoftware *el, char *tableName, int updateSize)
/* Save eapStepSoftware as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s')", 
	tableName,  el->id,  el->step,  el->software);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct eapStepSoftware *eapStepSoftwareLoad(char **row)
/* Load a eapStepSoftware from row fetched with select * from eapStepSoftware
 * from database.  Dispose of this with eapStepSoftwareFree(). */
{
struct eapStepSoftware *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->step = cloneString(row[1]);
ret->software = cloneString(row[2]);
return ret;
}

struct eapStepSoftware *eapStepSoftwareLoadAll(char *fileName) 
/* Load all eapStepSoftware from a whitespace-separated file.
 * Dispose of this with eapStepSoftwareFreeList(). */
{
struct eapStepSoftware *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = eapStepSoftwareLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapStepSoftware *eapStepSoftwareLoadAllByChar(char *fileName, char chopper) 
/* Load all eapStepSoftware from a chopper separated file.
 * Dispose of this with eapStepSoftwareFreeList(). */
{
struct eapStepSoftware *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = eapStepSoftwareLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapStepSoftware *eapStepSoftwareCommaIn(char **pS, struct eapStepSoftware *ret)
/* Create a eapStepSoftware out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new eapStepSoftware */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->step = sqlStringComma(&s);
ret->software = sqlStringComma(&s);
*pS = s;
return ret;
}

void eapStepSoftwareFree(struct eapStepSoftware **pEl)
/* Free a single dynamically allocated eapStepSoftware such as created
 * with eapStepSoftwareLoad(). */
{
struct eapStepSoftware *el;

if ((el = *pEl) == NULL) return;
freeMem(el->step);
freeMem(el->software);
freez(pEl);
}

void eapStepSoftwareFreeList(struct eapStepSoftware **pList)
/* Free a list of dynamically allocated eapStepSoftware's */
{
struct eapStepSoftware *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    eapStepSoftwareFree(&el);
    }
*pList = NULL;
}

void eapStepSoftwareOutput(struct eapStepSoftware *el, FILE *f, char sep, char lastSep) 
/* Print out eapStepSoftware.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->step);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->software);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *eapStepVersionCommaSepFieldNames = "id,step,version";

void eapStepVersionStaticLoad(char **row, struct eapStepVersion *ret)
/* Load a row from eapStepVersion table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->step = row[1];
ret->version = sqlUnsigned(row[2]);
}

struct eapStepVersion *eapStepVersionLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all eapStepVersion from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with eapStepVersionFreeList(). */
{
struct eapStepVersion *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = eapStepVersionLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void eapStepVersionSaveToDb(struct sqlConnection *conn, struct eapStepVersion *el, char *tableName, int updateSize)
/* Save eapStepVersion as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%u)", 
	tableName,  el->id,  el->step,  el->version);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct eapStepVersion *eapStepVersionLoad(char **row)
/* Load a eapStepVersion from row fetched with select * from eapStepVersion
 * from database.  Dispose of this with eapStepVersionFree(). */
{
struct eapStepVersion *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->step = cloneString(row[1]);
ret->version = sqlUnsigned(row[2]);
return ret;
}

struct eapStepVersion *eapStepVersionLoadAll(char *fileName) 
/* Load all eapStepVersion from a whitespace-separated file.
 * Dispose of this with eapStepVersionFreeList(). */
{
struct eapStepVersion *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = eapStepVersionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapStepVersion *eapStepVersionLoadAllByChar(char *fileName, char chopper) 
/* Load all eapStepVersion from a chopper separated file.
 * Dispose of this with eapStepVersionFreeList(). */
{
struct eapStepVersion *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = eapStepVersionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapStepVersion *eapStepVersionCommaIn(char **pS, struct eapStepVersion *ret)
/* Create a eapStepVersion out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new eapStepVersion */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->step = sqlStringComma(&s);
ret->version = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void eapStepVersionFree(struct eapStepVersion **pEl)
/* Free a single dynamically allocated eapStepVersion such as created
 * with eapStepVersionLoad(). */
{
struct eapStepVersion *el;

if ((el = *pEl) == NULL) return;
freeMem(el->step);
freez(pEl);
}

void eapStepVersionFreeList(struct eapStepVersion **pList)
/* Free a list of dynamically allocated eapStepVersion's */
{
struct eapStepVersion *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    eapStepVersionFree(&el);
    }
*pList = NULL;
}

void eapStepVersionOutput(struct eapStepVersion *el, FILE *f, char sep, char lastSep) 
/* Print out eapStepVersion.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->step);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->version);
fputc(lastSep,f);
}


char *eapStepSwVersionCommaSepFieldNames = "id,stepVersionId,swVersionId";

void eapStepSwVersionStaticLoad(char **row, struct eapStepSwVersion *ret)
/* Load a row from eapStepSwVersion table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->stepVersionId = sqlUnsigned(row[1]);
ret->swVersionId = sqlUnsigned(row[2]);
}

struct eapStepSwVersion *eapStepSwVersionLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all eapStepSwVersion from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with eapStepSwVersionFreeList(). */
{
struct eapStepSwVersion *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = eapStepSwVersionLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void eapStepSwVersionSaveToDb(struct sqlConnection *conn, struct eapStepSwVersion *el, char *tableName, int updateSize)
/* Save eapStepSwVersion as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u)", 
	tableName,  el->id,  el->stepVersionId,  el->swVersionId);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct eapStepSwVersion *eapStepSwVersionLoad(char **row)
/* Load a eapStepSwVersion from row fetched with select * from eapStepSwVersion
 * from database.  Dispose of this with eapStepSwVersionFree(). */
{
struct eapStepSwVersion *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->stepVersionId = sqlUnsigned(row[1]);
ret->swVersionId = sqlUnsigned(row[2]);
return ret;
}

struct eapStepSwVersion *eapStepSwVersionLoadAll(char *fileName) 
/* Load all eapStepSwVersion from a whitespace-separated file.
 * Dispose of this with eapStepSwVersionFreeList(). */
{
struct eapStepSwVersion *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = eapStepSwVersionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapStepSwVersion *eapStepSwVersionLoadAllByChar(char *fileName, char chopper) 
/* Load all eapStepSwVersion from a chopper separated file.
 * Dispose of this with eapStepSwVersionFreeList(). */
{
struct eapStepSwVersion *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = eapStepSwVersionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapStepSwVersion *eapStepSwVersionCommaIn(char **pS, struct eapStepSwVersion *ret)
/* Create a eapStepSwVersion out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new eapStepSwVersion */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->stepVersionId = sqlUnsignedComma(&s);
ret->swVersionId = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void eapStepSwVersionFree(struct eapStepSwVersion **pEl)
/* Free a single dynamically allocated eapStepSwVersion such as created
 * with eapStepSwVersionLoad(). */
{
struct eapStepSwVersion *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void eapStepSwVersionFreeList(struct eapStepSwVersion **pList)
/* Free a list of dynamically allocated eapStepSwVersion's */
{
struct eapStepSwVersion *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    eapStepSwVersionFree(&el);
    }
*pList = NULL;
}

void eapStepSwVersionOutput(struct eapStepSwVersion *el, FILE *f, char sep, char lastSep) 
/* Print out eapStepSwVersion.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->stepVersionId);
fputc(sep,f);
fprintf(f, "%u", el->swVersionId);
fputc(lastSep,f);
}


char *eapRunCommaSepFieldNames = "id,jobId,experiment,analysisStep,stepVersionId,tempDir,assemblyId,jsonResult,createStatus,metaUuid";

void eapRunStaticLoad(char **row, struct eapRun *ret)
/* Load a row from eapRun table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->jobId = sqlUnsigned(row[1]);
safecpy(ret->experiment, sizeof(ret->experiment), row[2]);
ret->analysisStep = row[3];
ret->stepVersionId = sqlUnsigned(row[4]);
ret->tempDir = row[5];
ret->assemblyId = sqlUnsigned(row[6]);
ret->jsonResult = row[7];
ret->createStatus = sqlSigned(row[8]);
safecpy(ret->metaUuid, sizeof(ret->metaUuid), row[9]);
}

struct eapRun *eapRunLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all eapRun from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with eapRunFreeList(). */
{
struct eapRun *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = eapRunLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void eapRunSaveToDb(struct sqlConnection *conn, struct eapRun *el, char *tableName, int updateSize)
/* Save eapRun as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s','%s',%u,'%s',%u,'%s',%d,'%s')", 
	tableName,  el->id,  el->jobId,  el->experiment,  el->analysisStep,  el->stepVersionId,  el->tempDir,  el->assemblyId,  el->jsonResult,  el->createStatus,  el->metaUuid);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct eapRun *eapRunLoad(char **row)
/* Load a eapRun from row fetched with select * from eapRun
 * from database.  Dispose of this with eapRunFree(). */
{
struct eapRun *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->jobId = sqlUnsigned(row[1]);
safecpy(ret->experiment, sizeof(ret->experiment), row[2]);
ret->analysisStep = cloneString(row[3]);
ret->stepVersionId = sqlUnsigned(row[4]);
ret->tempDir = cloneString(row[5]);
ret->assemblyId = sqlUnsigned(row[6]);
ret->jsonResult = cloneString(row[7]);
ret->createStatus = sqlSigned(row[8]);
safecpy(ret->metaUuid, sizeof(ret->metaUuid), row[9]);
return ret;
}

struct eapRun *eapRunLoadAll(char *fileName) 
/* Load all eapRun from a whitespace-separated file.
 * Dispose of this with eapRunFreeList(). */
{
struct eapRun *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = eapRunLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapRun *eapRunLoadAllByChar(char *fileName, char chopper) 
/* Load all eapRun from a chopper separated file.
 * Dispose of this with eapRunFreeList(). */
{
struct eapRun *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = eapRunLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapRun *eapRunCommaIn(char **pS, struct eapRun *ret)
/* Create a eapRun out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new eapRun */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->jobId = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->experiment, sizeof(ret->experiment));
ret->analysisStep = sqlStringComma(&s);
ret->stepVersionId = sqlUnsignedComma(&s);
ret->tempDir = sqlStringComma(&s);
ret->assemblyId = sqlUnsignedComma(&s);
ret->jsonResult = sqlStringComma(&s);
ret->createStatus = sqlSignedComma(&s);
sqlFixedStringComma(&s, ret->metaUuid, sizeof(ret->metaUuid));
*pS = s;
return ret;
}

void eapRunFree(struct eapRun **pEl)
/* Free a single dynamically allocated eapRun such as created
 * with eapRunLoad(). */
{
struct eapRun *el;

if ((el = *pEl) == NULL) return;
freeMem(el->analysisStep);
freeMem(el->tempDir);
freeMem(el->jsonResult);
freez(pEl);
}

void eapRunFreeList(struct eapRun **pList)
/* Free a list of dynamically allocated eapRun's */
{
struct eapRun *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    eapRunFree(&el);
    }
*pList = NULL;
}

void eapRunOutput(struct eapRun *el, FILE *f, char sep, char lastSep) 
/* Print out eapRun.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->jobId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->experiment);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->analysisStep);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->stepVersionId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tempDir);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->assemblyId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->jsonResult);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->createStatus);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->metaUuid);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *eapInputCommaSepFieldNames = "id,runId,name,ix,fileId,val";

void eapInputStaticLoad(char **row, struct eapInput *ret)
/* Load a row from eapInput table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->runId = sqlUnsigned(row[1]);
ret->name = row[2];
ret->ix = sqlUnsigned(row[3]);
ret->fileId = sqlUnsigned(row[4]);
ret->val = row[5];
}

struct eapInput *eapInputLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all eapInput from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with eapInputFreeList(). */
{
struct eapInput *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = eapInputLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void eapInputSaveToDb(struct sqlConnection *conn, struct eapInput *el, char *tableName, int updateSize)
/* Save eapInput as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s',%u,%u,'%s')", 
	tableName,  el->id,  el->runId,  el->name,  el->ix,  el->fileId,  el->val);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct eapInput *eapInputLoad(char **row)
/* Load a eapInput from row fetched with select * from eapInput
 * from database.  Dispose of this with eapInputFree(). */
{
struct eapInput *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->runId = sqlUnsigned(row[1]);
ret->name = cloneString(row[2]);
ret->ix = sqlUnsigned(row[3]);
ret->fileId = sqlUnsigned(row[4]);
ret->val = cloneString(row[5]);
return ret;
}

struct eapInput *eapInputLoadAll(char *fileName) 
/* Load all eapInput from a whitespace-separated file.
 * Dispose of this with eapInputFreeList(). */
{
struct eapInput *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = eapInputLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapInput *eapInputLoadAllByChar(char *fileName, char chopper) 
/* Load all eapInput from a chopper separated file.
 * Dispose of this with eapInputFreeList(). */
{
struct eapInput *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = eapInputLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapInput *eapInputCommaIn(char **pS, struct eapInput *ret)
/* Create a eapInput out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new eapInput */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->runId = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->ix = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->val = sqlStringComma(&s);
*pS = s;
return ret;
}

void eapInputFree(struct eapInput **pEl)
/* Free a single dynamically allocated eapInput such as created
 * with eapInputLoad(). */
{
struct eapInput *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->val);
freez(pEl);
}

void eapInputFreeList(struct eapInput **pList)
/* Free a list of dynamically allocated eapInput's */
{
struct eapInput *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    eapInputFree(&el);
    }
*pList = NULL;
}

void eapInputOutput(struct eapInput *el, FILE *f, char sep, char lastSep) 
/* Print out eapInput.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->runId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->ix);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->val);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *eapOutputCommaSepFieldNames = "id,runId,name,ix,fileId,val";

void eapOutputStaticLoad(char **row, struct eapOutput *ret)
/* Load a row from eapOutput table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->runId = sqlUnsigned(row[1]);
ret->name = row[2];
ret->ix = sqlUnsigned(row[3]);
ret->fileId = sqlUnsigned(row[4]);
ret->val = row[5];
}

struct eapOutput *eapOutputLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all eapOutput from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with eapOutputFreeList(). */
{
struct eapOutput *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = eapOutputLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void eapOutputSaveToDb(struct sqlConnection *conn, struct eapOutput *el, char *tableName, int updateSize)
/* Save eapOutput as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s',%u,%u,'%s')", 
	tableName,  el->id,  el->runId,  el->name,  el->ix,  el->fileId,  el->val);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct eapOutput *eapOutputLoad(char **row)
/* Load a eapOutput from row fetched with select * from eapOutput
 * from database.  Dispose of this with eapOutputFree(). */
{
struct eapOutput *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->runId = sqlUnsigned(row[1]);
ret->name = cloneString(row[2]);
ret->ix = sqlUnsigned(row[3]);
ret->fileId = sqlUnsigned(row[4]);
ret->val = cloneString(row[5]);
return ret;
}

struct eapOutput *eapOutputLoadAll(char *fileName) 
/* Load all eapOutput from a whitespace-separated file.
 * Dispose of this with eapOutputFreeList(). */
{
struct eapOutput *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = eapOutputLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapOutput *eapOutputLoadAllByChar(char *fileName, char chopper) 
/* Load all eapOutput from a chopper separated file.
 * Dispose of this with eapOutputFreeList(). */
{
struct eapOutput *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = eapOutputLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapOutput *eapOutputCommaIn(char **pS, struct eapOutput *ret)
/* Create a eapOutput out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new eapOutput */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->runId = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->ix = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->val = sqlStringComma(&s);
*pS = s;
return ret;
}

void eapOutputFree(struct eapOutput **pEl)
/* Free a single dynamically allocated eapOutput such as created
 * with eapOutputLoad(). */
{
struct eapOutput *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->val);
freez(pEl);
}

void eapOutputFreeList(struct eapOutput **pList)
/* Free a list of dynamically allocated eapOutput's */
{
struct eapOutput *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    eapOutputFree(&el);
    }
*pList = NULL;
}

void eapOutputOutput(struct eapOutput *el, FILE *f, char sep, char lastSep) 
/* Print out eapOutput.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->runId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->ix);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->val);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *eapPhantomPeakStatsCommaSepFieldNames = "fileId,numReads,estFragLength,corrEstFragLen,phantomPeak,corrPhantomPeak,argMinCorr,minCorr,nsc,rsc,qualityTag";

void eapPhantomPeakStatsStaticLoad(char **row, struct eapPhantomPeakStats *ret)
/* Load a row from eapPhantomPeakStats table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->fileId = sqlUnsigned(row[0]);
ret->numReads = sqlUnsigned(row[1]);
ret->estFragLength = row[2];
ret->corrEstFragLen = row[3];
ret->phantomPeak = sqlSigned(row[4]);
ret->corrPhantomPeak = sqlDouble(row[5]);
ret->argMinCorr = sqlSigned(row[6]);
ret->minCorr = sqlDouble(row[7]);
ret->nsc = sqlDouble(row[8]);
ret->rsc = sqlDouble(row[9]);
ret->qualityTag = sqlSigned(row[10]);
}

struct eapPhantomPeakStats *eapPhantomPeakStatsLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all eapPhantomPeakStats from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with eapPhantomPeakStatsFreeList(). */
{
struct eapPhantomPeakStats *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = eapPhantomPeakStatsLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void eapPhantomPeakStatsSaveToDb(struct sqlConnection *conn, struct eapPhantomPeakStats *el, char *tableName, int updateSize)
/* Save eapPhantomPeakStats as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s','%s',%d,%g,%d,%g,%g,%g,%d)", 
	tableName,  el->fileId,  el->numReads,  el->estFragLength,  el->corrEstFragLen,  el->phantomPeak,  el->corrPhantomPeak,  el->argMinCorr,  el->minCorr,  el->nsc,  el->rsc,  el->qualityTag);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct eapPhantomPeakStats *eapPhantomPeakStatsLoad(char **row)
/* Load a eapPhantomPeakStats from row fetched with select * from eapPhantomPeakStats
 * from database.  Dispose of this with eapPhantomPeakStatsFree(). */
{
struct eapPhantomPeakStats *ret;

AllocVar(ret);
ret->fileId = sqlUnsigned(row[0]);
ret->numReads = sqlUnsigned(row[1]);
ret->estFragLength = cloneString(row[2]);
ret->corrEstFragLen = cloneString(row[3]);
ret->phantomPeak = sqlSigned(row[4]);
ret->corrPhantomPeak = sqlDouble(row[5]);
ret->argMinCorr = sqlSigned(row[6]);
ret->minCorr = sqlDouble(row[7]);
ret->nsc = sqlDouble(row[8]);
ret->rsc = sqlDouble(row[9]);
ret->qualityTag = sqlSigned(row[10]);
return ret;
}

struct eapPhantomPeakStats *eapPhantomPeakStatsLoadAll(char *fileName) 
/* Load all eapPhantomPeakStats from a whitespace-separated file.
 * Dispose of this with eapPhantomPeakStatsFreeList(). */
{
struct eapPhantomPeakStats *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileRow(lf, row))
    {
    el = eapPhantomPeakStatsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapPhantomPeakStats *eapPhantomPeakStatsLoadAllByChar(char *fileName, char chopper) 
/* Load all eapPhantomPeakStats from a chopper separated file.
 * Dispose of this with eapPhantomPeakStatsFreeList(). */
{
struct eapPhantomPeakStats *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = eapPhantomPeakStatsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct eapPhantomPeakStats *eapPhantomPeakStatsCommaIn(char **pS, struct eapPhantomPeakStats *ret)
/* Create a eapPhantomPeakStats out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new eapPhantomPeakStats */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->fileId = sqlUnsignedComma(&s);
ret->numReads = sqlUnsignedComma(&s);
ret->estFragLength = sqlStringComma(&s);
ret->corrEstFragLen = sqlStringComma(&s);
ret->phantomPeak = sqlSignedComma(&s);
ret->corrPhantomPeak = sqlDoubleComma(&s);
ret->argMinCorr = sqlSignedComma(&s);
ret->minCorr = sqlDoubleComma(&s);
ret->nsc = sqlDoubleComma(&s);
ret->rsc = sqlDoubleComma(&s);
ret->qualityTag = sqlSignedComma(&s);
*pS = s;
return ret;
}

void eapPhantomPeakStatsFree(struct eapPhantomPeakStats **pEl)
/* Free a single dynamically allocated eapPhantomPeakStats such as created
 * with eapPhantomPeakStatsLoad(). */
{
struct eapPhantomPeakStats *el;

if ((el = *pEl) == NULL) return;
freeMem(el->estFragLength);
freeMem(el->corrEstFragLen);
freez(pEl);
}

void eapPhantomPeakStatsFreeList(struct eapPhantomPeakStats **pList)
/* Free a list of dynamically allocated eapPhantomPeakStats's */
{
struct eapPhantomPeakStats *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    eapPhantomPeakStatsFree(&el);
    }
*pList = NULL;
}

void eapPhantomPeakStatsOutput(struct eapPhantomPeakStats *el, FILE *f, char sep, char lastSep) 
/* Print out eapPhantomPeakStats.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%u", el->numReads);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->estFragLength);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->corrEstFragLen);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->phantomPeak);
fputc(sep,f);
fprintf(f, "%g", el->corrPhantomPeak);
fputc(sep,f);
fprintf(f, "%d", el->argMinCorr);
fputc(sep,f);
fprintf(f, "%g", el->minCorr);
fputc(sep,f);
fprintf(f, "%g", el->nsc);
fputc(sep,f);
fprintf(f, "%g", el->rsc);
fputc(sep,f);
fprintf(f, "%d", el->qualityTag);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

