/* affy10KDetails.h was originally generated by the autoSql program, which also 
 * generated affy10KDetails.c and affy10KDetails.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef AFFY10KDETAILS_H
#define AFFY10KDETAILS_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define AFFY10KDETAILS_NUM_COLS 8

struct affy10KDetails
/* Information from affy10KDetails representing the Affymetrix 10K Mapping Array */
    {
    struct affy10KDetails *next;  /* Next in singly linked list. */
    char *affyId;	/* Affymetrix SNP id */
    char *rsId;	/* RS identifier (some are null) */
    char *tscId;	/* TSC identifier (some are null) */
    char baseA[3];	/* The first allele (A) */
    char baseB[3];	/* The second allele (B) */
    char sequenceA[35];	/* The A allele with flanking sequence */
    char sequenceB[35];	/* The B allele with flanking sequence */
    char enzyme[9];	/* The enzyme that was used to prepare the sample (HindIII or XbaI) */
    };

void affy10KDetailsStaticLoad(char **row, struct affy10KDetails *ret);
/* Load a row from affy10KDetails table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct affy10KDetails *affy10KDetailsLoad(char **row);
/* Load a affy10KDetails from row fetched with select * from affy10KDetails
 * from database.  Dispose of this with affy10KDetailsFree(). */

struct affy10KDetails *affy10KDetailsLoadAll(char *fileName);
/* Load all affy10KDetails from whitespace-separated file.
 * Dispose of this with affy10KDetailsFreeList(). */

struct affy10KDetails *affy10KDetailsLoadAllByChar(char *fileName, char chopper);
/* Load all affy10KDetails from chopper separated file.
 * Dispose of this with affy10KDetailsFreeList(). */

#define affy10KDetailsLoadAllByTab(a) affy10KDetailsLoadAllByChar(a, '\t');
/* Load all affy10KDetails from tab separated file.
 * Dispose of this with affy10KDetailsFreeList(). */

struct affy10KDetails *affy10KDetailsLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all affy10KDetails from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with affy10KDetailsFreeList(). */

void affy10KDetailsSaveToDb(struct sqlConnection *conn, struct affy10KDetails *el, char *tableName, int updateSize);
/* Save affy10KDetails as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct affy10KDetails *affy10KDetailsCommaIn(char **pS, struct affy10KDetails *ret);
/* Create a affy10KDetails out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new affy10KDetails */

void affy10KDetailsFree(struct affy10KDetails **pEl);
/* Free a single dynamically allocated affy10KDetails such as created
 * with affy10KDetailsLoad(). */

void affy10KDetailsFreeList(struct affy10KDetails **pList);
/* Free a list of dynamically allocated affy10KDetails's */

void affy10KDetailsOutput(struct affy10KDetails *el, FILE *f, char sep, char lastSep);
/* Print out affy10KDetails.  Separate fields with sep. Follow last field with lastSep. */

#define affy10KDetailsTabOut(el,f) affy10KDetailsOutput(el,f,'\t','\n');
/* Print out affy10KDetails as a line in a tab-separated file. */

#define affy10KDetailsCommaOut(el,f) affy10KDetailsOutput(el,f,',',',');
/* Print out affy10KDetails as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* AFFY10KDETAILS_H */

