/* bigLink.h was originally generated by the autoSql program, which also 
 * generated bigLink.c and bigLink.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BIGLINK_H
#define BIGLINK_H

#define BIGLINK_NUM_COLS 5

extern char *bigLinkCommaSepFieldNames;

struct bigLink
/* bigLink pairwise alignment */
    {
    struct bigLink *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name or ID of item, ideally both human readable and unique */
    unsigned qStart;	/* start of alignment on query sequence */
    };

void bigLinkStaticLoad(char **row, struct bigLink *ret);
/* Load a row from bigLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bigLink *bigLinkLoad(char **row);
/* Load a bigLink from row fetched with select * from bigLink
 * from database.  Dispose of this with bigLinkFree(). */

struct bigLink *bigLinkLoadAll(char *fileName);
/* Load all bigLink from whitespace-separated file.
 * Dispose of this with bigLinkFreeList(). */

struct bigLink *bigLinkLoadAllByChar(char *fileName, char chopper);
/* Load all bigLink from chopper separated file.
 * Dispose of this with bigLinkFreeList(). */

#define bigLinkLoadAllByTab(a) bigLinkLoadAllByChar(a, '\t');
/* Load all bigLink from tab separated file.
 * Dispose of this with bigLinkFreeList(). */

struct bigLink *bigLinkCommaIn(char **pS, struct bigLink *ret);
/* Create a bigLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bigLink */

void bigLinkFree(struct bigLink **pEl);
/* Free a single dynamically allocated bigLink such as created
 * with bigLinkLoad(). */

void bigLinkFreeList(struct bigLink **pList);
/* Free a list of dynamically allocated bigLink's */

void bigLinkOutput(struct bigLink *el, FILE *f, char sep, char lastSep);
/* Print out bigLink.  Separate fields with sep. Follow last field with lastSep. */

#define bigLinkTabOut(el,f) bigLinkOutput(el,f,'\t','\n');
/* Print out bigLink as a line in a tab-separated file. */

#define bigLinkCommaOut(el,f) bigLinkOutput(el,f,',',',');
/* Print out bigLink as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

int bigLinkCmpTarget(const void *va, const void *vb);
/* Compare to sort based on target position. */

#endif /* BIGLINK_H */

