/* expData.h was originally generated by the autoSql program, which also 
 * generated expData.c and expData.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2006 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef EXPDATA_H
#define EXPDATA_H

#define EXPDATA_NUM_COLS 3

struct expData
/* Expression data (no mapping, just spots) */
    {
    struct expData *next;  /* Next in singly linked list. */
    char *name;	/* Name of gene/target/probe etc. */
    unsigned expCount;	/* Number of scores */
    float *expScores;	/* Scores. May be absolute or relative ratio */
    };

struct expData *expDataLoad(char **row);
/* Load a expData from row fetched with select * from expData
 * from database.  Dispose of this with expDataFree(). */

struct expData *expDataLoadAll(char *fileName);
/* Load all expData from whitespace-separated file.
 * Dispose of this with expDataFreeList(). */

struct expData *expDataLoadAllByChar(char *fileName, char chopper);
/* Load all expData from chopper separated file.
 * Dispose of this with expDataFreeList(). */

#define expDataLoadAllByTab(a) expDataLoadAllByChar(a, '\t');
/* Load all expData from tab separated file.
 * Dispose of this with expDataFreeList(). */

struct expData *expDataCommaIn(char **pS, struct expData *ret);
/* Create a expData out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new expData */

void expDataFree(struct expData **pEl);
/* Free a single dynamically allocated expData such as created
 * with expDataLoad(). */

void expDataFreeList(struct expData **pList);
/* Free a list of dynamically allocated expData's */

void expDataOutput(struct expData *el, FILE *f, char sep, char lastSep);
/* Print out expData.  Separate fields with sep. Follow last field with lastSep. */

#define expDataTabOut(el,f) expDataOutput(el,f,'\t','\n');
/* Print out expData as a line in a tab-separated file. */

#define expDataCommaOut(el,f) expDataOutput(el,f,',',',');
/* Print out expData as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void expDataCreateTable(struct sqlConnection *conn, char *table);
/* Create table with given name. */

struct expData *expDataLoadTableLimit(struct sqlConnection *conn, char *table, int limitRows);
/* Same as expDataLoadTable, but limit to only loading limitRows # of rows. */

struct expData *expDataLoadTable(struct sqlConnection *conn, char *table);
/* Load all the rows of an SQL table (already connected to the database) */
/* into a list and return it. This should work on BED 15 tables as well */
/* as native expData tables. */

struct expData *expDataConnectAndLoadTable(char *database, char *table);
/* Same thing as expDataLoadTableConn, but it does the extra step of */
/* connecting to a database first. */

#endif /* EXPDATA_H */

