/* hubSpaceKeys.h was originally generated by the autoSql program, which also 
 * generated hubSpaceKeys.c and hubSpaceKeys.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef HUBSPACEKEYS_H
#define HUBSPACEKEYS_H

#define HUBSPACEKEYS_NUM_COLS 2

extern char *hubSpaceKeysCommaSepFieldNames;

struct hubSpaceKeys
/* Api keys for userNames to upload to hubSpace using hubtools */
    {
    struct hubSpaceKeys *next;  /* Next in singly linked list. */
    char *userName;	/* userName in gbMembers */
    char *apiKey;	/* random key */
    };

void hubSpaceKeysStaticLoad(char **row, struct hubSpaceKeys *ret);
/* Load a row from hubSpaceKeys table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct hubSpaceKeys *hubSpaceKeysLoad(char **row);
/* Load a hubSpaceKeys from row fetched with select * from hubSpaceKeys
 * from database.  Dispose of this with hubSpaceKeysFree(). */

struct hubSpaceKeys *hubSpaceKeysLoadAll(char *fileName);
/* Load all hubSpaceKeys from whitespace-separated file.
 * Dispose of this with hubSpaceKeysFreeList(). */

struct hubSpaceKeys *hubSpaceKeysLoadAllByChar(char *fileName, char chopper);
/* Load all hubSpaceKeys from chopper separated file.
 * Dispose of this with hubSpaceKeysFreeList(). */

#define hubSpaceKeysLoadAllByTab(a) hubSpaceKeysLoadAllByChar(a, '\t');
/* Load all hubSpaceKeys from tab separated file.
 * Dispose of this with hubSpaceKeysFreeList(). */

struct hubSpaceKeys *hubSpaceKeysCommaIn(char **pS, struct hubSpaceKeys *ret);
/* Create a hubSpaceKeys out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hubSpaceKeys */

void hubSpaceKeysFree(struct hubSpaceKeys **pEl);
/* Free a single dynamically allocated hubSpaceKeys such as created
 * with hubSpaceKeysLoad(). */

void hubSpaceKeysFreeList(struct hubSpaceKeys **pList);
/* Free a list of dynamically allocated hubSpaceKeys's */

void hubSpaceKeysOutput(struct hubSpaceKeys *el, FILE *f, char sep, char lastSep);
/* Print out hubSpaceKeys.  Separate fields with sep. Follow last field with lastSep. */

#define hubSpaceKeysTabOut(el,f) hubSpaceKeysOutput(el,f,'\t','\n');
/* Print out hubSpaceKeys as a line in a tab-separated file. */

#define hubSpaceKeysCommaOut(el,f) hubSpaceKeysOutput(el,f,',',',');
/* Print out hubSpaceKeys as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#define AUTH_TABLE_DEFAULT "apiKeys"

char *userNameForApiKey(struct sqlConnection *conn, char *apiKey);
/* Return userName associated with apiKey else NULL. If conn is NULL, will create a connection and free it. */

#endif /* HUBSPACEKEYS_H */

