/* chainGap.c was originally generated by the autoSql program, which also 
 * generated chainGap.h and chainGap.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "chainGap.h"


void chainGapStaticLoad(char **row, struct chainGap *ret)
/* Load a row from chainGap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
int sizeOne,i;
char *s;

ret->tName = row[0];
ret->tStart = sqlUnsigned(row[1]);
ret->tEnd = sqlUnsigned(row[2]);
ret->qStart = sqlUnsigned(row[3]);
ret->chainId = sqlUnsigned(row[4]);
}

struct chainGap *chainGapLoad(char **row)
/* Load a chainGap from row fetched with select * from chainGap
 * from database.  Dispose of this with chainGapFree(). */
{
struct chainGap *ret;
int sizeOne,i;
char *s;

AllocVar(ret);
ret->tName = cloneString(row[0]);
ret->tStart = sqlUnsigned(row[1]);
ret->tEnd = sqlUnsigned(row[2]);
ret->qStart = sqlUnsigned(row[3]);
ret->chainId = sqlUnsigned(row[4]);
return ret;
}

struct chainGap *chainGapLoadAll(char *fileName) 
/* Load all chainGap from a tab-separated file.
 * Dispose of this with chainGapFreeList(). */
{
struct chainGap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = chainGapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct chainGap *chainGapCommaIn(char **pS, struct chainGap *ret)
/* Create a chainGap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new chainGap */
{
char *s = *pS;
int i;

if (ret == NULL)
    AllocVar(ret);
ret->tName = sqlStringComma(&s);
ret->tStart = sqlUnsignedComma(&s);
ret->tEnd = sqlUnsignedComma(&s);
ret->qStart = sqlUnsignedComma(&s);
ret->chainId = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void chainGapFree(struct chainGap **pEl)
/* Free a single dynamically allocated chainGap such as created
 * with chainGapLoad(). */
{
struct chainGap *el;

if ((el = *pEl) == NULL) return;
freeMem(el->tName);
freez(pEl);
}

void chainGapFreeList(struct chainGap **pList)
/* Free a list of dynamically allocated chainGap's */
{
struct chainGap *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    chainGapFree(&el);
    }
*pList = NULL;
}

void chainGapOutput(struct chainGap *el, FILE *f, char sep, char lastSep) 
/* Print out chainGap.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->tStart);
fputc(sep,f);
fprintf(f, "%u", el->tEnd);
fputc(sep,f);
fprintf(f, "%u", el->qStart);
fputc(sep,f);
fprintf(f, "%u", el->chainId);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

