# interact.sql was originally generated by the autoSql program, which also 
# generated interact.c and interact.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Interaction between two regions
CREATE TABLE interact (
    chrom varchar(255) not null,	# Chromosome (or contig, scaffold, etc.). For interchromosomal, use 2 records
    chromStart int unsigned not null,	# Start position in chromosome of lower region. For interchromosomal, set to chromStart of this region
    chromEnd int unsigned not null,	# End position in chromosome of upper region. For interchromosomal, set to chromEnd of this region
    name varchar(255) not null,	# Name of item, for display.  Usually 'name1/name2' or empty
    score int unsigned not null,	# Score from 0-1000.
    value double not null,	# Strength of interaction or other data value. Typically basis for score
    exp varchar(255) not null,	# Experiment name (metadata for filtering). Use . if not applicable
    color int unsigned not null,	# Item color, as itemRgb in bed9. Typically based on strength or filter
    sourceChrom varchar(255) not null,	# Chromosome of source region (directional) or lower region. For non-directional interchromosomal, chrom of this region.
    sourceStart int unsigned not null,	# Start position in chromosome of source/lower/this region
    sourceEnd int unsigned not null,	# End position in chromosome of source/lower/this region
    sourceName varchar(255) not null,	# Identifier of source/lower/this region. Can be used as link to related table
    sourceStrand varchar(255) not null,	# Orientation of source/lower/this region: + or -.  Use . if not applicable
    targetChrom varchar(255) not null,	# Chromosome of target region (directional) or upper region. For non-directional interchromosomal, chrom of other region
    targetStart int unsigned not null,	# Start position in chromosome of target/upper/this region
    targetEnd int unsigned not null,	# End position in chromosome of target/upper/this region
    targetName varchar(255) not null,	# Identifier of target/upper/this region. Can be used as link to related table
    targetStrand varchar(255) not null,	# Orientation of target/upper/this region: + or -.  Use . if not applicable
              #Indices
    INDEX(chrom(20), chromStart),
    INDEX(name)
);
