/* refLink.c was originally generated by the autoSql program, which also 
 * generated refLink.h and refLink.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "jksql.h"
#include "refLink.h"


void refLinkStaticLoad(char **row, struct refLink *ret)
/* Load a row from refLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->product = row[1];
ret->mrnaAcc = row[2];
ret->protAcc = row[3];
ret->geneId = sqlUnsigned(row[4]);
ret->prodId = sqlUnsigned(row[5]);
ret->locusLinkId = sqlUnsigned(row[6]);
ret->omimId = sqlUnsigned(row[7]);
}

struct refLink *refLinkLoad(char **row)
/* Load a refLink from row fetched with select * from refLink
 * from database.  Dispose of this with refLinkFree(). */
{
struct refLink *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->product = cloneString(row[1]);
ret->mrnaAcc = cloneString(row[2]);
ret->protAcc = cloneString(row[3]);
ret->geneId = sqlUnsigned(row[4]);
ret->prodId = sqlUnsigned(row[5]);
ret->locusLinkId = sqlUnsigned(row[6]);
ret->omimId = sqlUnsigned(row[7]);
return ret;
}

struct refLink *refLinkLoadAll(char *fileName) 
/* Load all refLink from a tab-separated file.
 * Dispose of this with refLinkFreeList(). */
{
struct refLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = refLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct refLink *refLinkCommaIn(char **pS, struct refLink *ret)
/* Create a refLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new refLink */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->product = sqlStringComma(&s);
ret->mrnaAcc = sqlStringComma(&s);
ret->protAcc = sqlStringComma(&s);
ret->geneId = sqlUnsignedComma(&s);
ret->prodId = sqlUnsignedComma(&s);
ret->locusLinkId = sqlUnsignedComma(&s);
ret->omimId = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void refLinkFree(struct refLink **pEl)
/* Free a single dynamically allocated refLink such as created
 * with refLinkLoad(). */
{
struct refLink *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->product);
freeMem(el->mrnaAcc);
freeMem(el->protAcc);
freez(pEl);
}

void refLinkFreeList(struct refLink **pList)
/* Free a list of dynamically allocated refLink's */
{
struct refLink *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    refLinkFree(&el);
    }
*pList = NULL;
}

void refLinkOutput(struct refLink *el, FILE *f, char sep, char lastSep) 
/* Print out refLink.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->product);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mrnaAcc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->protAcc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->geneId);
fputc(sep,f);
fprintf(f, "%u", el->prodId);
fputc(sep,f);
fprintf(f, "%u", el->locusLinkId);
fputc(sep,f);
fprintf(f, "%u", el->omimId);
fputc(lastSep,f);
}

